/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;

import java.io.*;
import java.util.*; // import java.util.HashMap;
import javax.swing.*;

import GoGrinder.ui.*;
import GoGrinder.sgf.*;

/**
 *
 * @author  tkington
 * @author  Ruediger Klehn
 */
public class FileUtils {
    private static HashMap genreMap;
    public static String splitThis = "";
    public static boolean splitting = false;
    private JFileChooser chooser;
    static final String NL = Main.NEW_LINE;
    
    /** Creates a new instance of Utils */ // here were, in some dark past, fileUtils.extractProblems(progDlg); 
    public FileUtils(JFileChooser ch) {    // from ProbFrame with the DEFAULT JFileChooser //ALT: chooser from Main
        init(); // o.k., if it is the first use of the program, it creates some tags, which are also used by goproblems.com
        chooser = ch; // but... why does this need a chooser in advance? - ch is local, chooser is private
    }
    
    public FileUtils(){
      init();
    }
    
    public void splitFile() { // this could be in a separate class 
                              // we could also try to split files with all problems in the main branch
        splitThis = FileWorks.selectFile(null, FileFilters.sgfFilter, Messages.getString("select_sgf_file"),
                                                          false, Messages.getString("split")); // false: need write = no
        if (splitThis == null || splitThis.equals("") ) // "No file for splitting selected."
            return;
        //File f = new File(splitThis);   
        
        // This expects, that you want the split-result in your Grinder's problems folder - but this shouldn't be needed
        File[] useFolderA = FileWorks.selectFolder(1, Messages.getString("select_dir_for_new_probs"), 
                                                   Messages.getString("save"), Main.pathToProblems, true);
        File dir = useFolderA[0];
          // NEED CHANGE: if dir is not subdir of problems, then no need to reread the problems dir when ready
        if(dir == null || dir.toString().equals("")) // "No folder for the output selected."
            return;
        splitting = true;
        String useCharset = GS.getMyDefaultCharset(); // we can later let the user select the charset and write it to the files
        String dataStr = FileWReadWrite.readFileStrCharset(splitThis, useCharset);
            // if no CA[...] in the file, let the user decide the
            // decoding ... and then we insert CA[...] in the resulting files
        try{
          SGFParser.split(dir, splitThis, dataStr, useCharset);
          JOptionPane.showMessageDialog(ProbFrame.inst, Messages.getString("split_complete"));
        }
        catch(Exception e){ //all exceptions already caught in the parser? ("throws SGFParseException")
          
          String splitterMsg = "Problem while splitting file (in SGFParser.split)" + NL + e.getMessage(); // : " + filename;
          JOptionPane.showMessageDialog(ProbFrame.inst, "\n" + splitterMsg); //Messages.getString("err_parsing_sgf") + 
            // Main.logSilent(e);
        }
        splitting = false;
        ReloadDialog.reloadProblems(ProbFrame.inst);
    }
    
    private void init() { // the tgz-thing thrown out - but some parts are still there
        // initGenreMap - needed for the goproblems.com thing, but also on the program's first use, these are created for the user
        if(genreMap != null)  // why is this connected to File? Actually it's about importing from goproblems.com
                              // here the genre is read (GE[genre]) from the head of the SGF
                              // it seems to be a forgotten leftover from "Import from goproblems.com"
                              // right!, -> see GoGrinder 1.07
                              // ? when this is null, then it is a fresh installation without grind.dat?
                              // how can genreMap != null ? - ~security question?
                              // above is written private static HashMap genreMap;
                              // AH!: public FileUtils(...)
            return;
                              // HashMap: two values become connected, e.g. "ladder" + equivalent from translations
        genreMap = new HashMap();  // what has this to do with File? - it is more something with tags
                                   // it is connected to goproblems.com genre //processGoproblemsComTgz
        genreMap.put("life and death", Messages.getString("life_and_death"));
        genreMap.put("joseki", Messages.getString("joseki"));
        genreMap.put("tesuji", Messages.getString("tesuji"));
        genreMap.put("endgame", Messages.getString("endgame"));
        genreMap.put("best move", Messages.getString("best_move"));
        genreMap.put("fuseki", Messages.getString("fuseki"));
        genreMap.put("ladder", Messages.getString("ladder"));
        genreMap.put("ko", Messages.getString("ko"));
    }
}
