/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.dsl.impl;

import io.github.eb4j.dsl.index.DslIndex;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dict.zip.DictZipInputStream;
import org.dict.zip.RandomAccessInputStream;

public class EntriesLoaderImpl
implements AutoCloseable {
    private final boolean isDictZip;
    private final Charset charset;
    private DictZipInputStream dzis;
    private RandomAccessInputStream rais;
    private final byte[] eol;
    private final byte[] cr;
    private final byte[] lf;
    private final byte[] tab;
    private final byte[] space;
    private final byte[] commentStart;
    private final byte[] sharp;

    public EntriesLoaderImpl(Path path, boolean isDictZip, Charset charset, byte[] eol) throws IOException {
        this.isDictZip = isDictZip;
        this.charset = charset;
        if (isDictZip) {
            this.dzis = new DictZipInputStream(new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r")));
        } else {
            this.rais = new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r"));
        }
        this.eol = Arrays.copyOf(eol, eol.length);
        this.cr = "\r".getBytes(charset);
        this.lf = "\n".getBytes(charset);
        this.tab = "\t".getBytes(charset);
        this.space = " ".getBytes(charset);
        this.commentStart = "{{".getBytes(charset);
        this.sharp = "#".getBytes(charset);
    }

    @Override
    public void close() throws IOException {
        if (this.isDictZip) {
            this.dzis.close();
        } else {
            this.rais.close();
        }
    }

    public List<DslIndex.Entry> load() throws IOException {
        ArrayList<DslIndex.Entry> entries = new ArrayList<DslIndex.Entry>();
        long cardStart = this.entryStartSearch();
        while (true) {
            String[] tokens;
            long next = this.skipComment();
            long headWordLen = this.eolSearch();
            if (headWordLen == -1L) break;
            while (!this.isSpaceOrTab() && (next = this.eolSearch()) != -1L) {
                headWordLen += next;
            }
            this.seek(cardStart);
            byte[] headWordBytes = new byte[(int)headWordLen];
            this.readFully(headWordBytes);
            String headWords = new String(headWordBytes, this.charset).trim();
            long spaces = this.skipSpaceTabs();
            long articleStart = cardStart + headWordLen + spaces;
            this.seek(articleStart);
            long articleLen = this.cardEndSearch();
            for (String token : tokens = headWords.split("\\r?\\n")) {
                entries.add(DslIndex.Entry.newBuilder().setHeadWord(token).setOffset(articleStart).setSize((int)articleLen).setHeaderOffset(cardStart).setHeaderSize((int)headWordLen).build());
            }
            cardStart = articleStart + articleLen;
            if (this.isEof()) break;
            this.seek(cardStart);
            int empty = this.skipEmptyLine();
            if (empty == -1 || this.isEof()) break;
            cardStart += (long)empty;
        }
        return entries;
    }

    private void seek(long pos) throws IOException {
        if (this.isDictZip) {
            this.dzis.seek(pos);
        } else {
            this.rais.seek(pos);
        }
    }

    private boolean isEof() throws IOException {
        if (this.isDictZip) {
            return this.dzis.available() <= 0;
        }
        return this.rais.available() <= 0;
    }

    private long position() throws IOException {
        if (this.isDictZip) {
            return this.dzis.position();
        }
        return this.rais.position();
    }

    private long skipComment() throws IOException {
        byte[] b = new byte[this.commentStart.length];
        Object is = this.isDictZip ? this.dzis : this.rais;
        is.mark(this.commentStart.length);
        if (is.read(b) > 0) {
            if (Arrays.equals(this.commentStart, b)) {
                return this.eolSearch();
            }
            is.reset();
            return 0L;
        }
        return -1L;
    }

    private long entryStartSearch() throws IOException {
        byte[] b = new byte[this.sharp.length];
        Object is = this.isDictZip ? this.dzis : this.rais;
        if (this.eolSearch() == -1L) {
            return -1L;
        }
        is.mark(this.sharp.length);
        while (is.read(b) != 0) {
            if (Arrays.equals(this.sharp, b)) {
                if (this.eolSearch() == -1L) {
                    break;
                }
            } else {
                if (Arrays.equals(this.cr, b) || Arrays.equals(this.lf, b)) {
                    is.mark(this.sharp.length);
                    continue;
                }
                is.reset();
                return this.position();
            }
            is.mark(this.sharp.length);
        }
        return -1L;
    }

    private long cardEndSearch() throws IOException {
        byte[] b = new byte[this.tab.length];
        long current = this.position();
        Object is = this.isDictZip ? this.dzis : this.rais;
        long len = this.eolSearch();
        if (len == -1L) {
            return this.position() - current;
        }
        boolean eof = true;
        while (is.read(b) != 0) {
            if (!Arrays.equals(this.tab, b) && !Arrays.equals(this.space, b)) {
                eof = false;
                break;
            }
            len = this.eolSearch();
            if (len != -1L) continue;
        }
        if (eof) {
            return this.position() - current;
        }
        return this.position() - current - (long)this.tab.length;
    }

    private long skipSpaceTabs() throws IOException {
        long readBytes = 0L;
        Object is = this.isDictZip ? this.dzis : this.rais;
        is.mark(this.tab.length);
        while (this.isSpaceOrTab()) {
            readBytes += (long)this.tab.length;
            is.mark(this.tab.length);
        }
        is.reset();
        return readBytes;
    }

    private void readFully(byte[] buffer) throws IOException {
        if (this.isDictZip) {
            this.dzis.readFully(buffer);
        } else {
            this.rais.readFully(buffer);
        }
    }

    private boolean isSpaceOrTab() throws IOException {
        byte[] b;
        Object is = this.isDictZip ? this.dzis : this.rais;
        if (is.read(b = new byte[this.tab.length]) != 0) {
            return Arrays.equals(this.tab, b) || Arrays.equals(this.space, b);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int skipEmptyLine() throws IOException {
        void var3_5;
        int readByte = 0;
        byte[] b = new byte[this.cr.length];
        if (this.isDictZip) {
            DictZipInputStream dictZipInputStream = this.dzis;
        } else {
            RandomAccessInputStream randomAccessInputStream = this.rais;
        }
        var3_5.mark(this.cr.length);
        while (var3_5.read(b) > 0) {
            if (Arrays.equals(this.cr, b)) {
                readByte += this.cr.length;
                if (var3_5.read(b) == 0 || !Arrays.equals(this.lf, b)) throw new IOException("CR without LF line termination.");
                readByte += this.lf.length;
            } else {
                if (!Arrays.equals(this.lf, b)) {
                    var3_5.reset();
                    return readByte;
                }
                readByte += this.lf.length;
            }
            var3_5.mark(this.cr.length);
        }
        return -1;
    }

    private long eolSearch() throws IOException {
        int b;
        Object stream = this.isDictZip ? this.dzis : this.rais;
        long current = this.position();
        boolean isBE = StandardCharsets.UTF_16BE.equals(this.charset);
        boolean isUTF16 = StandardCharsets.UTF_16LE.equals(this.charset) || isBE;
        byte prev = 0;
        while ((b = stream.read()) != -1) {
            if ((byte)b != 10) {
                prev = (byte)b;
                continue;
            }
            if (!isUTF16) {
                return this.position() - current;
            }
            if (isBE) {
                if (prev != 0) continue;
                return this.position() - current;
            }
            b = stream.read();
            if (b == -1) {
                return -1L;
            }
            if (b != 0) continue;
            return this.position() - current;
        }
        return -1L;
    }
}

