/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.SearchExpression;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchMode;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public class Searcher {
    private volatile List<SearchResultEntry> m_searchResults;
    private boolean m_preprocessResults;
    private final IProject m_project;
    private Map<String, Integer> m_tmxMap;
    private Map<String, Integer> m_entryMap;
    private List<Matcher> m_matchers;
    private Matcher m_author;
    private int m_numFinds;
    private final SearchExpression searchExpression;
    private LongProcessThread checkStop;
    private final List<SearchMatch> foundMatches = new ArrayList<SearchMatch>();
    private static final int ENTRY_ORIGIN_PROJECT_MEMORY = 0;
    private static final int ENTRY_ORIGIN_TRANSLATION_MEMORY = -1;
    private static final int ENTRY_ORIGIN_ORPHAN = -2;
    private static final int ENTRY_ORIGIN_ALTERNATIVE = -3;
    private static final int ENTRY_ORIGIN_GLOSSARY = -4;
    private static final int ENTRY_ORIGIN_TEXT = -5;

    public Searcher(IProject project, SearchExpression searchExpression) {
        this.m_project = project;
        this.searchExpression = searchExpression;
    }

    public void setThread(LongProcessThread thread) {
        this.checkStop = thread;
    }

    public SearchExpression getExpression() {
        return this.searchExpression;
    }

    public List<SearchResultEntry> getSearchResults() {
        if (this.m_preprocessResults) {
            this.m_preprocessResults = false;
            if (!this.searchExpression.allResults) {
                for (SearchResultEntry entry : this.m_searchResults) {
                    String key = entry.getSrcText() + entry.getTranslation();
                    if (entry.getEntryNum() == -1) {
                        if (!this.m_tmxMap.containsKey(key) || this.m_tmxMap.get(key) <= 0) continue;
                        entry.setPreamble(this.updatePreamble(entry, this.m_tmxMap.get(key)));
                        continue;
                    }
                    if (entry.getEntryNum() <= 0 || !this.m_entryMap.containsKey(key) || this.m_entryMap.get(key) <= 0) continue;
                    entry.setPreamble(this.updatePreamble(entry, this.m_entryMap.get(key)));
                }
            }
        }
        return this.m_searchResults;
    }

    private String updatePreamble(SearchResultEntry entry, int matchNumber) {
        return StringUtil.isEmpty(entry.getPreamble()) ? StringUtil.format(OStrings.getString("SW_NR_MATCHES"), 1 + matchNumber) : StringUtil.format(OStrings.getString("SW_FILE_AND_NR_OF_MORE"), entry.getPreamble(), matchNumber);
    }

    public void search() throws Exception {
        int flags;
        String text = this.searchExpression.text;
        String author = this.searchExpression.author;
        this.m_searchResults = new ArrayList<SearchResultEntry>();
        this.m_numFinds = 0;
        this.m_preprocessResults = true;
        this.m_entryMap = null;
        this.m_entryMap = new HashMap<String, Integer>();
        this.m_tmxMap = new HashMap<String, Integer>();
        this.m_matchers = new ArrayList<Matcher>();
        int n = flags = this.searchExpression.caseSensitive ? 0 : 66;
        if (this.searchExpression.widthInsensitive) {
            text = StringUtil.normalizeWidth(text);
        }
        switch (this.searchExpression.searchExpressionType) {
            default: {
                text = StaticUtils.globToRegex(text, this.searchExpression.spaceMatchNbsp);
                this.m_matchers.add(Pattern.compile(text, flags).matcher(""));
                break;
            }
            case KEYWORD: {
                Pattern.compile(" ").splitAsStream(text.trim()).filter(word -> !word.isEmpty()).map(word -> {
                    String glob = StaticUtils.globToRegex(word, false);
                    return Pattern.compile(glob, flags).matcher("");
                }).forEach(this.m_matchers::add);
                break;
            }
            case REGEXP: {
                if (this.searchExpression.spaceMatchNbsp) {
                    text = text.replaceAll(" ", "( |\u00a0)");
                    text = text.replaceAll("\\\\s", "(\\\\s|\u00a0)");
                }
                this.m_matchers.add(Pattern.compile(text, flags).matcher(""));
            }
        }
        if (this.searchExpression.searchExpressionType != SearchExpression.SearchExpressionType.REGEXP) {
            author = StaticUtils.globToRegex(author, this.searchExpression.spaceMatchNbsp);
        }
        this.m_author = Pattern.compile(author, flags).matcher("");
        if (this.searchExpression.rootDir == null) {
            this.searchProject();
        } else {
            this.searchFiles();
        }
    }

    private void addEntry(int num, String preamble, String srcPrefix, String src, String target, String note, String property, SearchMatch[] srcMatch, SearchMatch[] targetMatch, SearchMatch[] noteMatch, SearchMatch[] propertyMatch) {
        SearchResultEntry entry = new SearchResultEntry(num, preamble, srcPrefix, src, target, note, property, srcMatch, targetMatch, noteMatch, propertyMatch);
        this.m_searchResults.add(entry);
        ++this.m_numFinds;
    }

    private void foundString(int entryNum, String intro, String src, String target, String note, String property, SearchMatch[] srcMatches, SearchMatch[] targetMatches, SearchMatch[] noteMatches, SearchMatch[] propertyMatches) {
        if (this.m_numFinds >= this.searchExpression.numberOfResults) {
            return;
        }
        String key = src + target;
        if (entryNum >= 0) {
            this.addProjectMemoryEntry(entryNum, src, target, note, property, srcMatches, targetMatches, noteMatches, propertyMatches, key);
        } else if (entryNum == -1) {
            this.addTranslationMemoryEntry(entryNum, intro, src, target, note, property, srcMatches, targetMatches, noteMatches, propertyMatches, key);
        } else {
            this.addEntry(entryNum, intro, null, src, target, note, property, srcMatches, targetMatches, noteMatches, propertyMatches);
        }
    }

    private void addTranslationMemoryEntry(int entryNum, String intro, String src, String target, String note, String property, SearchMatch[] srcMatches, SearchMatch[] targetMatches, SearchMatch[] noteMatches, SearchMatch[] propertyMatches, String key) {
        if (!this.m_tmxMap.containsKey(key) || this.searchExpression.allResults) {
            this.addEntry(entryNum, intro, null, src, target, note, property, srcMatches, targetMatches, noteMatches, propertyMatches);
            if (!this.searchExpression.allResults) {
                this.m_tmxMap.put(key, 0);
            }
        } else {
            this.m_tmxMap.put(key, this.m_tmxMap.get(key) + 1);
        }
    }

    private void addProjectMemoryEntry(int entryNum, String src, String target, String note, String property, SearchMatch[] srcMatches, SearchMatch[] targetMatches, SearchMatch[] noteMatches, SearchMatch[] propertyMatches, String key) {
        if (!this.m_entryMap.containsKey(key) || this.searchExpression.allResults) {
            String file = this.searchExpression.fileNames ? this.getFileForEntry(entryNum + 1) : null;
            this.addEntry(entryNum + 1, file, entryNum + 1 + "> ", src, target, note, property, srcMatches, targetMatches, noteMatches, propertyMatches);
            if (!this.searchExpression.allResults) {
                this.m_entryMap.put(key, 0);
            }
        } else {
            this.m_entryMap.put(key, this.m_entryMap.get(key) + 1);
        }
    }

    private void searchProject() {
        this.m_numFinds = 0;
        try {
            this.searchMemory();
            this.searchExternalTM();
            this.searchGlossary();
        }
        catch (SearchLimitReachedException searchLimitReachedException) {
            // empty catch block
        }
    }

    private void searchGlossary() throws SearchLimitReachedException {
        if (this.searchExpression.glossary) {
            String intro = OStrings.getString("SW_GLOSSARY_RESULT");
            List<GlossaryEntry> entries = Core.getGlossaryManager().getLocalEntries();
            for (GlossaryEntry en : entries) {
                this.checkEntry(en.getSrcText(), en.getLocText(), null, null, null, -4, intro);
                if (this.m_numFinds >= this.searchExpression.numberOfResults) {
                    throw new SearchLimitReachedException();
                }
                this.checkStop.checkInterrupted();
            }
        }
    }

    private void searchExternalTM() throws SearchLimitReachedException {
        if (this.searchExpression.tm) {
            Path projectRoot = Paths.get(this.m_project.getProjectProperties().getProjectRoot(), new String[0]);
            if (!(this.searchExpression.searchAuthor || this.searchExpression.searchDateAfter || this.searchExpression.searchDateBefore)) {
                for (Map.Entry<String, ExternalTMX> entry : this.m_project.getTransMemories().entrySet()) {
                    String fileTM = this.searchExpression.fileNames ? projectRoot.relativize(Paths.get(entry.getKey(), new String[0])).toString() : null;
                    this.searchEntries(entry.getValue().getEntries(), -1, fileTM);
                    this.checkStop.checkInterrupted();
                }
                for (Map.Entry<Object, Object> entry : this.m_project.getOtherTargetLanguageTMs().entrySet()) {
                    Language langTM = (Language)entry.getKey();
                    this.searchEntries(((ProjectTMX)entry.getValue()).getDefaults(), -3, langTM.getLanguage());
                    this.searchEntries(((ProjectTMX)entry.getValue()).getAlternatives(), -3, langTM.getLanguage());
                    this.checkStop.checkInterrupted();
                }
            }
        }
    }

    private void searchMemory() throws SearchLimitReachedException {
        if (this.searchExpression.memory) {
            List<SourceTextEntry> allEntries = this.m_project.getAllEntries();
            for (int i = 0; i < allEntries.size(); ++i) {
                if (this.m_numFinds >= this.searchExpression.numberOfResults) {
                    throw new SearchLimitReachedException();
                }
                SourceTextEntry ste = allEntries.get(i);
                TMXEntry te = this.m_project.getTranslationInfo(ste);
                this.checkEntry(ste.getSrcText(), te.translation, te.note, ste.getRawProperties(), te, i, null);
                this.checkStop.checkInterrupted();
            }
            if (!this.searchExpression.excludeOrphans) {
                this.m_project.iterateByDefaultTranslations(new IProject.DefaultTranslationsIterator(){
                    final String file = OStrings.getString("CT_ORPHAN_STRINGS");

                    @Override
                    public void iterate(String source, TMXEntry en) {
                        if (Searcher.this.m_numFinds >= Searcher.this.searchExpression.numberOfResults) {
                            return;
                        }
                        Searcher.this.checkStop.checkInterrupted();
                        if (Searcher.this.m_project.isOrphaned(source)) {
                            Searcher.this.checkEntry(en.source, en.translation, en.note, null, en, -2, this.file);
                        }
                    }
                });
                this.m_project.iterateByMultipleTranslations(new IProject.MultipleTranslationsIterator(){
                    final String file = OStrings.getString("CT_ORPHAN_STRINGS");

                    @Override
                    public void iterate(EntryKey source, TMXEntry en) {
                        if (Searcher.this.m_numFinds >= Searcher.this.searchExpression.numberOfResults) {
                            return;
                        }
                        Searcher.this.checkStop.checkInterrupted();
                        if (Searcher.this.m_project.isOrphaned(source)) {
                            Searcher.this.checkEntry(en.source, en.translation, en.note, null, en, -2, this.file);
                        }
                    }
                });
            }
        }
    }

    private String getFileForEntry(int i) {
        List<IProject.FileInfo> fileList = Core.getProject().getProjectFiles();
        for (IProject.FileInfo fi : fileList) {
            int first = fi.entries.get(0).entryNum();
            int last = fi.entries.get(fi.entries.size() - 1).entryNum();
            if (i < first || i > last) continue;
            return fi.filePath;
        }
        return null;
    }

    private void searchEntries(Iterable<? extends ITMXEntry> tmEn, int origin, String tmxID) throws SearchLimitReachedException {
        for (ITMXEntry iTMXEntry : tmEn) {
            if (this.m_numFinds >= this.searchExpression.numberOfResults) {
                throw new SearchLimitReachedException();
            }
            this.checkEntry(iTMXEntry.getSourceText(), iTMXEntry.getTranslationText(), iTMXEntry.getNote(), null, null, origin, tmxID);
            this.checkStop.checkInterrupted();
        }
    }

    protected void checkEntry(String srcText, String locText, String note, String[] properties, TMXEntry entry, int entryNum, String intro) {
        SearchMatch[] srcMatches = null;
        SearchMatch[] targetMatches = null;
        SearchMatch[] srcOrTargetMatches = null;
        SearchMatch[] noteMatches = null;
        SearchMatch[] propertyMatches = null;
        String firstMatchedProperty = null;
        block0 : switch (this.searchExpression.mode) {
            case SEARCH: {
                if (this.searchExpression.searchTranslated && !this.searchExpression.searchUntranslated && locText == null) {
                    return;
                }
                if (!this.searchExpression.searchTranslated && this.searchExpression.searchUntranslated && locText != null) {
                    return;
                }
                if (this.searchExpression.searchSource && this.searchString(srcText)) {
                    srcMatches = this.foundMatches.toArray(new SearchMatch[0]);
                }
                if (this.searchExpression.searchTarget && this.searchString(locText)) {
                    targetMatches = this.foundMatches.toArray(new SearchMatch[0]);
                }
                if (this.searchExpression.searchSource && this.searchExpression.searchTarget && locText != null && srcMatches == null && targetMatches == null && this.searchString(srcText + "\ue000" + locText)) {
                    srcOrTargetMatches = this.foundMatches.toArray(new SearchMatch[0]);
                }
                if (this.searchExpression.searchNotes && this.searchString(note)) {
                    noteMatches = this.foundMatches.toArray(new SearchMatch[0]);
                }
                if (!this.searchExpression.searchComments || properties == null) break;
                for (int i = 1; i <= properties.length; i += 2) {
                    if (!this.searchString(properties[i], true)) continue;
                    propertyMatches = this.foundMatches.toArray(new SearchMatch[0]);
                    firstMatchedProperty = properties[i];
                    break block0;
                }
                break;
            }
            case REPLACE: {
                if (this.searchExpression.replaceTranslated && locText != null) {
                    if (!this.searchString(locText, false)) break;
                    targetMatches = this.foundMatches.toArray(new SearchMatch[0]);
                    break;
                }
                if (!this.searchExpression.replaceUntranslated || locText != null || !this.searchString(srcText, false)) break;
                srcMatches = this.foundMatches.toArray(new SearchMatch[0]);
            }
        }
        if (!(srcMatches == null && targetMatches == null && srcOrTargetMatches == null && noteMatches == null && propertyMatches == null || this.searchExpression.searchAuthor && !this.searchAuthor(entry) || this.searchExpression.searchDateBefore && (entry == null || entry.changeDate == 0L || entry.changeDate >= this.searchExpression.dateBefore) || this.searchExpression.searchDateAfter && (entry == null || entry.changeDate == 0L || entry.changeDate <= this.searchExpression.dateAfter))) {
            this.foundString(entryNum, intro, srcText, locText, note, firstMatchedProperty, srcMatches, targetMatches, noteMatches, propertyMatches);
        }
    }

    private void searchFiles() throws IOException {
        Path root = Paths.get(this.searchExpression.rootDir, new String[0]);
        FilterMaster fm = Core.getFilterMaster();
        SearchCallback searchCallback = new SearchCallback(this.m_project.getProjectProperties());
        int depth = this.searchExpression.recursive ? Integer.MAX_VALUE : 0;
        Files.walk(root, depth, FileVisitOption.FOLLOW_LINKS).forEach(path -> {
            String filename = path.toString();
            IProject.FileInfo fi = new IProject.FileInfo();
            fi.filePath = root.relativize((Path)path).toString();
            searchCallback.setCurrentFile(fi);
            try {
                fm.loadFile(filename, new FilterContext(this.m_project.getProjectProperties()), searchCallback);
            }
            catch (IOException | TranslationException ex) {
                Log.log(ex);
            }
            searchCallback.fileFinished();
            this.checkStop.checkInterrupted();
        });
    }

    public boolean searchString(String origText) {
        return this.searchString(origText, true);
    }

    public boolean searchString(String origText, boolean collapseResults) {
        int end;
        if (origText == null || this.m_matchers == null || this.m_matchers.isEmpty()) {
            return false;
        }
        String text = this.searchExpression.widthInsensitive ? StringUtil.normalizeWidth(origText) : origText;
        this.foundMatches.clear();
        block0: for (Matcher matcher : this.m_matchers) {
            int nextStart;
            int start;
            matcher.reset(text);
            if (!matcher.find()) {
                return false;
            }
            do {
                if (!text.substring(start = matcher.start(), end = matcher.end()).equals(origText.substring(start, end))) {
                    int find = origText.indexOf(text.substring(start, end));
                    if (find >= 0) {
                        end = find + (end - start);
                        start = find;
                    } else {
                        boolean found = false;
                        String foundText = text.substring(start, end);
                        block2: for (find = 0; find < origText.length(); ++find) {
                            if (!StringUtil.normalizeWidth(origText.substring(find)).startsWith(foundText)) continue;
                            start = end = find;
                            while (end < origText.length()) {
                                if (!StringUtil.normalizeWidth(origText.substring(start, ++end)).equals(foundText)) continue;
                                found = true;
                                break block2;
                            }
                        }
                        if (!found) break block0;
                    }
                }
                if (this.searchExpression.mode == SearchMode.REPLACE) {
                    if (this.searchExpression.searchExpressionType == SearchExpression.SearchExpressionType.REGEXP) {
                        if (end == start && start > 0) continue block0;
                        Object repl = this.searchExpression.replacement;
                        Matcher replaceMatcher = PatternConsts.REGEX_VARIABLE.matcher((CharSequence)repl);
                        while (replaceMatcher.find()) {
                            int varId = Integer.parseInt(replaceMatcher.group(2));
                            if (varId > matcher.groupCount()) {
                                throw new IndexOutOfBoundsException(OStrings.getString("ST_REGEXP_REPLACEGROUP_ERROR", varId));
                            }
                            String substitution = matcher.group(varId);
                            if (substitution == null) {
                                substitution = "";
                            }
                            substitution = substitution.replace("\\", "\\\\").replace("$", "\\$");
                            repl = ((String)repl).substring(0, replaceMatcher.start()) + replaceMatcher.group(1) + substitution + ((String)repl).substring(replaceMatcher.end());
                            replaceMatcher.reset((CharSequence)repl);
                        }
                        this.foundMatches.add(new SearchMatch(start, end, StringUtil.replaceCase((String)repl, this.m_project.getProjectProperties().getTargetLanguage().getLocale())));
                        continue;
                    }
                    this.foundMatches.add(new SearchMatch(start, end, this.searchExpression.replacement));
                    continue;
                }
                if (end <= start) continue;
                this.foundMatches.add(new SearchMatch(start, end));
            } while (start < text.length() && matcher.find(nextStart = end == start ? end + 1 : end));
        }
        Collections.sort(this.foundMatches);
        if (collapseResults) {
            int i = 1;
            while (i < this.foundMatches.size()) {
                SearchMatch pr = this.foundMatches.get(i - 1);
                SearchMatch cu = this.foundMatches.get(i);
                if (pr.getStart() <= cu.getStart() && pr.getEnd() >= cu.getStart()) {
                    end = Math.max(cu.getEnd(), pr.getEnd());
                    pr = new SearchMatch(pr.getStart(), end, pr.getReplacement());
                    this.foundMatches.set(i - 1, pr);
                    this.foundMatches.remove(i);
                    continue;
                }
                ++i;
            }
        }
        return true;
    }

    public List<SearchMatch> getFoundMatches() {
        return this.foundMatches;
    }

    private boolean searchAuthor(TMXEntry te) {
        if (te == null || this.m_author == null) {
            return false;
        }
        if (this.m_author.pattern().pattern().equals("")) {
            return te.changer == null && te.creator == null;
        }
        if (te.changer != null) {
            this.m_author.reset(te.changer);
            if (this.m_author.find()) {
                return true;
            }
        }
        if (te.creator != null) {
            this.m_author.reset(te.creator);
            if (this.m_author.find()) {
                return true;
            }
        }
        return false;
    }

    public void searchText(String seg, String translation, String filename) {
        if (this.m_numFinds >= this.searchExpression.numberOfResults) {
            return;
        }
        this.checkStop.checkInterrupted();
        if (!this.searchExpression.searchTranslated && translation == null) {
            return;
        }
        if (this.searchString(seg)) {
            SearchMatch[] matches = this.foundMatches.toArray(new SearchMatch[0]);
            this.foundString(-5, filename, seg, null, null, null, matches, null, null, null);
        }
    }

    private static class SearchLimitReachedException
    extends Exception {
        private SearchLimitReachedException() {
        }
    }

    protected class SearchCallback
    extends ParseEntry
    implements IParseCallback {
        private String filename;

        public SearchCallback(ProjectProperties config) {
            super(config);
        }

        @Override
        public void setCurrentFile(IProject.FileInfo fi) {
            super.setCurrentFile(fi);
            this.filename = fi.filePath;
        }

        @Override
        protected void fileFinished() {
            super.fileFinished();
        }

        @Override
        protected void addSegment(String id, short segmentIndex, String segmentSource, List<ProtectedPart> protectedParts, String segmentTranslation, boolean segmentTranslationFuzzy, String[] props, String prevSegment, String nextSegment, String path) {
            Searcher.this.searchText(segmentSource, segmentTranslation, this.filename);
        }
    }
}

