/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.externalfinder.item.ExternalFinderConfiguration;
import org.omegat.externalfinder.item.ExternalFinderItem;
import org.omegat.externalfinder.item.ExternalFinderItemMenuGenerator;
import org.omegat.externalfinder.item.ExternalFinderItemPopupMenuConstructor;
import org.omegat.externalfinder.item.ExternalFinderXMLLoader;
import org.omegat.externalfinder.item.ExternalFinderXMLWriter;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.MenuItemPager;

public final class ExternalFinder {
    public static final String FINDER_FILE = "finder.xml";
    private static final Logger LOGGER = Logger.getLogger(ExternalFinder.class.getName());
    private static ExternalFinderConfiguration globalConfig;
    private static ExternalFinderConfiguration projectConfig;

    private ExternalFinder() {
    }

    public static void loadPlugins() {
        CoreEvents.registerApplicationEventListener(ExternalFinder.generateIApplicationEventListener());
        CoreEvents.registerProjectChangeListener(ExternalFinder.generateIProjectEventListener());
    }

    private static IProjectEventListener generateIProjectEventListener() {
        return new IProjectEventListener(){
            private final List<Component> menuItems = new ArrayList<Component>();

            @Override
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                switch (eventType) {
                    case LOAD: {
                        this.onLoad();
                        break;
                    }
                    case CLOSE: {
                        this.onClose();
                        break;
                    }
                }
            }

            private void onLoad() {
                this.menuItems.clear();
                ExternalFinderItemMenuGenerator generator = new ExternalFinderItemMenuGenerator(ExternalFinderItem.TARGET.BOTH, false);
                List<JMenuItem> newMenuItems = generator.generate();
                JMenu toolsMenu = Core.getMainWindow().getMainMenu().getToolsMenu();
                JPopupMenu.Separator separator = new JPopupMenu.Separator();
                toolsMenu.add(separator);
                this.menuItems.add(separator);
                MenuItemPager pager = new MenuItemPager(toolsMenu);
                for (JMenuItem component : newMenuItems) {
                    pager.add(component);
                }
                this.menuItems.addAll(pager.getFirstPage());
            }

            private void onClose() {
                JMenu menu = Core.getMainWindow().getMainMenu().getToolsMenu();
                this.menuItems.forEach(menu::remove);
                this.menuItems.clear();
                projectConfig = null;
            }
        };
    }

    private static IApplicationEventListener generateIApplicationEventListener() {
        return new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
                Core.getEditor().registerPopupMenuConstructors(ExternalFinder.getGlobalConfig().getPriority(), new ExternalFinderItemPopupMenuConstructor());
            }

            @Override
            public void onApplicationShutdown() {
            }
        };
    }

    public static void unloadPlugins() {
    }

    public static ExternalFinderConfiguration getGlobalConfig() {
        if (globalConfig == null) {
            try {
                File globalFile = ExternalFinder.getGlobalConfigFile();
                ExternalFinderXMLLoader userItemLoader = new ExternalFinderXMLLoader(globalFile, ExternalFinderItem.SCOPE.GLOBAL);
                globalConfig = userItemLoader.load();
            }
            catch (FileNotFoundException globalFile) {
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            if (globalConfig == null) {
                globalConfig = ExternalFinderConfiguration.empty();
            }
        }
        return globalConfig;
    }

    public static void setGlobalConfig(ExternalFinderConfiguration newConfig) {
        ExternalFinderConfiguration oldConfig = globalConfig;
        globalConfig = newConfig;
        if (!Objects.equals(newConfig, oldConfig)) {
            ExternalFinder.writeConfig(newConfig, ExternalFinder.getGlobalConfigFile());
        }
    }

    private static File getGlobalConfigFile() {
        String configDir = StaticUtils.getConfigDir();
        return new File(configDir, FINDER_FILE);
    }

    public static ExternalFinderConfiguration getProjectConfig() {
        IProject currentProject = Core.getProject();
        if (!currentProject.isProjectLoaded()) {
            return null;
        }
        if (projectConfig == null) {
            File projectFile = ExternalFinder.getProjectFile(currentProject);
            ExternalFinderXMLLoader projectItemLoader = new ExternalFinderXMLLoader(projectFile, ExternalFinderItem.SCOPE.PROJECT);
            try {
                projectConfig = projectItemLoader.load();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return projectConfig;
    }

    public static void setProjectConfig(ExternalFinderConfiguration newConfig) {
        IProject currentProject = Core.getProject();
        if (!currentProject.isProjectLoaded()) {
            return;
        }
        ExternalFinderConfiguration oldConfig = projectConfig;
        projectConfig = newConfig;
        if (!Objects.equals(newConfig, oldConfig)) {
            File projectFile = ExternalFinder.getProjectFile(currentProject);
            ExternalFinder.writeConfig(newConfig, projectFile);
        }
    }

    private static void writeConfig(ExternalFinderConfiguration config, File toFile) {
        if (config == null) {
            boolean deleted = toFile.delete();
            if (!deleted) {
                LOGGER.log(Level.SEVERE, "Unable to delete ExternalFinder config file: {0}", toFile);
            }
        } else {
            try {
                File tmpFile = File.createTempFile("omt", "externalfinder");
                ExternalFinderXMLWriter writer = new ExternalFinderXMLWriter(tmpFile);
                writer.write(config);
                Files.move(tmpFile.toPath(), toFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private static File getProjectFile(IProject project) {
        ProjectProperties projectProperties = project.getProjectProperties();
        File projectRoot = projectProperties.getProjectInternalDir();
        return new File(projectRoot, FINDER_FILE);
    }

    public static List<ExternalFinderItem> getItems() {
        ArrayList<ExternalFinderItem> result = new ArrayList<ExternalFinderItem>(ExternalFinder.getGlobalConfig().getItems());
        ExternalFinderConfiguration projectConfig = ExternalFinder.getProjectConfig();
        if (projectConfig != null) {
            projectConfig.getItems().forEach(item -> ExternalFinder.addOrReplaceByName(result, item));
        }
        return Collections.unmodifiableList(result);
    }

    static void addOrReplaceByName(List<ExternalFinderItem> items, ExternalFinderItem item) {
        for (int i = 0; i < items.size(); ++i) {
            if (!items.get(i).getName().equals(item.getName())) continue;
            items.set(i, item);
            return;
        }
        items.add(item);
    }
}

