/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.core.Core;
import org.omegat.gui.editor.AlphabeticalMarkers;
import org.omegat.gui.editor.EditorController;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class GoToSegmentDialog
extends JDialog {
    private AlphabeticalMarkers alphabeticalMarkers;
    private int result = -1;
    private JButton cancelButton;
    private JLabel fieldLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton okButton;
    private JTextField segmentField;

    public GoToSegmentDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.segmentField.enableInputMethods(false);
        this.segmentField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GoToSegmentDialog.this.detectDidInputLetter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GoToSegmentDialog.this.detectDidInputLetter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GoToSegmentDialog.this.detectDidInputLetter();
            }
        });
        StaticUIUtils.setEscapeAction(this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoToSegmentDialog.this.doClose();
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.setLocationRelativeTo(parent);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                GoToSegmentDialog.this.alphabeticalMarkers = ((EditorController)Core.getEditor()).getAlphabeticalMarkers();
                GoToSegmentDialog.this.alphabeticalMarkers.showMarkers();
            }
        });
    }

    private void detectDidInputLetter() {
        String input = this.segmentField.getText();
        if (input.codePointCount(0, input.length()) != 1) {
            return;
        }
        if (this.alphabeticalMarkers.containsTitle(input.codePointAt(0))) {
            this.okButtonActionPerformed(null);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.fieldLabel = new JLabel();
        this.segmentField = new JTextField();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("MW_PROMPT_SEG_NR_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GoToSegmentDialog.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel1.setLayout(new BorderLayout());
        this.fieldLabel.setLabelFor(this.segmentField);
        this.fieldLabel.setText(OStrings.getString("MW_PROMPT_SEG_NR_MSG"));
        this.jPanel1.add((Component)this.fieldLabel, "North");
        this.jPanel1.add((Component)this.segmentField, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GoToSegmentDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.okButton);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GoToSegmentDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.cancelButton);
        this.jPanel2.add((Component)this.jPanel3, "East");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int segmentNr;
        String inputValue = this.segmentField.getText();
        int maxNr = Core.getProject().getAllEntries().size();
        if (inputValue == null || inputValue.trim().isEmpty()) {
            this.displayErrorMessage(maxNr);
            return;
        }
        inputValue = this.alphabeticalMarkers.translateSegmentNumber(inputValue);
        try {
            segmentNr = Integer.parseInt(inputValue);
        }
        catch (NumberFormatException e) {
            this.displayErrorMessage(maxNr);
            return;
        }
        if (segmentNr < 1 || segmentNr > maxNr) {
            this.displayErrorMessage(maxNr);
            return;
        }
        this.result = segmentNr;
        this.doClose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.alphabeticalMarkers.hideMarkers();
        this.setVisible(false);
        this.dispose();
    }

    private void displayErrorMessage(int maxNr) {
        JOptionPane.showMessageDialog(this, StringUtil.format(OStrings.getString("MW_SEGMENT_NUMBER_ERROR"), maxNr), OStrings.getString("TF_ERROR"), 0);
    }

    public int getResult() {
        return this.result;
    }
}

