/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omegat.util.OStrings;

public final class VersionChecker {
    private static final Logger LOGGER = Logger.getLogger(VersionChecker.class.getName());
    private static final String VERSION_FILE = "https://omegat.sourceforge.io/Version-" + (OStrings.IS_BETA ? "latest" : "standard") + ".properties";
    private static final int FETCH_INTERVAL = 300000;
    private Properties mProps = new Properties();
    private long lastFetched = -1L;

    public static VersionChecker getInstance() {
        return SingletonHelper.INSTANCE;
    }

    private VersionChecker() {
    }

    private boolean shouldFetch() {
        if (this.mProps.isEmpty()) {
            return true;
        }
        return System.currentTimeMillis() - this.lastFetched >= 300000L;
    }

    private void fetch(boolean force) throws Exception {
        if (!force && !this.shouldFetch()) {
            return;
        }
        LOGGER.fine("Fetching latest version info");
        Properties props = new Properties();
        try (InputStream in = new URL(VERSION_FILE).openStream();){
            props.load(in);
        }
        try {
            OStrings.validateVersion(props::getProperty);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Fetched version info was invalid: " + props, e);
        }
        this.mProps = props;
        this.lastFetched = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Fetched latest version info: {0}", props);
    }

    private int compareVersions(boolean force) throws Exception {
        this.fetch(force);
        return VersionChecker.compareVersions(OStrings.VERSION, OStrings.UPDATE, this.mProps.getProperty("version"), this.mProps.getProperty("update"));
    }

    public boolean isUpToDate(boolean force) throws Exception {
        boolean result;
        boolean bl = result = this.compareVersions(force) >= 0;
        if (result) {
            LOGGER.fine("OmegaT is up to date");
        } else {
            LOGGER.log(Level.FINE, "A newer version of OmegaT is available: {0}", this.getRemoteVersion());
        }
        return result;
    }

    public String getRemoteVersion() throws Exception {
        this.fetch(false);
        return OStrings.getSimpleVersion(this.mProps.getProperty("version"), this.mProps.getProperty("update"));
    }

    public static int compareVersions(String version1, String update1, String version2, String update2) {
        return VersionChecker.compare(VersionChecker.getVersionNumbers(version1, update1), VersionChecker.getVersionNumbers(version2, update2));
    }

    private static List<Integer> getVersionNumbers(String version, String update) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String n : version.split("\\.")) {
            result.add(Integer.parseInt(n));
        }
        result.add(Integer.parseInt(update));
        return result;
    }

    private static int compare(List<Integer> l1, List<Integer> l2) {
        if (l1.size() != l2.size()) {
            throw new IllegalArgumentException("Lists must be same size");
        }
        for (int i = 0; i < l1.size(); ++i) {
            int c = Integer.compare(l1.get(i), l2.get(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private static class SingletonHelper {
        private static final VersionChecker INSTANCE = new VersionChecker();

        private SingletonHelper() {
        }
    }
}

