/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.tail;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.trie4j.tail.DefaultTailArray;
import org.trie4j.tail.TailArray;
import org.trie4j.tail.TailArrayBuilder;
import org.trie4j.tail.builder.TailBuilder;
import org.trie4j.tail.index.TailIndexBuilder;

public abstract class AbstractTailArrayBuilder
implements Externalizable,
TailArrayBuilder {
    private StringBuilder tails = new StringBuilder();
    private TailBuilder builder = this.newTailBuilder(this.tails);
    private TailIndexBuilder indexBuilder;

    protected abstract TailBuilder newTailBuilder(StringBuilder var1);

    protected abstract TailIndexBuilder newTailIndexBuilder(int var1);

    public AbstractTailArrayBuilder() {
        this(1024);
    }

    public AbstractTailArrayBuilder(int initialCapacity) {
        this.indexBuilder = this.newTailIndexBuilder(initialCapacity);
    }

    @Override
    public void append(int nodeId, CharSequence letters, int offset, int len) {
        int ret = this.builder.insert(letters, offset, len);
        this.indexBuilder.add(nodeId, ret, this.tails.length());
    }

    @Override
    public void append(int nodeId, char[] letters, int offset, int len) {
        int ret = this.builder.insert(letters, offset, len);
        this.indexBuilder.add(nodeId, ret, this.tails.length());
    }

    @Override
    public void appendEmpty(int nodeId) {
        this.indexBuilder.addEmpty(nodeId);
    }

    @Override
    public void trimToSize() {
        this.tails.trimToSize();
        this.indexBuilder.trimToSize();
    }

    @Override
    public TailArray build() {
        this.tails.trimToSize();
        return new DefaultTailArray(this.tails, this.indexBuilder.build());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        this.tails = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            this.tails.append(in.readChar());
        }
        this.builder = this.newTailBuilder(this.tails);
        this.indexBuilder = (TailIndexBuilder)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int n = this.tails.length();
        out.writeInt(n);
        for (int i = 0; i < n; ++i) {
            out.writeChar(this.tails.charAt(i));
        }
        out.writeObject(this.indexBuilder);
    }
}

