/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.values;

import edu.berkeley.nlp.lm.array.CustomWidthArray;
import edu.berkeley.nlp.lm.bits.BitUtils;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.values.ProbBackoffPair;
import edu.berkeley.nlp.lm.values.ProbBackoffValueContainer;
import edu.berkeley.nlp.lm.values.ValueContainer;
import java.util.Arrays;

public final class UnrankedUncompressedProbBackoffValueContainer
implements ProbBackoffValueContainer {
    private static final long serialVersionUID = 964277160049236607L;
    private final boolean storeSuffixIndexes;
    private final int[] suffixBitsForOrder;
    private final long[] numNgramsForEachOrder;
    private CustomWidthArray[] valueRanks = null;
    private NgramMap<ProbBackoffPair> ngramMap;

    public UnrankedUncompressedProbBackoffValueContainer(boolean storePrefixes, long[] numNgramsForEachOrder) {
        this.storeSuffixIndexes = storePrefixes;
        this.numNgramsForEachOrder = numNgramsForEachOrder;
        this.valueRanks = new CustomWidthArray[numNgramsForEachOrder.length];
        this.suffixBitsForOrder = new int[numNgramsForEachOrder.length];
    }

    public UnrankedUncompressedProbBackoffValueContainer createFreshValues(long[] numNgramsForEachOrder_) {
        return new UnrankedUncompressedProbBackoffValueContainer(this.storeSuffixIndexes, numNgramsForEachOrder_);
    }

    @Override
    public final float getProb(int ngramOrder, long index) {
        return ProbBackoffPair.probOf(this.getProbBackoff(ngramOrder, index));
    }

    private long getProbBackoff(int ngramOrder, long index) {
        return this.valueRanks[ngramOrder].get(index, ngramOrder == 0 ? 0 : this.valueRanks[ngramOrder].getKeyWidth(), this.numProbBackoffBits(ngramOrder));
    }

    @Override
    public void getFromOffset(long index, int ngramOrder, @Annotations.OutputParameter ProbBackoffPair outputVal) {
        long l = this.getProbBackoff(ngramOrder, index);
        outputVal.prob = ProbBackoffPair.probOf(l);
        outputVal.backoff = ProbBackoffPair.backoffOf(l);
    }

    @Override
    public final float getBackoff(int ngramOrder, long index) {
        return ProbBackoffPair.backoffOf(this.getProbBackoff(ngramOrder, index));
    }

    @Override
    public ProbBackoffPair getScratchValue() {
        return new ProbBackoffPair(Float.NaN, Float.NaN);
    }

    @Override
    public void setFromOtherValues(ValueContainer<ProbBackoffPair> other) {
        UnrankedUncompressedProbBackoffValueContainer o = (UnrankedUncompressedProbBackoffValueContainer)other;
        for (int i = 0; i < this.valueRanks.length; ++i) {
            this.valueRanks[i] = o.valueRanks[i];
        }
    }

    @Override
    public void trim() {
    }

    @Override
    public boolean storeSuffixoffsets() {
        return this.storeSuffixIndexes;
    }

    @Override
    public int numValueBits(int ngramOrder) {
        return this.numProbBackoffBits(ngramOrder) + this.suffixBitsForOrder[ngramOrder];
    }

    private int numProbBackoffBits(int ngramOrder) {
        return ngramOrder == this.numNgramsForEachOrder.length - 1 ? 32 : 64;
    }

    @Override
    public boolean add(int[] ngram, int startPos, int endPos, int ngramOrder, long offset, long contextOffset, int word, ProbBackoffPair val_, long suffixOffset, boolean ngramIsNew) {
        if (suffixOffset < 0L && this.storeSuffixIndexes) {
            return false;
        }
        assert (suffixOffset < 0L || ngramOrder == 0 || CustomWidthArray.numBitsNeeded(suffixOffset) <= this.suffixBitsForOrder[ngramOrder]) : "Problem with suffix offset bits " + suffixOffset + " " + this.numNgramsForEachOrder[ngramOrder - 1] + " " + Arrays.toString(ngram);
        ProbBackoffPair val = val_;
        if (val == null) {
            val = this.getScratchValue();
        }
        this.setSizeAtLeast(10L, ngramOrder);
        long indexOfCounts = val.asLong();
        CustomWidthArray valueRanksHere = this.valueRanks[ngramOrder];
        int widthOffset = ngramOrder == 0 ? 0 : valueRanksHere.getKeyWidth();
        valueRanksHere.setAndGrowIfNeeded(offset, ngramOrder == this.valueRanks.length - 1 ? BitUtils.getLowLong(indexOfCounts) : indexOfCounts, widthOffset, this.numProbBackoffBits(ngramOrder));
        if (this.storeSuffixIndexes && ngramOrder > 0) {
            assert (suffixOffset >= 0L);
            assert (suffixOffset <= Integer.MAX_VALUE);
            valueRanksHere.setAndGrowIfNeeded(offset, suffixOffset, widthOffset + this.numProbBackoffBits(ngramOrder), this.suffixBitsForOrder[ngramOrder]);
        }
        return true;
    }

    @Override
    public void setSizeAtLeast(long size, int ngramOrder) {
        if (this.valueRanks[ngramOrder] == null) {
            CustomWidthArray valueStoringArray;
            boolean useValueStoringArrayHere;
            int suffixBits;
            int n = suffixBits = ngramOrder == 0 || !this.storeSuffixIndexes ? 0 : this.suffixBitsForOrder[ngramOrder];
            if (this.storeSuffixIndexes && ngramOrder < this.suffixBitsForOrder.length - 1) {
                this.suffixBitsForOrder[ngramOrder + 1] = CustomWidthArray.numBitsNeeded(size);
            }
            boolean bl = useValueStoringArrayHere = (valueStoringArray = this.ngramMap.getValueStoringArray(ngramOrder)) != null;
            if (useValueStoringArrayHere) {
                this.valueRanks[ngramOrder] = valueStoringArray;
            } else {
                this.valueRanks[ngramOrder] = new CustomWidthArray(size, this.numProbBackoffBits(ngramOrder) + suffixBits);
                this.valueRanks[ngramOrder].setAndGrowIfNeeded(size - 1L, this.getScratchValue().asLong());
            }
        }
    }

    @Override
    public long getSuffixOffset(long index, int ngramOrder) {
        assert (ngramOrder > 0);
        CustomWidthArray valueRanksHere = this.valueRanks[ngramOrder];
        int widthOffset = valueRanksHere.getKeyWidth();
        int width = widthOffset + this.numProbBackoffBits(ngramOrder);
        return valueRanksHere.get(index, width, valueRanksHere.getFullWidth() - width);
    }

    @Override
    public void trimAfterNgram(int ngramOrder, long size) {
    }

    @Override
    public void setMap(NgramMap<ProbBackoffPair> map) {
        this.ngramMap = map;
    }

    @Override
    public void clearStorageForOrder(int ngramOrder) {
    }
}

