/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.patricia;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.trie4j.AbstractTrie;
import org.trie4j.Node;
import org.trie4j.Trie;
import org.trie4j.patricia.TailPatriciaTrieNode;
import org.trie4j.patricia.TailPatriciaTrieNodeAdapter;
import org.trie4j.tail.FastTailCharIterator;
import org.trie4j.tail.TailCharIterator;
import org.trie4j.tail.builder.SuffixTrieTailBuilder;
import org.trie4j.tail.builder.TailBuilder;
import org.trie4j.util.Pair;

public class TailPatriciaTrie
extends AbstractTrie
implements Serializable,
Trie {
    private int size;
    private int nodeSize;
    private TailPatriciaTrieNode root = this.newNode();
    private TailBuilder tailBuilder;
    private CharSequence tails;
    private static final long serialVersionUID = -2084269385978925271L;

    public TailPatriciaTrie() {
        this(new SuffixTrieTailBuilder());
    }

    public TailPatriciaTrie(TailBuilder builder) {
        this.tailBuilder = builder;
        this.tails = builder.getTails();
    }

    public TailPatriciaTrie(Trie orig, TailBuilder builder) {
        this.tailBuilder = builder;
        this.tails = builder.getTails();
        this.root = this.cloneNode(orig.getRoot());
        this.size = orig.size();
        this.nodeSize = orig.nodeSize();
        this.trimToSize();
    }

    private TailPatriciaTrieNode cloneNode(Node node) {
        char[] letters = node.getLetters();
        char fc = letters.length == 0 ? (char)'\uffff' : letters[0];
        int ti = letters.length < 2 ? -1 : this.tailBuilder.insert(letters, 1, letters.length - 1);
        Node[] orgChildren = node.getChildren();
        TailPatriciaTrieNode[] children = this.newNodeArray(orgChildren.length);
        for (int i = 0; i < children.length; ++i) {
            children[i] = this.cloneNode(orgChildren[i]);
        }
        return new TailPatriciaTrieNode(fc, ti, node.isTerminate(), children);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    @Override
    public Node getRoot() {
        return new TailPatriciaTrieNodeAdapter(this.root, this.tails);
    }

    @Override
    public boolean contains(String text) {
        TailPatriciaTrieNode node = this.root;
        FastTailCharIterator it = new FastTailCharIterator(this.tails, -1);
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c;
            if ((node = node.getChild(text.charAt(i))) == null) {
                return false;
            }
            int ti = node.getTailIndex();
            if (ti == -1) continue;
            it.setIndex(node.getTailIndex());
            while ((c = it.getNext()) != '\u0000') {
                if (++i == n) {
                    return false;
                }
                if (text.charAt(i) == c) continue;
                return false;
            }
        }
        return node.isTerminate();
    }

    public TailPatriciaTrieNode getNode(String text) {
        TailPatriciaTrieNode node = this.root;
        FastTailCharIterator it = new FastTailCharIterator(this.tails, -1);
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c;
            if ((node = node.getChild(text.charAt(i))) == null) {
                return null;
            }
            int ti = node.getTailIndex();
            if (ti == -1) continue;
            it.setIndex(node.getTailIndex());
            while ((c = it.getNext()) != '\u0000') {
                if (++i == n) {
                    return null;
                }
                if (text.charAt(i) == c) continue;
                return null;
            }
        }
        return node;
    }

    public CharSequence getTails() {
        return this.tails;
    }

    @Override
    public int findShortestWord(CharSequence chars, int start, int end, StringBuilder word) {
        TailCharIterator it = new TailCharIterator(this.tails, -1);
        block0: for (int i = start; i < end; ++i) {
            TailPatriciaTrieNode node = this.root;
            for (int j = i; j < end && (node = node.getChild(chars.charAt(j))) != null; ++j) {
                boolean matched = true;
                it.setIndex(node.getTailIndex());
                while (it.hasNext()) {
                    if (++j != end && chars.charAt(j) == it.next()) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue block0;
                if (!node.isTerminate()) continue;
                if (word != null) {
                    word.append(chars, i, j + 1);
                }
                return i;
            }
        }
        return -1;
    }

    @Override
    public int findLongestWord(CharSequence chars, int start, int end, StringBuilder word) {
        TailCharIterator it = new TailCharIterator(this.tails, -1);
        for (int i = start; i < end; ++i) {
            TailPatriciaTrieNode node = this.root;
            int lastJ = -1;
            for (int j = i; j < end && (node = node.getChild(chars.charAt(j))) != null; ++j) {
                boolean matched = true;
                it.setIndex(node.getTailIndex());
                while (it.hasNext()) {
                    if (++j != end && chars.charAt(j) == it.next()) continue;
                    matched = false;
                    break;
                }
                if (!matched) break;
                if (!node.isTerminate()) continue;
                lastJ = j;
            }
            if (lastJ == -1) continue;
            if (word != null) {
                word.append(chars, i, lastJ + 1);
            }
            return i;
        }
        return -1;
    }

    @Override
    public Iterable<String> commonPrefixSearch(final String query) {
        if (query.length() == 0) {
            return new ArrayList<String>(0);
        }
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int cur;
                    private StringBuilder currentChars = new StringBuilder();
                    private TailPatriciaTrieNode current;
                    private String next;
                    {
                        this.current = TailPatriciaTrie.this.root;
                        this.cur = 0;
                        this.findNext();
                    }

                    private void findNext() {
                        this.next = null;
                        while (this.next == null) {
                            char[] letters;
                            int len;
                            if (query.length() <= this.cur) {
                                return;
                            }
                            TailPatriciaTrieNode child = this.current.getChild(query.charAt(this.cur));
                            if (child == null) {
                                return;
                            }
                            int rest = query.length() - this.cur;
                            if (rest < (len = (letters = child.getLetters(TailPatriciaTrie.this.tails)).length)) {
                                return;
                            }
                            for (int i = 1; i < len; ++i) {
                                int c = letters[i] - query.charAt(this.cur + i);
                                if (c == 0) continue;
                                return;
                            }
                            String b = query.substring(this.cur, this.cur + len);
                            if (child.isTerminate()) {
                                this.next = this.currentChars + b;
                            }
                            this.cur += len;
                            this.currentChars.append(b);
                            this.current = child;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public String next() {
                        String ret = this.next;
                        if (ret == null) {
                            throw new NoSuchElementException();
                        }
                        this.findNext();
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<Pair<String, TailPatriciaTrieNode>> commonPrefixSearchWithNode(final String query) {
        if (query.length() == 0) {
            return new ArrayList<Pair<String, TailPatriciaTrieNode>>(0);
        }
        return new Iterable<Pair<String, TailPatriciaTrieNode>>(){

            @Override
            public Iterator<Pair<String, TailPatriciaTrieNode>> iterator() {
                return new Iterator<Pair<String, TailPatriciaTrieNode>>(){
                    private int cur;
                    private StringBuilder currentChars = new StringBuilder();
                    private TailPatriciaTrieNode current;
                    private Pair<String, TailPatriciaTrieNode> next;
                    {
                        this.current = TailPatriciaTrie.this.root;
                        this.cur = 0;
                        this.findNext();
                    }

                    private void findNext() {
                        this.next = null;
                        while (this.next == null) {
                            char[] letters;
                            int len;
                            if (query.length() <= this.cur) {
                                return;
                            }
                            TailPatriciaTrieNode child = this.current.getChild(query.charAt(this.cur));
                            if (child == null) {
                                return;
                            }
                            int rest = query.length() - this.cur;
                            if (rest < (len = (letters = child.getLetters(TailPatriciaTrie.this.tails)).length)) {
                                return;
                            }
                            for (int i = 1; i < len; ++i) {
                                int c = letters[i] - query.charAt(this.cur + i);
                                if (c == 0) continue;
                                return;
                            }
                            String b = query.substring(this.cur, this.cur + len);
                            this.cur += len;
                            this.currentChars.append(b);
                            if (child.isTerminate()) {
                                this.next = Pair.create(this.currentChars.toString(), child);
                            }
                            this.current = child;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Pair<String, TailPatriciaTrieNode> next() {
                        Pair<String, TailPatriciaTrieNode> ret = this.next;
                        if (ret == null) {
                            throw new NoSuchElementException();
                        }
                        this.findNext();
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<String> predictiveSearch(String prefix) {
        char[] queryChars = prefix.toCharArray();
        int cur = 0;
        for (TailPatriciaTrieNode node = this.root; node != null; node = node.getChild(queryChars[cur])) {
            char[] letters = node.getLetters(this.tails);
            int n = Math.min(letters.length, queryChars.length - cur);
            for (int i = 0; i < n; ++i) {
                if (letters[i] == queryChars[cur + i]) continue;
                return Collections.emptyList();
            }
            if (queryChars.length != (cur += n)) continue;
            ArrayList<String> ret = new ArrayList<String>();
            prefix = prefix + new String(letters, n, letters.length - n);
            if (node.isTerminate()) {
                ret.add(prefix);
            }
            this.enumLetters(node, prefix, ret);
            return ret;
        }
        return Collections.emptyList();
    }

    public Iterable<Pair<String, TailPatriciaTrieNode>> predictiveSearchWithNode(String prefix) {
        char[] queryChars = prefix.toCharArray();
        int cur = 0;
        for (TailPatriciaTrieNode node = this.root; node != null; node = node.getChild(queryChars[cur])) {
            char[] letters = node.getLetters(this.tails);
            int n = Math.min(letters.length, queryChars.length - cur);
            for (int i = 0; i < n; ++i) {
                if (letters[i] == queryChars[cur + i]) continue;
                return Collections.emptyList();
            }
            if (queryChars.length != (cur += n)) continue;
            ArrayList<Pair<String, TailPatriciaTrieNode>> ret = new ArrayList<Pair<String, TailPatriciaTrieNode>>();
            prefix = prefix + new String(letters, n, letters.length - n);
            if (node.isTerminate()) {
                ret.add(Pair.create(prefix, node));
            }
            this.enumLettersWithNode(node, prefix, ret);
            return ret;
        }
        return Collections.emptyList();
    }

    private void enumLetters(TailPatriciaTrieNode node, String prefix, List<String> letters) {
        TailPatriciaTrieNode[] children = node.getChildren();
        if (children == null) {
            return;
        }
        for (TailPatriciaTrieNode child : children) {
            String text = prefix + new String(child.getLetters(this.tails));
            if (child.isTerminate()) {
                letters.add(text);
            }
            this.enumLetters(child, text, letters);
        }
    }

    private void enumLettersWithNode(TailPatriciaTrieNode node, String prefix, List<Pair<String, TailPatriciaTrieNode>> letters) {
        TailPatriciaTrieNode[] children = node.getChildren();
        if (children == null) {
            return;
        }
        for (TailPatriciaTrieNode child : children) {
            String text = prefix + new String(child.getLetters(this.tails));
            if (child.isTerminate()) {
                letters.add(Pair.create(text, child));
            }
            this.enumLettersWithNode(child, text, letters);
        }
    }

    @Override
    public void insert(String text) {
        if (this.tailBuilder == null) {
            throw new UnsupportedOperationException("insert isn't permitted for freezed trie");
        }
        this.insert(this.root, text, 0);
    }

    protected TailPatriciaTrieNode insert(TailPatriciaTrieNode node, String letters, int offset) {
        char fc;
        Pair<TailPatriciaTrieNode, Integer> ret;
        TailPatriciaTrieNode child;
        TailCharIterator it = new TailCharIterator(this.tails, node.getTailIndex());
        int count = 0;
        boolean matchComplete = true;
        int lettersLength = letters.length();
        while (it.hasNext() && offset < lettersLength) {
            if (letters.charAt(offset) != it.next()) {
                matchComplete = false;
                break;
            }
            ++offset;
            ++count;
        }
        if (offset == lettersLength) {
            if (it.hasNext()) {
                char c = it.next();
                int idx = it.getNextIndex();
                if (!it.hasNext()) {
                    idx = -1;
                }
                TailPatriciaTrieNode newChild = this.newNode(c, idx, node);
                node.setTailIndex(count > 0 ? this.tailBuilder.insert(letters, offset - count, count) : -1);
                node.setChildren(this.newNodeArray(newChild));
                node.setTerminate(true);
                ++this.size;
                ++this.nodeSize;
                return node;
            }
            if (!node.isTerminate()) {
                node.setTerminate(true);
                ++this.size;
            }
            return node;
        }
        if (!matchComplete) {
            int firstOffset = offset - count;
            char n1Fc = it.current();
            int n1Idx = it.getNextIndex();
            if (!it.hasNext()) {
                n1Idx = -1;
            }
            TailPatriciaTrieNode n1 = this.newNode(n1Fc, n1Idx, node);
            char n2Fc = letters.charAt(offset++);
            int n2Idx = offset < lettersLength ? this.tailBuilder.insert(letters, offset, lettersLength - offset) : -1;
            TailPatriciaTrieNode n2 = this.newNode(n2Fc, n2Idx, true);
            if (count > 0) {
                node.setTailIndex(this.tailBuilder.insert(letters, firstOffset, count));
            } else {
                node.setTailIndex(-1);
            }
            node.setTerminate(false);
            node.setChildren(n1.getFirstLetter() < n2.getFirstLetter() ? this.newNodeArray(n1, n2) : this.newNodeArray(n2, n1));
            ++this.size;
            this.nodeSize += 2;
            return n2;
        }
        if ((child = (ret = node.findNode(fc = letters.charAt(offset++))).getFirst()) != null) {
            return this.insert(child, letters, offset);
        }
        int idx = offset < lettersLength ? this.tailBuilder.insert(letters, offset, lettersLength - offset) : -1;
        TailPatriciaTrieNode newNode = this.newNode(fc, idx, true);
        node.addChild(ret.getSecond(), newNode);
        ++this.size;
        ++this.nodeSize;
        return newNode;
    }

    @Override
    public void trimToSize() {
        if (this.tails instanceof StringBuilder) {
            ((StringBuilder)this.tails).trimToSize();
        }
    }

    @Override
    public void freeze() {
        this.trimToSize();
        this.tailBuilder = null;
    }

    public TailBuilder getTailBuilder() {
        return this.tailBuilder;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }

    protected TailPatriciaTrieNode newNode() {
        return new TailPatriciaTrieNode('\uffff', -1, false, this.newNodeArray(new TailPatriciaTrieNode[0]));
    }

    protected TailPatriciaTrieNode newNode(char firstChar, int tailIndex, TailPatriciaTrieNode source) {
        return new TailPatriciaTrieNode(firstChar, tailIndex, source.isTerminate(), source.getChildren());
    }

    protected TailPatriciaTrieNode newNode(char firstChar, int tailIndex, boolean terminated) {
        return new TailPatriciaTrieNode(firstChar, tailIndex, terminated, this.newNodeArray(new TailPatriciaTrieNode[0]));
    }

    protected TailPatriciaTrieNode[] newNodeArray(TailPatriciaTrieNode ... nodes) {
        return nodes;
    }

    protected TailPatriciaTrieNode[] newNodeArray(int size) {
        return new TailPatriciaTrieNode[size];
    }
}

