/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.matrix;

import java.util.NoSuchElementException;
import net.loomchild.maligna.matrix.BandMatrix;
import net.loomchild.maligna.matrix.MatrixIterator;

public class BandMatrixIterator<T>
implements MatrixIterator<T> {
    private BandMatrix<T> matrix;
    private int x;
    private int y;
    private int maxX;
    private int minX;

    public BandMatrixIterator(BandMatrix<T> matrix) {
        this.matrix = matrix;
        this.beforeFirst();
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void beforeFirst() {
        this.x = -1;
        this.y = 0;
        this.calculateMinMaxX();
    }

    @Override
    public boolean hasNext() {
        return this.y < this.matrix.getHeight() - 1 || this.x < this.matrix.getWidth() - 1;
    }

    @Override
    public void next() {
        ++this.x;
        if (this.x > this.maxX) {
            ++this.y;
            this.calculateMinMaxX();
            this.x = this.minX;
            if (this.y >= this.matrix.getHeight()) {
                throw new NoSuchElementException();
            }
        }
    }

    @Override
    public void afterLast() {
        this.x = this.matrix.getWidth();
        this.y = this.matrix.getHeight() - 1;
        this.calculateMinMaxX();
    }

    @Override
    public boolean hasPrevious() {
        return this.y > 0 || this.x > 0;
    }

    @Override
    public void previous() {
        --this.x;
        if (this.x < this.minX) {
            --this.y;
            this.calculateMinMaxX();
            this.x = this.maxX;
            if (this.y < 0) {
                throw new NoSuchElementException();
            }
        }
    }

    private void calculateMinMaxX() {
        int diagonalX = this.matrix.getDiagonalX(this.y);
        this.minX = Math.max(0, diagonalX - this.matrix.getBandRadius());
        this.maxX = Math.min(this.matrix.getWidth() - 1, diagonalX + this.matrix.getBandRadius());
    }
}

