/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.StringCache;
import org.apache.tomcat.util.modeler.Registry;

public final class StandardServer
implements Lifecycle,
Server,
MBeanRegistration {
    private static Log log = LogFactory.getLog(StandardServer.class);
    private static String SERVER_LISTENER_CLASS_NAME = "org.apache.catalina.mbeans.ServerLifecycleListener";
    private javax.naming.Context globalNamingContext = null;
    private NamingResources globalNamingResources = null;
    private static final String info = "org.apache.catalina.core.StandardServer/1.0";
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private NamingContextListener namingContextListener = null;
    private int port = 8005;
    private Random random = null;
    private Service[] services = new Service[0];
    private String shutdown = "SHUTDOWN";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;
    private boolean initialized = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private volatile boolean stopAwait = false;
    private volatile Thread awaitThread = null;
    private volatile ServerSocket awaitSocket = null;
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public StandardServer() {
        ServerFactory.setServer(this);
        this.globalNamingResources = new NamingResources();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming() && this.namingContextListener == null) {
            this.namingContextListener = new NamingContextListener();
            this.addLifecycleListener(this.namingContextListener);
        }
    }

    public javax.naming.Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(javax.naming.Context globalNamingContext) {
        this.globalNamingContext = globalNamingContext;
    }

    public NamingResources getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    public void setGlobalNamingResources(NamingResources globalNamingResources) {
        NamingResources oldGlobalNamingResources = this.globalNamingResources;
        this.globalNamingResources = globalNamingResources;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", oldGlobalNamingResources, this.globalNamingResources);
    }

    public String getInfo() {
        return info;
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(String shutdown) {
        this.shutdown = shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(Service service) {
        service.setServer(this);
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            Service[] results = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, results, 0, this.services.length);
            results[this.services.length] = service;
            this.services = results;
            if (this.initialized) {
                try {
                    service.initialize();
                }
                catch (LifecycleException e) {
                    log.error((Object)e);
                }
            }
            if (this.started && service instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)service)).start();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void stopAwait() {
        this.stopAwait = true;
        Thread t = this.awaitThread;
        if (t != null) {
            ServerSocket s = this.awaitSocket;
            if (s != null) {
                this.awaitSocket = null;
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            t.interrupt();
            try {
                t.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void await() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service findService(String name) {
        if (name == null) {
            return null;
        }
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!name.equals(this.services[i].getName())) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.services[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public Service[] findServices() {
        return this.services;
    }

    public ObjectName[] getServiceNames() {
        ObjectName[] onames = new ObjectName[this.services.length];
        for (int i = 0; i < this.services.length; ++i) {
            onames[i] = ((StandardService)this.services[i]).getObjectName();
        }
        return onames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(Service service) {
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            int j = -1;
            for (int i = 0; i < this.services.length; ++i) {
                if (service != this.services[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.services[j] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.services[j])).stop();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            int k = 0;
            Service[] results = new Service[this.services.length - 1];
            for (int i = 0; i < this.services.length; ++i) {
                if (i == j) continue;
                results[k++] = this.services[i];
            }
            this.services = results;
            this.support.firePropertyChange("service", service, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardServer[");
        sb.append(this.getPort());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void storeConfig() throws Exception {
        ObjectName sname = new ObjectName("Catalina:type=StoreConfig");
        this.mserver.invoke(sname, "storeConfig", null, null);
    }

    public synchronized void storeContext(Context context) throws Exception {
        ObjectName sname = null;
        try {
            sname = new ObjectName("Catalina:type=StoreConfig");
            if (this.mserver.isRegistered(sname)) {
                this.mserver.invoke(sname, "store", new Object[]{context}, new String[]{"java.lang.String"});
            } else {
                log.error((Object)("StoreConfig mbean not registered" + sname));
            }
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
    }

    private boolean isUseNaming() {
        boolean useNaming = true;
        String useNamingProperty = System.getProperty("catalina.useNaming");
        if (useNamingProperty != null && useNamingProperty.equals("false")) {
            useNaming = false;
        }
        return useNaming;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        if (this.started) {
            log.debug((Object)sm.getString("standardServer.start.started"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!(this.services[i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)this.services[i])).start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.lifecycle.fireLifecycleEvent("after_start", null);
            return;
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        for (int i = 0; i < this.services.length; ++i) {
            if (!(this.services[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.services[i])).stop();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
        this.stopAwait();
    }

    public void init() throws Exception {
        this.initialize();
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            log.info((Object)sm.getString("standardServer.initialize.initialized"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("init", null);
        this.initialized = true;
        if (this.oname == null) {
            try {
                this.oname = new ObjectName("Catalina:type=Server");
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                log.error((Object)"Error registering ", (Throwable)e);
            }
        }
        try {
            ObjectName oname2 = new ObjectName(this.oname.getDomain() + ":type=StringCache");
            Registry.getRegistry(null, null).registerComponent((Object)new StringCache(), oname2, null);
        }
        catch (Exception e) {
            log.error((Object)"Error registering ", (Throwable)e);
        }
        for (int i = 0; i < this.services.length; ++i) {
            this.services[i].initialize();
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

