/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.parse.utils;

import java.util.List;
import java.util.Map;
import org.benf.cfr.reader.bytecode.AnonymousClassUsage;
import org.benf.cfr.reader.bytecode.analysis.opgraph.InstrIndex;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.LValue;
import org.benf.cfr.reader.bytecode.analysis.parse.StatementContainer;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationSimple;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.MemberFunctionInvokation;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.NewObject;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.StackValue;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.LocalVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.StackSSALabel;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple;
import org.benf.cfr.reader.bytecode.analysis.stack.StackEntry;
import org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer;
import org.benf.cfr.reader.bytecode.analysis.types.InnerClassInfo;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.functors.UnaryFunction;

public class CreationCollector {
    private final List<Triple> collectedConstructions = ListFactory.newList();
    private final Map<LValue, List<StatementContainer>> collectedCreations = MapFactory.newLazyMap(new UnaryFunction<LValue, List<StatementContainer>>(){

        @Override
        public List<StatementContainer> invoke(LValue arg) {
            return ListFactory.newList();
        }
    });
    private final AnonymousClassUsage anonymousClassUsage;

    public CreationCollector(AnonymousClassUsage anonymousClassUsage) {
        this.anonymousClassUsage = anonymousClassUsage;
    }

    public void collectCreation(LValue lValue, Expression rValue, StatementContainer container) {
        if (!(rValue instanceof NewObject)) {
            return;
        }
        if (!(lValue instanceof StackSSALabel) && !(lValue instanceof LocalVariable)) {
            return;
        }
        this.collectedCreations.get(lValue).add(container);
    }

    public void collectConstruction(Expression expression, MemberFunctionInvokation rValue, StatementContainer container) {
        if (expression instanceof StackValue) {
            StackSSALabel lValue = ((StackValue)expression).getStackValue();
            this.markConstruction(lValue, rValue, container);
            return;
        }
        if (expression instanceof LValueExpression) {
            LValue lValue = ((LValueExpression)expression).getLValue();
            this.markConstruction(lValue, rValue, container);
            return;
        }
    }

    private void markConstruction(LValue lValue, MemberFunctionInvokation rValue, StatementContainer container) {
        this.collectedConstructions.add(new Triple(lValue, null, new StatementPair(rValue, container)));
    }

    public void condenseConstructions(Method method, DCCommonState dcCommonState) {
        LValue lValue;
        for (Triple triple : this.collectedConstructions) {
            lValue = triple.getlValue();
            StatementPair constructionValue = triple.getConstruction();
            if (constructionValue == null) continue;
            InstrIndex idx = constructionValue.getLocation().getIndex();
            if (!this.collectedCreations.containsKey(lValue)) continue;
            List<StatementContainer> creations = this.collectedCreations.get(lValue);
            boolean found = false;
            for (StatementContainer creation : creations) {
                if (!creation.getIndex().isBackJumpFrom(idx)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            MemberFunctionInvokation memberFunctionInvokation = (MemberFunctionInvokation)constructionValue.getValue();
            JavaTypeInstance lValueType = memberFunctionInvokation.getClassTypeInstance();
            InferredJavaType inferredJavaType = lValue.getInferredJavaType();
            AbstractConstructorInvokation constructorInvokation = null;
            InnerClassInfo innerClassInfo = lValueType.getInnerClassHereInfo();
            if (innerClassInfo.isMethodScopedClass() && !innerClassInfo.isAnonymousClass()) {
                method.markUsedLocalClassType(lValueType);
            }
            if (innerClassInfo.isAnonymousClass()) {
                ConstructorInvokationAnonymousInner constructorInvokationAnonymousInner = new ConstructorInvokationAnonymousInner(memberFunctionInvokation, inferredJavaType, memberFunctionInvokation.getArgs(), dcCommonState, lValueType);
                constructorInvokation = constructorInvokationAnonymousInner;
                ClassFile classFile = constructorInvokationAnonymousInner.getClassFile();
                if (classFile != null) {
                    this.anonymousClassUsage.note(classFile, constructorInvokationAnonymousInner);
                    JavaTypeInstance anonymousTypeBase = ClassFile.getAnonymousTypeBase(classFile);
                    inferredJavaType.forceDelegate(new InferredJavaType(anonymousTypeBase, InferredJavaType.Source.UNKNOWN));
                } else {
                    BindingSuperContainer bindingSuperContainer = lValueType.getBindingSupers();
                    if (bindingSuperContainer != null) {
                        JavaTypeInstance bestGuess = bindingSuperContainer.getMostLikelyAnonymousType(lValueType);
                        inferredJavaType.forceDelegate(new InferredJavaType(bestGuess, InferredJavaType.Source.UNKNOWN));
                    }
                }
            } else {
                constructorInvokation = new ConstructorInvokationSimple(memberFunctionInvokation, inferredJavaType, memberFunctionInvokation.getArgs());
            }
            AssignmentSimple replacement = new AssignmentSimple(lValue, constructorInvokation);
            if (lValue instanceof StackSSALabel) {
                StackSSALabel stackSSALabel = (StackSSALabel)lValue;
                StackEntry stackEntry = stackSSALabel.getStackEntry();
                stackEntry.decrementUsage();
                stackEntry.incSourceCount();
            }
            StatementContainer constructionContainer = constructionValue.getLocation();
            constructionContainer.replaceStatement(replacement);
        }
        for (Map.Entry entry : this.collectedCreations.entrySet()) {
            lValue = (LValue)entry.getKey();
            for (StatementContainer statementContainer : (List)entry.getValue()) {
                if (lValue instanceof StackSSALabel) {
                    StackEntry stackEntry = ((StackSSALabel)lValue).getStackEntry();
                    stackEntry.decSourceCount();
                }
                statementContainer.nopOut();
            }
        }
    }

    private static class Triple {
        private final LValue lValue;
        private final StatementPair<NewObject> creation;
        private final StatementPair<MemberFunctionInvokation> construction;

        private Triple(LValue lValue, StatementPair<NewObject> creation, StatementPair<MemberFunctionInvokation> construction) {
            this.lValue = lValue;
            this.creation = creation;
            this.construction = construction;
        }

        private LValue getlValue() {
            return this.lValue;
        }

        private StatementPair<NewObject> getCreation() {
            return this.creation;
        }

        private StatementPair<MemberFunctionInvokation> getConstruction() {
            return this.construction;
        }
    }

    private static class StatementPair<X> {
        private final X value;
        private final StatementContainer location;

        private StatementPair(X value, StatementContainer location) {
            this.value = value;
            this.location = location;
        }

        private X getValue() {
            return this.value;
        }

        private StatementContainer getLocation() {
            return this.location;
        }
    }
}

