/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import org.xiph.speex.Encoder;
import org.xiph.speex.NbEncoder;
import org.xiph.speex.OggCrc;
import org.xiph.speex.SbEncoder;
import org.xiph.speex.SpeexEncoder;
import org.xiph.speex.spi.FilteredAudioInputStream;

public class Pcm2SpeexAudioInputStream
extends FilteredAudioInputStream {
    public static final int DEFAULT_BUFFER_SIZE = 2560;
    public static final int DEFAULT_SAMPLERATE = 8000;
    public static final int DEFAULT_CHANNELS = 1;
    public static final int DEFAULT_QUALITY = 3;
    public static final int DEFAULT_FRAMES_PER_PACKET = 1;
    public static final int DEFAULT_PACKETS_PER_OGG_PAGE = 20;
    public static final int UNKNOWN = -1;
    private SpeexEncoder encoder;
    private int mode;
    private int frameSize;
    private int framesPerPacket;
    private String comment = null;
    private int granulpos = 0;
    private int streamSerialNumber;
    private int packetsPerOggPage;
    private int packetCount;
    private int pageCount;
    private int oggCount;
    private boolean first;

    public Pcm2SpeexAudioInputStream(InputStream inputStream, AudioFormat audioFormat, long l) {
        this(-1, -1, inputStream, audioFormat, l, 2560);
    }

    public Pcm2SpeexAudioInputStream(int n, int n2, InputStream inputStream, AudioFormat audioFormat, long l) {
        this(n, n2, inputStream, audioFormat, l, 2560);
    }

    public Pcm2SpeexAudioInputStream(InputStream inputStream, AudioFormat audioFormat, long l, int n) {
        this(-1, -1, inputStream, audioFormat, l, n);
    }

    public Pcm2SpeexAudioInputStream(int n, int n2, InputStream inputStream, AudioFormat audioFormat, long l, int n3) {
        super(inputStream, audioFormat, l, n3);
        int n4;
        if (this.streamSerialNumber == 0) {
            this.streamSerialNumber = new Random().nextInt();
        }
        this.packetsPerOggPage = 20;
        this.packetCount = 0;
        this.pageCount = 0;
        this.framesPerPacket = 1;
        int n5 = (int)audioFormat.getSampleRate();
        if (n5 < 0) {
            n5 = 8000;
        }
        if ((n4 = audioFormat.getChannels()) < 0) {
            n4 = 1;
        }
        if (n < 0) {
            n = n5 < 12000 ? 0 : (n5 < 24000 ? 1 : 2);
        }
        this.mode = n;
        if (n2 < 0) {
            n2 = 3;
        }
        this.encoder = new SpeexEncoder();
        this.encoder.init(n, n2, n5, n4);
        this.frameSize = 2 * n4 * this.encoder.getFrameSize();
        this.comment = "Encoded with " + "Java Speex Encoder v0.9 ($Revision: 1.8 $)";
        this.first = true;
    }

    public void setSerialNumber(int n) {
        if (this.first) {
            this.streamSerialNumber = n;
        }
    }

    public void setFramesPerPacket(int n) {
        if (n <= 0) {
            this.packetsPerOggPage = 1;
        }
        this.framesPerPacket = n;
    }

    public void setPacketsPerOggPage(int n) {
        if (n <= 0) {
            n = 20;
        }
        if (n > 255) {
            n = 255;
        }
        this.packetsPerOggPage = n;
    }

    public void setComment(String string, boolean bl) {
        this.comment = string;
        if (bl) {
            string = string + "Java Speex Encoder v0.9 ($Revision: 1.8 $)";
        }
    }

    public void setQuality(int n) {
        this.encoder.getEncoder().setQuality(n);
        if (this.encoder.getEncoder().getVbr()) {
            this.encoder.getEncoder().setVbrQuality(n);
        }
    }

    public void setVbr(boolean bl) {
        this.encoder.getEncoder().setVbr(bl);
    }

    public Encoder getEncoder() {
        return this.encoder.getEncoder();
    }

    protected void fill() throws IOException {
        block17: {
            this.makeSpace();
            if (this.first) {
                this.writeHeaderFrame();
                this.writeCommentFrame();
                this.first = false;
            }
            while (true) {
                byte[] byArray;
                int n;
                int n2;
                if ((n2 = this.in.read(this.prebuf, this.precount, this.prebuf.length - this.precount)) < 0) {
                    if ((this.precount - this.prepos) % 2 != 0) {
                        throw new StreamCorruptedException("Incompleted last PCM sample when stream ended");
                    }
                    while (this.prepos < this.precount) {
                        if (this.precount - this.prepos < this.framesPerPacket * this.frameSize) {
                            if (this.prebuf.length - this.prepos < this.framesPerPacket * this.frameSize) {
                                n = this.prepos + this.framesPerPacket * this.frameSize;
                                byte[] byArray2 = new byte[n];
                                System.arraycopy(this.prebuf, 0, byArray2, 0, this.precount);
                                this.prebuf = byArray2;
                            }
                            while (this.precount < this.prepos + this.framesPerPacket * this.frameSize) {
                                this.prebuf[this.precount] = 0;
                                ++this.precount;
                            }
                        }
                        if (this.packetCount == 0) {
                            this.writeOggPageHeader(this.packetsPerOggPage, 0);
                        }
                        for (n = 0; n < this.framesPerPacket; ++n) {
                            this.encoder.processData(this.prebuf, this.prepos, this.frameSize);
                        }
                        this.prepos += this.framesPerPacket * this.frameSize;
                        n = this.encoder.getProcessedDataByteSize();
                        while (this.buf.length - this.oggCount < n) {
                            int n3 = this.buf.length * 2;
                            byArray = new byte[n3];
                            System.arraycopy(this.buf, 0, byArray, 0, this.oggCount);
                            this.buf = byArray;
                        }
                        this.buf[this.count + 27 + this.packetCount] = (byte)(0xFF & n);
                        this.encoder.getProcessedData(this.buf, this.oggCount);
                        this.oggCount += n;
                        ++this.packetCount;
                        if (this.packetCount < this.packetsPerOggPage) continue;
                        this.writeOggPageChecksum();
                        return;
                    }
                    if (this.packetCount > 0) {
                        this.buf[this.count + 5] = 4;
                        this.buf[this.count + 26] = (byte)(0xFF & this.packetCount);
                        System.arraycopy(this.buf, this.count + 27 + this.packetsPerOggPage, this.buf, this.count + 27 + this.packetCount, this.oggCount - (this.count + 27 + this.packetsPerOggPage));
                        this.oggCount -= this.packetsPerOggPage - this.packetCount;
                        this.writeOggPageChecksum();
                    }
                    return;
                }
                if (n2 > 0) {
                    this.precount += n2;
                    if (this.precount - this.prepos < this.framesPerPacket * this.frameSize) continue;
                    while (this.precount - this.prepos >= this.framesPerPacket * this.frameSize) {
                        if (this.packetCount == 0) {
                            this.writeOggPageHeader(this.packetsPerOggPage, 0);
                        }
                        for (n = 0; n < this.framesPerPacket; ++n) {
                            this.encoder.processData(this.prebuf, this.prepos, this.frameSize);
                        }
                        this.prepos += this.framesPerPacket * this.frameSize;
                        n = this.encoder.getProcessedDataByteSize();
                        while (this.buf.length - this.oggCount < n) {
                            int n4 = this.buf.length * 2;
                            byArray = new byte[n4];
                            System.arraycopy(this.buf, 0, byArray, 0, this.oggCount);
                            this.buf = byArray;
                        }
                        this.buf[this.count + 27 + this.packetCount] = (byte)(0xFF & n);
                        this.encoder.getProcessedData(this.buf, this.oggCount);
                        this.oggCount += n;
                        ++this.packetCount;
                        if (this.packetCount < this.packetsPerOggPage) continue;
                        this.writeOggPageChecksum();
                    }
                    System.arraycopy(this.prebuf, this.prepos, this.prebuf, 0, this.precount - this.prepos);
                    this.precount -= this.prepos;
                    this.prepos = 0;
                    if (this.packetCount < this.packetsPerOggPage) continue;
                    this.writeOggPageChecksum();
                    return;
                }
                if (this.precount < this.prebuf.length) break block17;
                if (this.prepos <= 0) break;
                System.arraycopy(this.prebuf, this.prepos, this.prebuf, 0, this.precount - this.prepos);
                this.precount -= this.prepos;
                this.prepos = 0;
            }
            return;
        }
    }

    public synchronized int available() throws IOException {
        int n = super.available();
        int n2 = this.precount - this.prepos + this.in.available();
        if (this.encoder.getEncoder().getVbr()) {
            switch (this.mode) {
                case 0: {
                    return n + (27 + 2 * this.packetsPerOggPage) * (n2 / (this.packetsPerOggPage * this.framesPerPacket * 320));
                }
                case 1: {
                    return n + (27 + 2 * this.packetsPerOggPage) * (n2 / (this.packetsPerOggPage * this.framesPerPacket * 640));
                }
                case 2: {
                    return n + (27 + 3 * this.packetsPerOggPage) * (n2 / (this.packetsPerOggPage * this.framesPerPacket * 1280));
                }
            }
            return n;
        }
        switch (this.mode) {
            case 0: {
                int n3 = NbEncoder.NB_FRAME_SIZE[NbEncoder.NB_QUALITY_MAP[this.encoder.getEncoder().getMode()]];
                n3 = n3 + 7 >> 3;
                return n += (27 + this.packetsPerOggPage + this.packetsPerOggPage * n3) * (n2 / (this.packetsPerOggPage * this.framesPerPacket * 320));
            }
            case 1: {
                int n4 = SbEncoder.NB_FRAME_SIZE[SbEncoder.NB_QUALITY_MAP[this.encoder.getEncoder().getMode()]];
                n4 += SbEncoder.SB_FRAME_SIZE[SbEncoder.WB_QUALITY_MAP[this.encoder.getEncoder().getMode()]];
                n4 = n4 + 7 >> 3;
                return n += (27 + this.packetsPerOggPage + this.packetsPerOggPage * n4) * (n2 / (this.packetsPerOggPage * this.framesPerPacket * 640));
            }
            case 2: {
                int n5 = SbEncoder.NB_FRAME_SIZE[SbEncoder.NB_QUALITY_MAP[this.encoder.getEncoder().getMode()]];
                n5 += SbEncoder.SB_FRAME_SIZE[SbEncoder.WB_QUALITY_MAP[this.encoder.getEncoder().getMode()]];
                n5 += SbEncoder.SB_FRAME_SIZE[SbEncoder.UWB_QUALITY_MAP[this.encoder.getEncoder().getMode()]];
                n5 = n5 + 7 >> 3;
                return n += (27 + this.packetsPerOggPage + this.packetsPerOggPage * n5) * (n2 / (this.packetsPerOggPage * this.framesPerPacket * 1280));
            }
        }
        return n;
    }

    private void writeOggPageHeader(int n, int n2) {
        int n3;
        while (this.buf.length - this.count < 27 + n) {
            n3 = this.buf.length * 2;
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        Pcm2SpeexAudioInputStream.writeString(this.buf, this.count, "OggS");
        this.buf[this.count + 4] = 0;
        this.buf[this.count + 5] = (byte)n2;
        Pcm2SpeexAudioInputStream.writeLong(this.buf, this.count + 6, this.granulpos);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.count + 14, this.streamSerialNumber);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.count + 18, this.pageCount++);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.count + 22, 0);
        this.buf[this.count + 26] = (byte)(0xFF & n);
        for (n3 = 0; n3 < n; ++n3) {
            this.buf[this.count + 27 + n3] = 0;
        }
        this.oggCount = this.count + 27 + n;
    }

    private void writeOggPageChecksum() {
        this.granulpos += this.frameSize * this.packetCount / 2;
        Pcm2SpeexAudioInputStream.writeLong(this.buf, this.count + 6, this.granulpos);
        int n = OggCrc.checksum(0, this.buf, this.count, this.oggCount - this.count);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.count + 22, n);
        this.count = this.oggCount;
        this.packetCount = 0;
    }

    private void writeHeaderFrame() {
        while (this.buf.length - this.count < 108) {
            int n = this.buf.length * 2;
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.writeOggPageHeader(1, 2);
        this.buf[this.count + 27] = 80;
        Pcm2SpeexAudioInputStream.writeString(this.buf, this.oggCount, "Speex   ");
        Pcm2SpeexAudioInputStream.writeString(this.buf, this.oggCount + 8, "speex-1.0           ");
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 28, 1);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 32, 80);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 36, this.encoder.getSampleRate());
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 40, this.mode);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 44, 4);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 48, this.encoder.getChannels());
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 52, -1);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 56, this.encoder.getFrameSize());
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 60, this.encoder.getEncoder().getVbr() ? 1 : 0);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 64, this.framesPerPacket);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 68, 0);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 72, 0);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + 76, 0);
        this.oggCount += 80;
        this.writeOggPageChecksum();
    }

    private void writeCommentFrame() {
        if (this.comment.length() > 247) {
            this.comment = this.comment.substring(0, 247);
        }
        int n = this.comment.length();
        while (this.buf.length - this.count < n + 8 + 28) {
            int n2 = this.buf.length * 2;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.writeOggPageHeader(1, 0);
        this.buf[this.count + 27] = (byte)(0xFF & n + 8);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount, n);
        Pcm2SpeexAudioInputStream.writeString(this.buf, this.oggCount + 4, this.comment);
        Pcm2SpeexAudioInputStream.writeInt(this.buf, this.oggCount + n + 4, 0);
        this.oggCount += n + 8;
        this.writeOggPageChecksum();
    }

    private static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(0xFF & n2);
        byArray[n + 1] = (byte)(0xFF & n2 >>> 8);
        byArray[n + 2] = (byte)(0xFF & n2 >>> 16);
        byArray[n + 3] = (byte)(0xFF & n2 >>> 24);
    }

    private static void writeLong(byte[] byArray, int n, long l) {
        byArray[n] = (byte)(0xFFL & l);
        byArray[n + 1] = (byte)(0xFFL & l >>> 8);
        byArray[n + 2] = (byte)(0xFFL & l >>> 16);
        byArray[n + 3] = (byte)(0xFFL & l >>> 24);
        byArray[n + 4] = (byte)(0xFFL & l >>> 32);
        byArray[n + 5] = (byte)(0xFFL & l >>> 40);
        byArray[n + 6] = (byte)(0xFFL & l >>> 48);
        byArray[n + 7] = (byte)(0xFFL & l >>> 56);
    }

    private static void writeString(byte[] byArray, int n, String string) {
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }
}

