#!/bin/sh
# BLURB gpl
# 
#                            Coda File System
#                               Release 6
# 
#           Copyright (c) 1987-2003 Carnegie Mellon University
#                   Additional copyrights listed below
# 
# This  code  is  distributed "AS IS" without warranty of any kind under
# the terms of the GNU General Public Licence Version 2, as shown in the
# file  LICENSE.  The  technical and financial  contributors to Coda are
# listed in the file CREDITS.
# 
#                         Additional copyrights
#                            none currently
# 
#*/

#
# Configuration
#
prefix=/usr/pkg
exec_prefix=${prefix}
conf="`${exec_prefix}/sbin/codaconfedit server.conf`"
if [ -f ${conf} ] ; then
  . ${conf}
fi

if [ x${vicedir} = x ] ; then
  vicedir=/vice
fi

THISHOST=`hostname | tr A-Z a-z`
REMOTE=${vicedir}/vol/remote

PATH=/sbin:/usr/sbin:$PATH
export PATH
cd ${vicedir}/vol/remote
SERVERS=""

# Get the list of volumes from 
#  - all servers (if argc = 1)
#  - the listed servers (if argc > 1) 

if [ $#  = 0 ]; then
	SERVERS=`awk '{ print $1 }' ${vicedir}/db/servers`
else
    for i in $* ; do
        NEWSERVER=`awk '{ print $1 }' ${vicedir}/db/servers | grep $i `
	SERVERS="$NEWSERVER $SERVERS"
    done
fi

echo "Fetching volume lists from servers:"

for server in $SERVERS
do 
    ${prefix}/sbin/volutil -h ${server} getvolumelist ${REMOTE}/${server}.list.new

    if [ -r ${REMOTE}/${server}.list.new ]; then
        mv ${REMOTE}/${server}.list.new ${REMOTE}/${server}.list
	echo " $server - success"
    else 
	echo " $server - FAILED, check if coda server is running"
    fi
done

# Make on big list called composite
cat ${REMOTE}/*.list> ${vicedir}/vol/BigVolumeList

# Make a new vldb from the list
${prefix}/sbin/volutil makevldb  ${vicedir}/vol/BigVolumeList
