/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.vmconversion.AsciiProgressBar;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.httpclient.methods.RequestEntity;

public class ProgressFileRequestEntity
implements RequestEntity {
    private static int CHUNK_SIZE = 65536;
    File diskImage;
    long resumeFrom;
    PrintStream console;

    public ProgressFileRequestEntity(File diskImage_, long resumeFrom_, PrintStream console_) {
        this.diskImage = diskImage_;
        this.resumeFrom = resumeFrom_;
        this.console = console_;
        if (this.resumeFrom < 0L || this.resumeFrom >= this.diskImage.length()) {
            throw new IllegalArgumentException("Resume position " + this.resumeFrom + " does not fall within the size of " + this.diskImage);
        }
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public long getContentLength() {
        return this.diskImage.length() - this.resumeFrom;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream out) throws IOException {
        int actualread;
        FileInputStream in = new FileInputStream(this.diskImage);
        in.skip(this.resumeFrom);
        byte[] buf = new byte[CHUNK_SIZE];
        AsciiProgressBar progress = new AsciiProgressBar(this.diskImage.length(), this.console);
        progress.preamble();
        progress.updateRelative(this.resumeFrom);
        while ((actualread = in.read(buf, 0, CHUNK_SIZE)) > 0) {
            progress.updateRelative(actualread);
            out.write(buf, 0, actualread);
        }
        progress.postamble();
    }
}

