/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.dtbook;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.dtbook.DTBookHandler;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DTBookChecker
implements ContentChecker {
    ZipFile zip;
    Report report;
    String path;
    XRefChecker xrefChecker;
    static XMLValidator dtbookValidator = new XMLValidator("rng/dtbook-2005-2.rng");

    public DTBookChecker(ZipFile zip, Report report, String path, XRefChecker xrefChecker) {
        this.zip = zip;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
    }

    public void runChecks() {
        ZipEntry opfEntry = this.zip.getEntry(this.path);
        if (opfEntry == null) {
            this.report.error(null, 0, "DTBook file " + this.path + " is missing");
        } else {
            XMLParser dtbookParser = new XMLParser(this.zip, this.path, this.report);
            dtbookParser.addValidator(dtbookValidator);
            DTBookHandler dtbookHandler = new DTBookHandler(dtbookParser, this.path, this.xrefChecker);
            dtbookParser.addXMLHandler(dtbookHandler);
            dtbookParser.process();
        }
    }
}

