/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.DataDerivTypeFunction;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.StartAttributeDerivFunction;
import com.thaiopensource.relaxng.impl.StartTagOpenDerivFunction;
import com.thaiopensource.relaxng.impl.StartTagOpenRecoverDerivFunction;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.xml.util.Name;
import java.util.Hashtable;
import org.relaxng.datatype.ValidationContext;

final class PatternMemo {
    private final Pattern pattern;
    private final ValidatorPatternBuilder builder;
    private final boolean notAllowed;
    private PatternMemo memoEndAttributes;
    private PatternMemo memoTextOnly;
    private PatternMemo memoEndTagDeriv;
    private PatternMemo memoMixedTextDeriv;
    private PatternMemo memoIgnoreMissingAttributes;
    private Hashtable startTagOpenDerivMap;
    private Hashtable startTagOpenRecoverDerivMap;
    private Hashtable startAttributeDerivMap;
    private DataDerivType memoDataDerivType;

    PatternMemo(Pattern pattern, ValidatorPatternBuilder builder) {
        this.pattern = pattern;
        this.builder = builder;
        this.notAllowed = pattern.isNotAllowed();
    }

    Pattern getPattern() {
        return this.pattern;
    }

    ValidatorPatternBuilder getPatternBuilder() {
        return this.builder;
    }

    boolean isNotAllowed() {
        return this.notAllowed;
    }

    PatternMemo endAttributes() {
        if (this.memoEndAttributes == null) {
            this.memoEndAttributes = this.applyForPatternMemo(this.builder.getEndAttributesFunction());
        }
        return this.memoEndAttributes;
    }

    PatternMemo endAttributes(PatternFunction f) {
        if (this.memoEndAttributes == null) {
            this.memoEndAttributes = this.applyForPatternMemo(f);
        }
        return this.memoEndAttributes;
    }

    PatternMemo ignoreMissingAttributes() {
        if (this.memoIgnoreMissingAttributes == null) {
            this.memoIgnoreMissingAttributes = this.applyForPatternMemo(this.builder.getIgnoreMissingAttributesFunction());
        }
        return this.memoIgnoreMissingAttributes;
    }

    PatternMemo ignoreMissingAttributes(PatternFunction f) {
        if (this.memoIgnoreMissingAttributes == null) {
            this.memoIgnoreMissingAttributes = this.applyForPatternMemo(f);
        }
        return this.memoIgnoreMissingAttributes;
    }

    PatternMemo textOnly() {
        if (this.memoTextOnly == null) {
            this.memoTextOnly = this.applyForPatternMemo(this.builder.getTextOnlyFunction());
        }
        return this.memoTextOnly;
    }

    PatternMemo textOnly(PatternFunction f) {
        if (this.memoTextOnly == null) {
            this.memoTextOnly = this.applyForPatternMemo(f);
        }
        return this.memoTextOnly;
    }

    PatternMemo endTagDeriv() {
        if (this.memoEndTagDeriv == null) {
            this.memoEndTagDeriv = this.applyForPatternMemo(this.builder.getEndTagDerivFunction());
        }
        return this.memoEndTagDeriv;
    }

    PatternMemo endTagDeriv(PatternFunction f) {
        if (this.memoEndTagDeriv == null) {
            this.memoEndTagDeriv = this.applyForPatternMemo(f);
        }
        return this.memoEndTagDeriv;
    }

    PatternMemo mixedTextDeriv() {
        if (this.memoMixedTextDeriv == null) {
            this.memoMixedTextDeriv = this.applyForPatternMemo(this.builder.getMixedTextDerivFunction());
        }
        return this.memoMixedTextDeriv;
    }

    PatternMemo mixedTextDeriv(PatternFunction f) {
        if (this.memoMixedTextDeriv == null) {
            this.memoMixedTextDeriv = this.applyForPatternMemo(f);
        }
        return this.memoMixedTextDeriv;
    }

    PatternMemo startTagOpenDeriv(Name name) {
        return this.startTagOpenDeriv(name, null);
    }

    PatternMemo startTagOpenDeriv(StartTagOpenDerivFunction f) {
        return this.startTagOpenDeriv(f.getName(), f);
    }

    private PatternMemo startTagOpenDeriv(Name name, StartTagOpenDerivFunction f) {
        PatternMemo tem;
        if (this.startTagOpenDerivMap == null) {
            this.startTagOpenDerivMap = new Hashtable();
        } else {
            tem = (PatternMemo)this.startTagOpenDerivMap.get(name);
            if (tem != null) {
                return tem;
            }
        }
        if (f == null) {
            f = new StartTagOpenDerivFunction(name, this.builder);
        }
        tem = this.applyForPatternMemo(f);
        this.startTagOpenDerivMap.put(name, tem);
        return tem;
    }

    PatternMemo startTagOpenRecoverDeriv(Name name) {
        return this.startTagOpenRecoverDeriv(name, null);
    }

    PatternMemo startTagOpenRecoverDeriv(StartTagOpenRecoverDerivFunction f) {
        return this.startTagOpenRecoverDeriv(f.getName(), f);
    }

    private PatternMemo startTagOpenRecoverDeriv(Name name, StartTagOpenRecoverDerivFunction f) {
        PatternMemo tem;
        if (this.startTagOpenRecoverDerivMap == null) {
            this.startTagOpenRecoverDerivMap = new Hashtable();
        } else {
            tem = (PatternMemo)this.startTagOpenRecoverDerivMap.get(name);
            if (tem != null) {
                return tem;
            }
        }
        if (f == null) {
            f = new StartTagOpenRecoverDerivFunction(name, this.builder);
        }
        tem = this.applyForPatternMemo(f);
        this.startTagOpenRecoverDerivMap.put(name, tem);
        return tem;
    }

    PatternMemo startAttributeDeriv(Name name) {
        return this.startAttributeDeriv(name, null);
    }

    PatternMemo startAttributeDeriv(StartAttributeDerivFunction f) {
        return this.startAttributeDeriv(f.getName(), f);
    }

    private PatternMemo startAttributeDeriv(Name name, StartAttributeDerivFunction f) {
        PatternMemo tem;
        if (this.startAttributeDerivMap == null) {
            this.startAttributeDerivMap = new Hashtable();
        } else {
            tem = (PatternMemo)this.startAttributeDerivMap.get(name);
            if (tem != null) {
                return tem;
            }
        }
        if (f == null) {
            f = new StartAttributeDerivFunction(name, this.builder);
        }
        tem = this.applyForPatternMemo(f);
        this.startAttributeDerivMap.put(name, tem);
        return tem;
    }

    DataDerivType dataDerivType() {
        if (this.memoDataDerivType == null) {
            this.memoDataDerivType = DataDerivTypeFunction.dataDerivType(this.builder, this.pattern).copy();
        }
        return this.memoDataDerivType;
    }

    PatternMemo dataDeriv(String str, ValidationContext vc) {
        return this.dataDerivType().dataDeriv(this.builder, this.pattern, str, vc);
    }

    PatternMemo recoverAfter() {
        return this.applyForPatternMemo(this.builder.getRecoverAfterFunction());
    }

    private PatternMemo applyForPatternMemo(PatternFunction f) {
        return this.builder.getPatternMemo(this.pattern.applyForPattern(f));
    }
}

