/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.twogtp;

import java.io.File;
import java.io.FileInputStream;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.twogtp.Filter;
import net.sf.gogui.utils.ErrorMessage;

public class Openings {
    private int m_currentFile;
    private final File m_directory;
    private File[] m_files;
    private GameTree m_gameTree;

    public Openings(File file) throws Exception {
        if (!file.isDirectory()) {
            throw new ErrorMessage(file + " is not a directory");
        }
        this.m_directory = file;
        this.m_files = file.listFiles(new Filter());
        if (this.m_files.length == 0) {
            throw new ErrorMessage("No SGF files found in " + file);
        }
        this.sortFiles();
        this.m_currentFile = -1;
    }

    public String getDirectory() {
        return this.m_directory.toString();
    }

    public String getFilename() {
        return this.m_files[this.m_currentFile].toString();
    }

    public GameInformation getGameInformation() {
        return this.m_gameTree.getGameInformation();
    }

    public GameTree getGameTree() {
        return this.m_gameTree;
    }

    public int getNumber() {
        return this.m_files.length;
    }

    public void loadFile(int n) throws Exception {
        File file = this.m_files[n];
        FileInputStream fileInputStream = new FileInputStream(file);
        SgfReader sgfReader = new SgfReader(fileInputStream, file.toString(), null, 0L);
        this.m_gameTree = sgfReader.getGameTree();
        this.m_currentFile = n;
    }

    private void sortFiles() {
        for (int i = 0; i < this.m_files.length - 1; ++i) {
            for (int j = i + 1; j < this.m_files.length; ++j) {
                if (this.m_files[i].compareTo(this.m_files[j]) <= 0) continue;
                File file = this.m_files[i];
                this.m_files[i] = this.m_files[j];
                this.m_files[j] = file;
            }
        }
    }
}

