/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.utils;

import java.io.PrintStream;
import net.sf.gogui.utils.Statistics;

public class Histogram
extends Statistics {
    private final int m_size;
    private final double m_max;
    private final double m_min;
    private final double m_step;
    private int[] m_array;

    public Histogram(double d, double d2, double d3) {
        this.m_min = d;
        this.m_max = d2;
        this.m_step = d3;
        this.m_size = Math.max(1, (int)Math.ceil((d2 - d) / d3));
        this.m_array = new int[this.m_size];
    }

    public void add(double d) {
        super.add(d);
        int n = d == this.m_max ? this.m_size - 1 : (int)((d - this.m_min) / this.m_step);
        int n2 = n;
        this.m_array[n2] = this.m_array[n2] + 1;
    }

    public int getCount(int n) {
        return this.m_array[n];
    }

    public int getSize() {
        return this.m_size;
    }

    public double getStep() {
        return this.m_step;
    }

    public double getValue(int n) {
        return this.m_min + (double)n * this.m_step;
    }

    public void printHtml(PrintStream printStream) {
        int n;
        printStream.print("<p>\n<table cellspacing=\"1\" cellpadding=\"0\" rules=\"groups\">\n");
        for (int i = 0; i < this.m_size - 1 && this.m_array[i] == 0; ++i) {
        }
        for (n = this.m_size - 1; n > 0 && this.m_array[n] == 0; --n) {
        }
        for (int i = i; i <= n; ++i) {
            int n2 = 630;
            int n3 = this.m_array[i] * n2 / this.getCount();
            if (this.getValue(i) >= 0.0 && this.getValue(i - 1) < 0.0) {
                printStream.print("<tbody>\n");
            }
            printStream.print("<tr><td align=\"right\"><small>" + this.getValue(i) + "</small></td><td><table cellspacing=\"0\"" + " cellpadding=\"0\" width=\"" + n2 + "\"><tr>" + "<td bgcolor=\"#666666\" width=\"" + n3 + "\"></td>" + "<td bgcolor=\"#cccccc\" width=\"" + (n2 - n3) + "\"><small>" + this.m_array[i] + "</small></td></tr></table></td></tr>\n");
        }
        printStream.print("</table>\n</p>\n");
    }
}

