/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.compression;

import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.compression.BZip2ChunkCodec;
import org.campagnelab.goby.compression.ChunkCodec;
import org.campagnelab.goby.compression.InvalidChecksumException;
import org.campagnelab.goby.compression.ProtobuffCollectionHandler;

public class HybridChunkCodec2
implements ChunkCodec {
    private boolean debug = false;
    public static final byte REGISTRATION_CODE = -5;
    private ProtobuffCollectionHandler handler;
    private final BZip2ChunkCodec bzip2Codec = new BZip2ChunkCodec();
    private static final Log LOG = LogFactory.getLog(HybridChunkCodec2.class);
    private int chunkIndex = 0;
    private CRC32 crc32 = new CRC32();

    @Override
    public String name() {
        return "hybrid-2";
    }

    @Override
    public byte registrationCode() {
        return -5;
    }

    @Override
    public ByteArrayOutputStream encode(Message readCollection) throws IOException {
        if (readCollection == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        DataOutputStream completeChunkData = new DataOutputStream(result);
        ByteArrayOutputStream hybridStreamBytes = new ByteArrayOutputStream();
        Message reducedProtoBuff = this.handler.compressCollection(readCollection, hybridStreamBytes);
        int hybridStreamSize = hybridStreamBytes.size();
        byte[] bytes = hybridStreamBytes.toByteArray();
        this.crc32.reset();
        this.crc32.update(bytes);
        int crcChecksum = (int)this.crc32.getValue();
        completeChunkData.writeInt(hybridStreamSize);
        completeChunkData.writeInt(crcChecksum);
        completeChunkData.write(bytes);
        ByteArrayOutputStream out = this.bzip2Codec.encode(reducedProtoBuff);
        byte[] gzipBytes = out.toByteArray();
        int gzipBytesSize = gzipBytes.length;
        completeChunkData.write(gzipBytes);
        completeChunkData.flush();
        if (this.debug && this.chunkIndex % 100 == 0) {
            int originalBZip2Size = this.bzip2Codec.encode(readCollection).toByteArray().length;
            int gain = originalBZip2Size - (gzipBytesSize + hybridStreamSize);
            LOG.info((Object)String.format("compressed size=%d gzip size=%d (original gzip=%d) percent compressed/(compressed+gzip) %g gain=%d, %g%% ", hybridStreamSize, gzipBytesSize, originalBZip2Size, 100.0 * (double)hybridStreamSize / (double)(hybridStreamSize + gzipBytesSize), gain, (double)gain * 100.0 / (double)originalBZip2Size));
        }
        ++this.chunkIndex;
        return result;
    }

    @Override
    public Message decode(byte[] bytes) throws IOException {
        DataInputStream completeChunkData = new DataInputStream(new ByteArrayInputStream(bytes));
        int compressedSize = completeChunkData.readInt();
        int storedChecksum = completeChunkData.readInt();
        byte[] compressedBytes = new byte[compressedSize];
        int read = completeChunkData.read(compressedBytes, 0, compressedSize);
        assert (read == compressedSize) : "read size must match recorded size.";
        this.crc32.reset();
        this.crc32.update(compressedBytes);
        int computedChecksum = (int)this.crc32.getValue();
        if (computedChecksum != storedChecksum) {
            throw new InvalidChecksumException();
        }
        int bytesLeft = bytes.length - 4 - compressedSize - 4;
        byte[] leftOver = new byte[bytesLeft];
        System.arraycopy(bytes, 8 + compressedSize, leftOver, 0, bytesLeft);
        Message reducedProtoBuff = this.bzip2Codec.decode(leftOver);
        if (reducedProtoBuff == null) {
            return null;
        }
        return this.handler.decompressCollection(reducedProtoBuff, compressedBytes);
    }

    @Override
    public int getSuggestedChunkSize() {
        return 100000;
    }

    @Override
    public void setHandler(ProtobuffCollectionHandler handler) {
        this.handler = handler;
        this.bzip2Codec.setHandler(handler);
    }

    @Override
    public boolean validate(byte firstByte, DataInputStream input) {
        try {
            int numRead;
            this.crc32.reset();
            byte b = input.readByte();
            byte c = input.readByte();
            byte d = input.readByte();
            int fullCodecContentSize = firstByte << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
            int hybridContentSize = input.readInt();
            int storedChecksum = input.readInt();
            if (fullCodecContentSize < 0) {
                return false;
            }
            if (hybridContentSize < 0) {
                return false;
            }
            byte[] bytes = new byte[hybridContentSize];
            int totalRead = 0;
            int offset = 0;
            while (totalRead < hybridContentSize && (numRead = input.read(bytes, offset, hybridContentSize - totalRead)) != -1) {
                totalRead += numRead;
                offset += numRead;
            }
            if (totalRead != hybridContentSize) {
                return false;
            }
            this.crc32.update(bytes);
            int computedChecksum = (int)this.crc32.getValue();
            return computedChecksum == storedChecksum;
        }
        catch (IOException e) {
            return false;
        }
    }
}

