/* -*- Mode: C; c-file-style: "gnu" -*-
   arrays.h -- operations and instance data for arrays.
   Created: Chris Toshok <toshok@hungry.com>, 13-Aug-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _arrays_h
#define _arrays_h

#ifdef __cplusplus
extern "C" {
#endif

#include "objects.h"
#include "ClazzFile.h"

  extern ClazzFile *array_element_type(JNIEnv *env, ClazzFile *array_type);
  japhar_obj create_array(JNIEnv *env, jint length, char *element_classname);
  japhar_obj new_array(JNIEnv *env, u4 n_elem, ClazzFile *array_type);
  japhar_obj multi_new_array (JNIEnv *env, jint *n_elems, int dimensions, ClazzFile *);
  jvalue *jobjects_to_jvalues(JNIEnv *env, jobjectArray jarr);

  jint get_array_length(japhar_obj arrayref);
  void* get_array_body(japhar_obj arrayref);

#ifdef __cplusplus
};
#endif

#endif /* _arrays_h */
