/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast;

import java.util.List;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Return;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturnLineNumberAnalyzer {
    public static void Check(Method method) {
        int afterListLineNumber;
        List<Instruction> list = method.getFastNodes();
        int length = list.size();
        if (length > 1 && (afterListLineNumber = list.get((int)(length - 1)).lineNumber) != Instruction.UNKNOWN_LINE_NUMBER) {
            ReturnLineNumberAnalyzer.RecursiveCheck(list, afterListLineNumber);
        }
    }

    private static void RecursiveCheck(List<Instruction> list, int afterListLineNumber) {
        int index = list.size();
        while (index-- > 0) {
            Instruction instruction = list.get(index);
            switch (instruction.opcode) {
                case 301: 
                case 302: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 319: {
                    List<Instruction> instructions = ((FastList)instruction).instructions;
                    if (instructions == null) break;
                    ReturnLineNumberAnalyzer.RecursiveCheck(instructions, afterListLineNumber);
                    break;
                }
                case 307: {
                    FastTest2Lists ft2l = (FastTest2Lists)instruction;
                    ReturnLineNumberAnalyzer.RecursiveCheck(ft2l.instructions, afterListLineNumber);
                    ReturnLineNumberAnalyzer.RecursiveCheck(ft2l.instructions2, afterListLineNumber);
                    break;
                }
                case 314: 
                case 315: 
                case 316: {
                    FastSwitch.Pair[] pairs = ((FastSwitch)instruction).pairs;
                    if (pairs == null) break;
                    int i = pairs.length - 1;
                    while (i >= 0) {
                        List<Instruction> instructions = pairs[i].getInstructions();
                        if (instructions != null) {
                            ReturnLineNumberAnalyzer.RecursiveCheck(instructions, afterListLineNumber);
                            if (instructions.size() > 0) {
                                afterListLineNumber = instructions.get((int)0).lineNumber;
                            }
                        }
                        --i;
                    }
                    break;
                }
                case 318: {
                    int i;
                    FastTry ft = (FastTry)instruction;
                    if (ft.finallyInstructions != null) {
                        ReturnLineNumberAnalyzer.RecursiveCheck(ft.finallyInstructions, afterListLineNumber);
                        if (ft.finallyInstructions.size() > 0) {
                            afterListLineNumber = ft.finallyInstructions.get((int)0).lineNumber;
                        }
                    }
                    if (ft.catches != null) {
                        i = ft.catches.size() - 1;
                        while (i >= 0) {
                            List<Instruction> catchInstructions = ft.catches.get((int)i).instructions;
                            ReturnLineNumberAnalyzer.RecursiveCheck(catchInstructions, afterListLineNumber);
                            if (catchInstructions.size() > 0) {
                                afterListLineNumber = catchInstructions.get((int)0).lineNumber;
                            }
                            --i;
                        }
                    }
                    ReturnLineNumberAnalyzer.RecursiveCheck(ft.instructions, afterListLineNumber);
                    break;
                }
                case 177: {
                    Return r = (Return)instruction;
                    if (r.lineNumber <= afterListLineNumber) break;
                    r.lineNumber = Instruction.UNKNOWN_LINE_NUMBER;
                }
            }
            afterListLineNumber = instruction.lineNumber;
        }
    }
}

