/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri.json;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RemoteCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class JSONDeserializer {
    public static void deserializeAbstractPacketExtensionAttributes(JSONObject jsonObject, AbstractPacketExtension abstractPacketExtension) {
        for (Map.Entry e : jsonObject.entrySet()) {
            Object value;
            String name;
            Object key = e.getKey();
            if (key == null || (name = key.toString()) == null || (value = e.getValue()) instanceof JSONObject || value instanceof JSONArray) continue;
            abstractPacketExtension.setAttribute(name, value);
        }
    }

    public static <T extends CandidatePacketExtension> T deserializeCandidate(JSONObject candidate, Class<T> candidateIQClass, IceUdpTransportPacketExtension transportIQ) {
        CandidatePacketExtension candidateIQ;
        if (candidate == null) {
            candidateIQ = null;
        } else {
            try {
                candidateIQ = (CandidatePacketExtension)candidateIQClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException iae) {
                throw new UndeclaredThrowableException(iae);
            }
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(candidate, candidateIQ);
            transportIQ.addChildExtension(candidateIQ);
        }
        return (T)candidateIQ;
    }

    public static void deserializeCandidates(JSONArray candidates, IceUdpTransportPacketExtension transportIQ) {
        if (candidates != null && !candidates.isEmpty()) {
            for (Object candidate : candidates) {
                JSONDeserializer.deserializeCandidate((JSONObject)candidate, IceCandidatePacketExtension.class, transportIQ);
            }
        }
    }

    public static void deserializeWebsocket(String webSocketUrl, IceUdpTransportPacketExtension transportIQ) {
        if (webSocketUrl == null) {
            Object webSocketIQ = null;
        } else {
            WebSocketPacketExtension webSocketIQ = new WebSocketPacketExtension();
            if (webSocketUrl.equals("active")) {
                webSocketIQ.setActive(true);
            } else {
                webSocketIQ.setUrl(webSocketUrl);
            }
            transportIQ.addChildExtension(webSocketIQ);
        }
    }

    public static void deserializeWebsockets(JSONArray webSockets, IceUdpTransportPacketExtension transportIQ) {
        if (webSockets != null && !webSockets.isEmpty()) {
            for (Object webSocket : webSockets) {
                JSONDeserializer.deserializeWebsocket((String)webSocket, transportIQ);
            }
        }
    }

    private static Boolean objectToBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.valueOf(o.toString());
    }

    public static DtlsFingerprintPacketExtension deserializeFingerprint(JSONObject fingerprint, IceUdpTransportPacketExtension transportIQ) {
        DtlsFingerprintPacketExtension fingerprintIQ;
        if (fingerprint == null) {
            fingerprintIQ = null;
        } else {
            Object theFingerprint = fingerprint.get((Object)"fingerprint");
            fingerprintIQ = new DtlsFingerprintPacketExtension();
            if (theFingerprint != null) {
                fingerprintIQ.setFingerprint(theFingerprint.toString());
            }
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(fingerprint, fingerprintIQ);
            fingerprintIQ.removeAttribute("fingerprint");
            transportIQ.addChildExtension(fingerprintIQ);
        }
        return fingerprintIQ;
    }

    public static void deserializeFingerprints(JSONArray fingerprints, IceUdpTransportPacketExtension transportIQ) {
        if (fingerprints != null && !fingerprints.isEmpty()) {
            for (Object fingerprint : fingerprints) {
                JSONDeserializer.deserializeFingerprint((JSONObject)fingerprint, transportIQ);
            }
        }
    }

    public static void deserializeParameters(JSONObject parameters, PayloadTypePacketExtension payloadTypeIQ) {
        if (parameters != null) {
            for (Map.Entry e : parameters.entrySet()) {
                Object name = e.getKey();
                Object value = e.getValue();
                if (name instanceof String && name.equals("null")) {
                    name = null;
                }
                if (name == null && value == null) continue;
                payloadTypeIQ.addParameter(new ParameterPacketExtension(Objects.toString(name, null), Objects.toString(value, null)));
            }
        }
    }

    public static void deserializeRtcpFbs(JSONArray rtcpFbs, PayloadTypePacketExtension payloadTypeIQ) {
        if (rtcpFbs != null) {
            for (Object iter : rtcpFbs) {
                JSONObject rtcpFb = (JSONObject)iter;
                String type = (String)rtcpFb.get((Object)"type");
                String subtype = (String)rtcpFb.get((Object)"subtype");
                if (type == null) continue;
                RtcpFbPacketExtension ext = new RtcpFbPacketExtension();
                ext.setFeedbackType(type);
                if (subtype != null) {
                    ext.setFeedbackSubtype(subtype);
                }
                payloadTypeIQ.addRtcpFeedbackType(ext);
            }
        }
    }

    public static RTPHdrExtPacketExtension deserializeHeaderExtension(JSONObject headerExtension) {
        RTPHdrExtPacketExtension headerExtensionIQ;
        if (headerExtension == null) {
            headerExtensionIQ = null;
        } else {
            URI uri;
            Long id = (Long)headerExtension.get((Object)"id");
            String uriString = (String)headerExtension.get((Object)"uri");
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                uri = null;
            }
            if (uri != null) {
                headerExtensionIQ = new RTPHdrExtPacketExtension();
                headerExtensionIQ.setID(String.valueOf(id));
                headerExtensionIQ.setURI(uri);
            } else {
                headerExtensionIQ = null;
            }
        }
        return headerExtensionIQ;
    }

    public static Collection<RTPHdrExtPacketExtension> deserializeHeaderExtensions(JSONArray headerExtensions) {
        ArrayList<RTPHdrExtPacketExtension> headerExtensionIQs = new ArrayList<RTPHdrExtPacketExtension>();
        for (Object headerExtension : headerExtensions) {
            RTPHdrExtPacketExtension headerExtensionIQ = JSONDeserializer.deserializeHeaderExtension((JSONObject)headerExtension);
            if (headerExtensionIQ == null) continue;
            headerExtensionIQs.add(headerExtensionIQ);
        }
        return headerExtensionIQs;
    }

    public static PayloadTypePacketExtension deserializePayloadType(JSONObject payloadType) {
        PayloadTypePacketExtension payloadTypeIQ;
        if (payloadType == null) {
            payloadTypeIQ = null;
        } else {
            Object rtcpFbs;
            Object parameters = payloadType.get((Object)"parameters");
            payloadTypeIQ = new PayloadTypePacketExtension();
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(payloadType, payloadTypeIQ);
            if (parameters != null) {
                JSONDeserializer.deserializeParameters((JSONObject)parameters, payloadTypeIQ);
            }
            if ((rtcpFbs = payloadType.get((Object)"rtcp-fbs")) instanceof JSONArray) {
                JSONDeserializer.deserializeRtcpFbs((JSONArray)rtcpFbs, payloadTypeIQ);
            }
        }
        return payloadTypeIQ;
    }

    public static Collection<PayloadTypePacketExtension> deserializePayloadTypes(JSONArray payloadTypes) {
        ArrayList<PayloadTypePacketExtension> payloadTypeIQs = new ArrayList<PayloadTypePacketExtension>();
        for (Object payloadType : payloadTypes) {
            payloadTypeIQs.add(JSONDeserializer.deserializePayloadType((JSONObject)payloadType));
        }
        return payloadTypeIQs;
    }

    public static SourcePacketExtension deserializeSource(Object source) {
        SourcePacketExtension sourceIQ;
        if (source == null) {
            sourceIQ = null;
        } else if (source instanceof Number || source instanceof String) {
            long ssrc;
            try {
                ssrc = JSONDeserializer.deserializeSSRC(source);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            sourceIQ = new SourcePacketExtension();
            sourceIQ.setSSRC(ssrc);
        } else if (source instanceof JSONObject) {
            long ssrc;
            JSONObject sourceJSONObject = (JSONObject)source;
            Object ssrcAttr = sourceJSONObject.get((Object)"ssrc");
            try {
                ssrc = JSONDeserializer.deserializeSSRC(ssrcAttr);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            sourceIQ = new SourcePacketExtension();
            sourceIQ.setSSRC(ssrc);
            Object name = sourceJSONObject.get((Object)"name");
            Object videoType = sourceJSONObject.get((Object)"videoType");
            Object rid = sourceJSONObject.get((Object)"rid");
            Object parameters = sourceJSONObject.get((Object)"parameters");
            if (name instanceof String) {
                sourceIQ.setName((String)name);
            }
            if (videoType instanceof String) {
                sourceIQ.setVideoType((String)videoType);
            }
            if (rid instanceof String) {
                sourceIQ.setRid((String)rid);
            }
            if (parameters instanceof JSONObject) {
                for (Map.Entry e : ((JSONObject)parameters).entrySet()) {
                    Object paramName = e.getKey();
                    Object paramValue = e.getValue();
                    if (paramName == null && paramValue == null) continue;
                    sourceIQ.addParameter(new ParameterPacketExtension(Objects.toString(paramName, null), Objects.toString(paramValue, null)));
                }
            }
        } else {
            sourceIQ = null;
        }
        return sourceIQ;
    }

    public static SourceGroupPacketExtension deserializeSourceGroup(Object sourceGroup) {
        SourceGroupPacketExtension sourceGroupIQ;
        if (!(sourceGroup instanceof JSONObject)) {
            sourceGroupIQ = null;
        } else {
            JSONObject sourceGroupJSONObject = (JSONObject)sourceGroup;
            Object semantics = sourceGroupJSONObject.get((Object)"semantics");
            if (semantics instanceof String && ((String)semantics).length() != 0) {
                Object sourcesObject = sourceGroupJSONObject.get((Object)"sources");
                if (sourcesObject instanceof JSONArray && ((JSONArray)sourcesObject).size() != 0) {
                    JSONArray sourcesJSONArray = (JSONArray)sourcesObject;
                    ArrayList<SourcePacketExtension> sourcePacketExtensions = new ArrayList<SourcePacketExtension>();
                    for (Object source : sourcesJSONArray) {
                        SourcePacketExtension sourcePacketExtension = JSONDeserializer.deserializeSource(source);
                        if (sourcePacketExtension == null) continue;
                        sourcePacketExtensions.add(sourcePacketExtension);
                    }
                    sourceGroupIQ = new SourceGroupPacketExtension();
                    sourceGroupIQ.setSemantics(Objects.toString(semantics));
                    sourceGroupIQ.addSources(sourcePacketExtensions);
                } else {
                    sourceGroupIQ = null;
                }
            } else {
                sourceGroupIQ = null;
            }
        }
        return sourceGroupIQ;
    }

    public static int deserializeSSRC(Object o) throws NumberFormatException {
        int i = 0;
        if (o != null) {
            String s;
            i = o instanceof Number ? ((Number)o).intValue() : ((s = o.toString()).startsWith("-") ? Integer.parseInt(s) : (int)Long.parseLong(s));
        }
        return i;
    }

    public static IceUdpTransportPacketExtension deserializeTransport(JSONObject transport) {
        IceUdpTransportPacketExtension transportIQ;
        if (transport == null) {
            transportIQ = null;
        } else {
            Object xmlns = transport.get((Object)"xmlns");
            Object fingerprints = transport.get((Object)"fingerprints");
            Object candidateList = transport.get((Object)"candidates");
            Object webSocketList = transport.get((Object)"web-sockets");
            Object remoteCandidate = transport.get((Object)"remote-candidate");
            Object rtcpMux = transport.get((Object)"rtcp-mux");
            transportIQ = "urn:xmpp:jingle:transports:ice-udp:1".equals(xmlns) ? new IceUdpTransportPacketExtension() : null;
            if (transportIQ != null) {
                JSONDeserializer.deserializeAbstractPacketExtensionAttributes(transport, transportIQ);
                transportIQ.removeAttribute("xmlns");
                transportIQ.removeAttribute("rtcp-mux");
                if (fingerprints != null) {
                    JSONDeserializer.deserializeFingerprints((JSONArray)fingerprints, transportIQ);
                }
                if (candidateList != null) {
                    JSONDeserializer.deserializeCandidates((JSONArray)candidateList, transportIQ);
                }
                if (webSocketList != null) {
                    JSONDeserializer.deserializeWebsockets((JSONArray)webSocketList, transportIQ);
                }
                if (remoteCandidate != null) {
                    JSONDeserializer.deserializeCandidate((JSONObject)remoteCandidate, RemoteCandidatePacketExtension.class, transportIQ);
                }
                if (rtcpMux != null && JSONDeserializer.objectToBoolean(rtcpMux).booleanValue()) {
                    transportIQ.addChildExtension(new IceRtcpmuxPacketExtension());
                }
            }
        }
        return transportIQ;
    }

    private JSONDeserializer() {
    }
}

