/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.provider;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProvider;

public class GeoLocationProvider
extends ExtensionElementProvider<GeoLocation> {
    public static final GeoLocationProvider INSTANCE = new GeoLocationProvider();

    /*
     * Enabled aggressive block sorting
     */
    public GeoLocation parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException.SmackTextParseException, SmackParsingException.SmackUriSyntaxParsingException {
        GeoLocation.Builder builder = GeoLocation.builder();
        while (true) {
            XmlPullParser.Event event = parser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "accuracy": {
                            builder.setAccuracy(ParserUtils.getDoubleFromNextText((XmlPullParser)parser));
                            break block0;
                        }
                        case "alt": {
                            builder.setAlt(ParserUtils.getDoubleFromNextText((XmlPullParser)parser));
                            break block0;
                        }
                        case "altaccuracy": {
                            builder.setAltAccuracy(ParserUtils.getDoubleFromNextText((XmlPullParser)parser));
                            break block0;
                        }
                        case "area": {
                            builder.setArea(parser.nextText());
                            break block0;
                        }
                        case "bearing": {
                            builder.setBearing(ParserUtils.getDoubleFromNextText((XmlPullParser)parser));
                            break block0;
                        }
                        case "building": {
                            builder.setBuilding(parser.nextText());
                            break block0;
                        }
                        case "country": {
                            builder.setCountry(parser.nextText());
                            break block0;
                        }
                        case "countrycode": {
                            builder.setCountryCode(parser.nextText());
                            break block0;
                        }
                        case "datum": {
                            builder.setDatum(parser.nextText());
                            break block0;
                        }
                        case "description": {
                            builder.setDescription(parser.nextText());
                            break block0;
                        }
                        case "error": {
                            GeoLocationProvider.parseError(builder, parser);
                            break block0;
                        }
                        case "floor": {
                            builder.setFloor(parser.nextText());
                            break block0;
                        }
                        case "lat": {
                            builder.setLat(ParserUtils.getDoubleFromNextText((XmlPullParser)parser));
                            break block0;
                        }
                        case "locality": {
                            builder.setLocality(parser.nextText());
                            break block0;
                        }
                        case "lon": {
                            builder.setLon(ParserUtils.getDoubleFromNextText((XmlPullParser)parser));
                            break block0;
                        }
                        case "postalcode": {
                            builder.setPostalcode(parser.nextText());
                            break block0;
                        }
                        case "region": {
                            builder.setRegion(parser.nextText());
                            break block0;
                        }
                        case "room": {
                            builder.setRoom(parser.nextText());
                            break block0;
                        }
                        case "speed": {
                            builder.setSpeed(ParserUtils.getDoubleFromNextText((XmlPullParser)parser));
                            break block0;
                        }
                        case "street": {
                            builder.setStreet(parser.nextText());
                            break block0;
                        }
                        case "text": {
                            builder.setText(parser.nextText());
                            break block0;
                        }
                        case "timestamp": {
                            builder.setTimestamp(ParserUtils.getDateFromNextText((XmlPullParser)parser));
                            break block0;
                        }
                        case "tzo": {
                            builder.setTzo(parser.nextText());
                            break block0;
                        }
                        case "uri": {
                            builder.setUri(ParserUtils.getUriFromNextText((XmlPullParser)parser));
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return builder.build();
                }
            }
        }
    }

    private static void parseError(GeoLocation.Builder builder, XmlPullParser parser) throws XmlPullParserException, IOException {
        double error = ParserUtils.getDoubleFromNextText((XmlPullParser)parser);
        builder.setError(error);
    }

    public static class GeoLocationFormFieldChildElementProvider
    extends FormFieldChildElementProvider<GeoLocation> {
        public static final GeoLocationFormFieldChildElementProvider INSTANCE = new GeoLocationFormFieldChildElementProvider();

        @Override
        public QName getQName() {
            return GeoLocation.QNAME;
        }

        public GeoLocation parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
            return INSTANCE.parse(parser, initialDepth, xmlEnvironment);
        }
    }
}

