/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.BridgeMetrics;
import org.jitsi.jicofo.bridge.UtilKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.utils.stats.RateTracker;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 X2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001XB\u0019\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010I\u001a\u00020JJ\u0006\u0010K\u001a\u00020JJ\u0006\u0010L\u001a\u00020JJ\u000e\u0010M\u001a\u00020J2\u0006\u0010N\u001a\u000205J\u000e\u0010O\u001a\u00020J2\u0006\u0010N\u001a\u00020GJ\r\u0010P\u001a\u00020JH\u0000\u00a2\u0006\u0002\bQJ\u0010\u0010R\u001a\u00020J2\b\u0010S\u001a\u0004\u0018\u00010TJ\b\u0010U\u001a\u00020\u001dH\u0016J\r\u0010V\u001a\u00020JH\u0000\u00a2\u0006\u0002\bWR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010!\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\u001e\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0019R\u001a\u0010#\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010%R&\u0010&\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0019\"\u0004\b'\u0010%R\u0011\u0010(\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0019R\u001e\u0010)\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0016\u0010,\u001a\n -*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\n -*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010/\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u000bR\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\"\u00108\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001fR\"\u0010:\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u001fR\u0010\u0010<\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010=\u001a\u00020>\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0011\u0010A\u001a\u00020B8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0010\u0010E\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lorg/jitsi/jicofo/bridge/Bridge;", "", "jid", "Lorg/jxmpp/jid/Jid;", "clock", "Ljava/time/Clock;", "(Lorg/jxmpp/jid/Jid;Ljava/time/Clock;)V", "averageParticipantStress", "", "correctedStress", "getCorrectedStress", "()D", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "endpointRestartRequestRate", "Lorg/jitsi/utils/stats/RateTracker;", "endpoints", "Ljava/util/concurrent/atomic/AtomicInteger;", "getEndpoints", "()Ljava/util/concurrent/atomic/AtomicInteger;", "failingIce", "", "getFailingIce", "()Z", "failureInstant", "Ljava/time/Instant;", "fullVersion", "", "getFullVersion", "()Ljava/lang/String;", "<set-?>", "isDraining", "isHealthy", "isInGracefulShutdown", "setInGracefulShutdown", "(Z)V", "isOperational", "setOperational", "isOverloaded", "isShuttingDown", "getJid", "()Lorg/jxmpp/jid/Jid;", "lastIceFailed", "kotlin.jvm.PlatformType", "lastPresenceReceived", "lastReportedStressLevel", "getLastReportedStressLevel", "logger", "Lorg/jitsi/utils/logging2/Logger;", "newEndpointsRate", "recentlyAddedEndpointCount", "", "getRecentlyAddedEndpointCount", "()J", "region", "getRegion", "relayId", "getRelayId", "releaseId", "removed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getRemoved", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "timeSinceLastPresence", "Ljava/time/Duration;", "getTimeSinceLastPresence", "()Ljava/time/Duration;", "version", "compareTo", "", "other", "endpointAdded", "", "endpointRemoved", "endpointRequestedRestart", "endpointsMoved", "count", "endpointsRemoved", "markRemoved", "markRemoved$jicofo_selector", "setStats", "stats", "Lorg/jitsi/xmpp/extensions/colibri/ColibriStatsExtension;", "toString", "updateMetrics", "updateMetrics$jicofo_selector", "Companion", "jicofo-selector"})
@SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
public final class Bridge
implements Comparable<Bridge> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Jid jid;
    @NotNull
    private final Clock clock;
    @NotNull
    private final RateTracker newEndpointsRate;
    @NotNull
    private final RateTracker endpointRestartRequestRate;
    @NotNull
    private final AtomicInteger endpoints;
    private double lastReportedStressLevel;
    @Nullable
    private String version;
    private boolean isHealthy;
    @Nullable
    private String releaseId;
    private volatile boolean isOperational;
    private double averageParticipantStress;
    private boolean isInGracefulShutdown;
    private boolean isShuttingDown;
    private boolean isDraining;
    @Nullable
    private Instant failureInstant;
    @Nullable
    private String region;
    @Nullable
    private String relayId;
    @NotNull
    private final AtomicBoolean removed;
    private Instant lastIceFailed;
    @NotNull
    private final Logger logger;
    private Instant lastPresenceReceived;

    @JvmOverloads
    public Bridge(@NotNull Jid jid, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.jid = jid;
        this.clock = clock;
        Duration duration = BridgeConfig.config.getParticipantRampupInterval();
        Duration duration2 = Duration.ofMillis(100L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        this.newEndpointsRate = new RateTracker(duration, duration2, this.clock);
        Duration duration3 = BridgeConfig.config.getIceFailureDetection().getInterval();
        Duration duration4 = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(...)");
        this.endpointRestartRequestRate = new RateTracker(duration3, duration4, this.clock);
        this.endpoints = new AtomicInteger(0);
        this.isHealthy = true;
        this.isOperational = true;
        this.averageParticipantStress = BridgeConfig.config.getAverageParticipantStress();
        this.isDraining = true;
        this.removed = new AtomicBoolean(false);
        this.lastIceFailed = Instant.MIN;
        this.logger = (Logger)new LoggerImpl(Bridge.class.getName());
        this.logger.addContext("jid", this.jid.toString());
        this.lastPresenceReceived = Instant.MIN;
    }

    public /* synthetic */ Bridge(Jid jid, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(jid, clock);
    }

    @NotNull
    public final Jid getJid() {
        return this.jid;
    }

    @NotNull
    public final AtomicInteger getEndpoints() {
        return this.endpoints;
    }

    public final double getLastReportedStressLevel() {
        return this.lastReportedStressLevel;
    }

    public final boolean isHealthy() {
        return this.isHealthy;
    }

    public final boolean isOperational() {
        return this.failureInstant != null && Duration.between(this.failureInstant, this.clock.instant()).compareTo(BridgeConfig.config.getFailureResetThreshold()) < 0 ? false : this.isOperational;
    }

    public final void setOperational(boolean isOperational) {
        this.isOperational = isOperational;
        if (!isOperational) {
            this.failureInstant = this.clock.instant();
        }
    }

    public final boolean isInGracefulShutdown() {
        return this.isInGracefulShutdown;
    }

    public final void setInGracefulShutdown(boolean bl) {
        this.isInGracefulShutdown = bl;
    }

    public final boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public final boolean isDraining() {
        return this.isDraining;
    }

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    @Nullable
    public final String getRelayId() {
        return this.relayId;
    }

    @NotNull
    public final AtomicBoolean getRemoved() {
        return this.removed;
    }

    private final boolean getFailingIce() {
        return Duration.between(this.lastIceFailed, this.clock.instant()).compareTo(BridgeConfig.config.getIceFailureDetection().getTimeout()) < 0;
    }

    @NotNull
    public final Duration getTimeSinceLastPresence() {
        Duration duration = Duration.between(this.lastPresenceReceived, this.clock.instant());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return duration;
    }

    public final void setStats(@Nullable ColibriStatsExtension stats) {
        String healthy;
        String relayId;
        String region;
        String newReleaseId;
        String newVersion;
        String drainStr;
        Double averageParticipantStress;
        if (stats == null) {
            return;
        }
        this.lastPresenceReceived = this.clock.instant();
        Double stressLevel = UtilKt.getDouble(stats, "stress_level");
        if (stressLevel != null) {
            this.lastReportedStressLevel = stressLevel;
        }
        if ((averageParticipantStress = UtilKt.getDouble(stats, "average_participant_stress")) != null) {
            this.averageParticipantStress = averageParticipantStress;
        }
        if (Boolean.parseBoolean(stats.getValueAsString("graceful_shutdown"))) {
            this.isInGracefulShutdown = true;
        }
        if (Boolean.parseBoolean(stats.getValueAsString("shutting_down"))) {
            this.isShuttingDown = true;
        }
        if ((drainStr = stats.getValueAsString("drain")) != null) {
            this.isDraining = Boolean.parseBoolean(drainStr);
        }
        if ((newVersion = stats.getValueAsString("version")) != null) {
            this.version = newVersion;
        }
        if ((newReleaseId = stats.getValueAsString("release")) != null) {
            this.releaseId = newReleaseId;
        }
        if ((region = stats.getValueAsString("region")) != null) {
            this.region = region;
        }
        if ((relayId = stats.getValueAsString("relay_id")) != null) {
            this.relayId = relayId;
        }
        if ((healthy = stats.getValueAsString("healthy")) != null) {
            this.isHealthy = Boolean.parseBoolean(healthy);
        } else if (BridgeConfig.config.getUsePresenceForHealth()) {
            this.logger.warn((Object)"Presence-based health checks are enabled, but presence did not include health status. Health checks for this bridge are effectively disabled.");
        }
    }

    @Override
    public int compareTo(@NotNull Bridge other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.compare(this, other);
    }

    public final void endpointAdded() {
        RateTracker.update$default((RateTracker)this.newEndpointsRate, (long)1L, (long)0L, (int)2, null);
        this.endpoints.incrementAndGet();
        if (!this.removed.get()) {
            BridgeMetrics.Companion.getEndpoints().set((long)this.endpoints.get(), CollectionsKt.listOf((Object)this.jid.getResourceOrEmpty().toString()));
        }
    }

    public final void endpointsMoved(long count) {
        BridgeMetrics.Companion.getEndpointsMoved().add(count, CollectionsKt.listOf((Object)this.jid.getResourceOrEmpty().toString()));
    }

    public final void endpointRemoved() {
        this.endpointsRemoved(1);
    }

    public final void endpointsRemoved(int count) {
        this.endpoints.addAndGet(-count);
        if (!this.removed.get()) {
            BridgeMetrics.Companion.getEndpoints().set((long)this.endpoints.get(), CollectionsKt.listOf((Object)this.jid.getResourceOrEmpty().toString()));
        }
        if (this.endpoints.get() < 0) {
            this.logger.error((Object)"Removed more endpoints than were allocated. Resetting to 0.", new Throwable());
            this.endpoints.set(0);
        }
    }

    public final void markRemoved$jicofo_selector() {
        if (this.removed.compareAndSet(false, true)) {
            BridgeMetrics.Companion.getRestartRequestsMetric().remove(CollectionsKt.listOf((Object)this.jid.getResourceOrEmpty().toString()));
            BridgeMetrics.Companion.getEndpoints().remove(CollectionsKt.listOf((Object)this.jid.getResourceOrEmpty().toString()));
            BridgeMetrics.Companion.getFailingIce().remove(CollectionsKt.listOf((Object)this.jid.getResourceOrEmpty().toString()));
            BridgeMetrics.Companion.getEndpointsMoved().remove(CollectionsKt.listOf((Object)this.jid.getResourceOrEmpty().toString()));
        }
    }

    public final void updateMetrics$jicofo_selector() {
        if (!this.removed.get()) {
            BridgeMetrics.Companion.getFailingIce().set(this.getFailingIce(), CollectionsKt.listOf((Object)this.jid.getResourceOrEmpty().toString()));
        }
    }

    public final void endpointRequestedRestart() {
        RateTracker.update$default((RateTracker)this.endpointRestartRequestRate, (long)1L, (long)0L, (int)2, null);
        if (!this.removed.get()) {
            BridgeMetrics.Companion.getRestartRequestsMetric().inc(CollectionsKt.listOf((Object)this.jid.getResourceOrEmpty().toString()));
        }
        if (BridgeConfig.config.getIceFailureDetection().getEnabled()) {
            long restartCount = RateTracker.getAccumulatedCount$default((RateTracker)this.endpointRestartRequestRate, (long)0L, (int)1, null);
            int endpoints = this.endpoints.get();
            if (endpoints >= BridgeConfig.config.getIceFailureDetection().getMinEndpoints() && (double)restartCount > (double)endpoints * BridgeConfig.config.getIceFailureDetection().getThreshold()) {
                if (!this.getFailingIce()) {
                    this.logger.info((Object)"Detected an ICE failing state.");
                }
                this.lastIceFailed = this.clock.instant();
            }
        }
    }

    private final long getRecentlyAddedEndpointCount() {
        return RateTracker.getAccumulatedCount$default((RateTracker)this.newEndpointsRate, (long)0L, (int)1, null);
    }

    @Nullable
    public final String getFullVersion() {
        return this.version != null && this.releaseId != null ? this.version + "-" + this.releaseId : this.version;
    }

    @NotNull
    public String toString() {
        String string = "Bridge[jid=%s, version=%s, relayId=%s, region=%s, correctedStress=%.2f]";
        Object[] objectArray = new Object[]{this.jid.toString(), this.getFullVersion(), this.relayId, this.region, this.getCorrectedStress()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    public final double getCorrectedStress() {
        double s = this.lastReportedStressLevel + (double)RangesKt.coerceAtLeast((long)this.getRecentlyAddedEndpointCount(), (long)0L) * this.averageParticipantStress;
        return this.getFailingIce() ? Math.max(s, BridgeConfig.config.getStressThreshold() + 0.01) : s;
    }

    public final boolean isOverloaded() {
        return this.getCorrectedStress() >= BridgeConfig.config.getStressThreshold();
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)$this$_get_debugState__u24lambda_u240).put("corrected-stress", this.getCorrectedStress());
        ((Map)$this$_get_debugState__u24lambda_u240).put("drain", this.isDraining);
        ((Map)$this$_get_debugState__u24lambda_u240).put("endpoints", this.endpoints.get());
        ((Map)$this$_get_debugState__u24lambda_u240).put("endpoint-restart-requests", RateTracker.getAccumulatedCount$default((RateTracker)this.endpointRestartRequestRate, (long)0L, (int)1, null));
        ((Map)$this$_get_debugState__u24lambda_u240).put("failing-ice", this.getFailingIce());
        ((Map)$this$_get_debugState__u24lambda_u240).put("graceful-shutdown", this.isInGracefulShutdown);
        ((Map)$this$_get_debugState__u24lambda_u240).put("healthy", this.isHealthy);
        ((Map)$this$_get_debugState__u24lambda_u240).put("operational", this.isOperational());
        ((Map)$this$_get_debugState__u24lambda_u240).put("overloaded", this.isOverloaded());
        ((Map)$this$_get_debugState__u24lambda_u240).put("region", String.valueOf(this.region));
        ((Map)$this$_get_debugState__u24lambda_u240).put("relay-id", String.valueOf(this.relayId));
        ((Map)$this$_get_debugState__u24lambda_u240).put("release", String.valueOf(this.releaseId));
        ((Map)$this$_get_debugState__u24lambda_u240).put("shutting-down", this.isShuttingDown);
        ((Map)$this$_get_debugState__u24lambda_u240).put("stress", this.lastReportedStressLevel);
        ((Map)$this$_get_debugState__u24lambda_u240).put("version", String.valueOf(this.version));
        return orderedJsonObject;
    }

    @JvmOverloads
    public Bridge(@NotNull Jid jid) {
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        this(jid, null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lorg/jitsi/jicofo/bridge/Bridge$Companion;", "", "()V", "compare", "", "b1", "Lorg/jitsi/jicofo/bridge/Bridge;", "b2", "getPriority", "b", "jicofo-selector"})
    public static final class Companion {
        private Companion() {
        }

        public final int compare(@NotNull Bridge b1, @NotNull Bridge b2) {
            Intrinsics.checkNotNullParameter((Object)b1, (String)"b1");
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b2");
            int myPriority = this.getPriority(b1);
            int otherPriority = this.getPriority(b2);
            return myPriority != otherPriority ? myPriority - otherPriority : Double.compare(b1.getCorrectedStress(), b2.getCorrectedStress());
        }

        private final int getPriority(Bridge b) {
            return b.isOperational() ? (b.isInGracefulShutdown() ? 2 : 1) : 3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

