/*
 * Decompiled with CFR 0.152.
 */
package com.agafua.syslog;

import com.agafua.syslog.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;

class TcpSender
implements Runnable {
    private static final int FAILURE_TIMEOUT = 5000;
    private final String hostName;
    private final int port;
    private final Thread worker;
    private final BlockingQueue<Message> blockingQueue;

    public TcpSender(String hostName, int port, BlockingQueue<Message> blockingQueue) {
        this.hostName = hostName;
        this.port = port;
        this.worker = new Thread(new Worker());
        this.blockingQueue = blockingQueue;
    }

    @Override
    public void run() {
        this.worker.start();
    }

    private class Worker
    implements Runnable {
        private Socket socket;
        private OutputStream os;

        private Worker() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (this.os == null) {
                            this.socket = new Socket(TcpSender.this.hostName, TcpSender.this.port);
                            this.os = this.socket.getOutputStream();
                        }
                        Message message = (Message)TcpSender.this.blockingQueue.take();
                        this.os.write(message.getBytes(), 0, message.getLength());
                        this.os.write(10);
                    }
                }
                catch (InterruptedException e) {
                    this.releaseResources();
                    return;
                }
                catch (IOException e) {
                    this.releaseResources();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
                catch (Throwable t) {
                    this.releaseResources();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
            }
        }

        private void releaseResources() {
            try {
                if (this.os != null) {
                    this.os.flush();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.os = null;
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.socket = null;
        }
    }
}

