/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console;

import free.jin.I18n;
import free.jin.Preferences;
import free.jin.console.Command;
import free.jin.console.Console;
import free.jin.console.Link;
import free.util.GraphicsUtilities;
import free.util.PlatformUtils;
import free.workarounds.FixedJTextPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Utilities;

public class ConsoleTextPane
extends FixedJTextPane {
    protected final Console console;
    protected JPopupMenu defaultPopupMenu = null;
    private Vector links = new Vector();
    private Cursor regCursor = Cursor.getDefaultCursor();
    private Link curLink = null;
    private Hashtable renderingHints = null;
    private static boolean renderingHintsSupported = true;
    private Class g2Class;
    private Class rhClass;
    private Class rhKeyClass;
    private Class[] argumentTypes;
    private Method setRenderingHint;
    private static final boolean SHOULD_USE_16_BIT_GRAPHICS_HACK = !PlatformUtils.isJavaBetterThan((String)"1.2") && (PlatformUtils.isOldWindows() || PlatformUtils.isSolaris());
    private int clickCount = 0;
    private long lastReleaseTime;

    public ConsoleTextPane(Console console) {
        this.console = console;
        this.setEditable(false);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (!toolTipManager.isEnabled()) {
            toolTipManager.setEnabled(true);
        }
        toolTipManager.registerComponent((JComponent)((Object)this));
        DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
        Keymap keymap = this.getKeymap();
        keymap.removeBindings();
        keymap.setResolveParent(null);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(65485, 0), copyAction);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), copyAction);
        this.enableEvents(48L);
    }

    public void refreshFromProperties() {
        this.defaultPopupMenu = null;
        this.renderingHints = null;
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        String string;
        if (this.renderingHints == null) {
            this.renderingHints = new Hashtable(10, 0.1f);
            boolean bl = this.console.getPrefs().getBool("output-text.antialias", false);
            string = "VALUE_TEXT_ANTIALIAS_" + (bl ? "ON" : "OFF");
            this.renderingHints.put("KEY_TEXT_ANTIALIASING", string);
        }
        if (renderingHintsSupported && !this.renderingHints.isEmpty()) {
            try {
                if (this.g2Class == null) {
                    this.g2Class = Class.forName("java.awt.Graphics2D");
                    this.rhClass = Class.forName("java.awt.RenderingHints");
                    this.rhKeyClass = Class.forName("java.awt.RenderingHints$Key");
                    this.argumentTypes = new Class[]{this.rhKeyClass, Object.class};
                    this.setRenderingHint = this.g2Class.getMethod("setRenderingHint", this.argumentTypes);
                }
                Enumeration enumeration = this.renderingHints.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    String string2 = (String)this.renderingHints.get(string);
                    Object object = this.rhClass.getField(string).get(null);
                    Object object2 = this.rhClass.getField(string2).get(null);
                    Object[] objectArray = new Object[]{object, object2};
                    this.setRenderingHint.invoke((Object)graphics, objectArray);
                }
            }
            catch (Exception exception) {
                System.err.println("Failed to set rendering hints. Probably not running under a Java2D capable JVM.");
                renderingHintsSupported = false;
            }
        }
        super.paintComponent(graphics);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n4 > Short.MAX_VALUE && SHOULD_USE_16_BIT_GRAPHICS_HACK) {
            Object object;
            try {
                object = this.getDocument();
                while (this.getPreferredSize().height >= Short.MAX_VALUE) {
                    int n5;
                    int n6 = object.getLength();
                    String string = object.getText(0, Math.min(200, n6));
                    while ((n5 = string.indexOf(10)) == -1) {
                        string = object.getText(0, Math.min(string.length() * 2, n6));
                    }
                    object.remove(0, n5 + 1);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            object = this.getParent();
            if (object != null) {
                ((Container)object).invalidate();
                ((Container)object).validate();
                ((Container)object).doLayout();
            }
        } else {
            super.reshape(n, n2, n3, n4);
        }
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        if (!this.isEditable() && this.getKeymap().getAction(KeyStroke.getKeyStrokeForEvent(keyEvent)) == null) {
            keyEvent.consume();
            return;
        }
        super.processComponentKeyEvent(keyEvent);
    }

    protected JPopupMenu getPopupMenu(MouseEvent mouseEvent) {
        String string = this.getSelectedText();
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        if (string == null || string.length() == 0 || !this.isOverText(mouseEvent.getX(), mouseEvent.getY(), n, n2)) {
            int n3 = this.viewToModel(mouseEvent.getPoint());
            if (n3 == -1) {
                return null;
            }
            try {
                int n4 = this.getWordStart(n3);
                int n5 = this.getWordEnd(n3);
                if (this.isOverText(mouseEvent.getX(), mouseEvent.getY(), n4, n5)) {
                    string = this.getDocument().getText(n4, n5 - n4);
                    if (string.trim().length() != 0) {
                        this.select(n4, n5);
                    }
                    string = this.getSelectedText();
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return null;
            }
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.defaultPopupMenu == null) {
            this.defaultPopupMenu = this.createPopupMenu();
        }
        return this.defaultPopupMenu;
    }

    protected JPopupMenu createPopupMenu() {
        Preferences preferences = this.console.getPrefs();
        I18n i18n = this.console.getConsoleManager().getI18n();
        String string = "consolePopup.";
        int n = preferences.getInt(string + "itemCount", 0);
        if (n == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = string + i + ".";
            String string4 = preferences.getString(string3 + "type", "serverCommand");
            String string5 = preferences.getString(string3 + "labelKey", null);
            String string6 = string2 = string5 == null ? null : i18n.getString(string5);
            if ("serverCommand".equals(string4)) {
                String string7 = preferences.getString(string3 + "command");
                jPopupMenu.add(new IssueCommandMenuItem(string2, string7));
                continue;
            }
            if ("separator".equals(string4)) {
                jPopupMenu.addSeparator();
                continue;
            }
            if ("copy".equals(string4)) {
                jPopupMenu.add(new CopyMenuItem(string2));
                continue;
            }
            if ("execute".equals(string4)) {
                jPopupMenu.add(new ExecuteMenuItem(string2));
                continue;
            }
            if ("expurgate".equals(string4)) {
                jPopupMenu.add(new ExpurgateMenuItem(string2));
                continue;
            }
            throw new IllegalStateException("Unknown console popup item type: " + string4);
        }
        jPopupMenu.setSize(jPopupMenu.getPreferredSize());
        return jPopupMenu;
    }

    private int getWordStart(int n) throws BadLocationException {
        boolean bl;
        int n2;
        Element element;
        int n3;
        Document document = this.getDocument();
        String string = document.getText(n3 = (element = Utilities.getParagraphElement((JTextComponent)((Object)this), n)).getStartOffset(), (n2 = Math.min(element.getEndOffset(), document.getLength())) - n3);
        if (string == null || string.length() == 0) {
            return n;
        }
        char c = string.charAt(n -= n3);
        if (this.isWhitespaceChar(c)) {
            bl = true;
        } else if (this.isWordChar(c)) {
            bl = false;
        } else {
            return n + n3;
        }
        for (int i = n; i >= 0; --i) {
            char c2 = string.charAt(i);
            if ((!bl || this.isWhitespaceChar(c2)) && (bl || this.isWordChar(c2))) continue;
            return n3 + i + 1;
        }
        return n3;
    }

    private int getWordEnd(int n) throws BadLocationException {
        boolean bl;
        int n2;
        Element element;
        int n3;
        Document document = this.getDocument();
        String string = document.getText(n3 = (element = Utilities.getParagraphElement((JTextComponent)((Object)this), n)).getStartOffset(), (n2 = Math.min(element.getEndOffset(), document.getLength())) - n3);
        if (string == null || string.length() == 0) {
            return n;
        }
        int n4 = string.length();
        char c = string.charAt(n -= n3);
        if (this.isWhitespaceChar(c)) {
            bl = true;
        } else if (this.isWordChar(c)) {
            bl = false;
        } else {
            return n + n3 + 1;
        }
        for (int i = n; i < n4; ++i) {
            char c2 = string.charAt(i);
            if ((!bl || this.isWhitespaceChar(c2)) && (bl || this.isWordChar(c2))) continue;
            return n3 + i;
        }
        return n2;
    }

    protected boolean isWordChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c);
    }

    protected boolean isWhitespaceChar(char c) {
        return Character.isWhitespace(c);
    }

    protected void expurgateSelection() {
        boolean bl;
        String string = this.getSelectedText();
        boolean bl2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(bl2 ? 1 : 0);
        for (bl = false; bl < bl2; bl += 1) {
            char c = string.charAt(bl ? 1 : 0);
            if (Character.isWhitespace(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('*');
        }
        bl = this.isEditable();
        this.setEditable(true);
        this.replaceSelection(stringBuffer.toString());
        this.setEditable(bl);
    }

    public void addLink(Link link) {
        this.links.addElement(link);
    }

    public void removeLinks() {
        this.links.removeAllElements();
    }

    private void updateClickCount(MouseEvent mouseEvent) {
        if (PlatformUtils.isOldMicrosoftVM()) {
            switch (mouseEvent.getID()) {
                case 503: 
                case 504: 
                case 505: 
                case 506: {
                    this.clickCount = 0;
                    break;
                }
                case 501: {
                    if (mouseEvent.getWhen() - this.lastReleaseTime < 500L) {
                        ++this.clickCount;
                        break;
                    }
                    this.clickCount = 1;
                    break;
                }
                case 502: {
                    this.lastReleaseTime = mouseEvent.getWhen();
                }
            }
        }
    }

    private int getClickCount(MouseEvent mouseEvent) {
        return PlatformUtils.isOldMicrosoftVM() ? this.clickCount : mouseEvent.getClickCount();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu;
        int n;
        this.updateClickCount(mouseEvent);
        if (mouseEvent.getClickCount() < 2) {
            super.processMouseEvent(mouseEvent);
        }
        if ((n = this.viewToModel(mouseEvent.getPoint())) != -1) {
            try {
                if (this.getClickCount(mouseEvent) >= 2 && mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (this.getClickCount(mouseEvent) % 2 == 0) {
                        int n2 = this.getWordStart(n);
                        int n3 = this.getWordEnd(n);
                        this.select(n2, n3);
                    } else {
                        Document document = this.getDocument();
                        Element element = Utilities.getParagraphElement((JTextComponent)((Object)this), n);
                        int n4 = element.getStartOffset();
                        int n5 = Math.min(element.getEndOffset(), document.getLength());
                        this.select(n4, n5);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (mouseEvent.isPopupTrigger() && (jPopupMenu = this.getPopupMenu(mouseEvent)) != null) {
            JRootPane jRootPane = SwingUtilities.getRootPane((Component)((Object)this));
            Dimension dimension = jRootPane.getSize();
            Point point = SwingUtilities.convertPoint((Component)((Object)this), mouseEvent.getPoint(), jRootPane);
            int n6 = mouseEvent.getX();
            int n7 = mouseEvent.getY();
            int n8 = jPopupMenu.getWidth();
            int n9 = jPopupMenu.getHeight();
            n6 = point.x + n8 + 1 > dimension.width ? n6 - n8 - 1 : ++n6;
            n7 = point.y + n9 - 5 > dimension.height ? n7 - n9 + 5 : (n7 -= 5);
            jPopupMenu.setSelected(null);
            jPopupMenu.show((Component)((Object)this), n6, n7);
        }
        if (mouseEvent.getID() == 505) {
            this.curLink = null;
            this.setCursor(this.regCursor);
        }
        if (mouseEvent.getID() == 502) {
            this.processPossibleLinkUpdate(mouseEvent);
        }
        if (mouseEvent.getID() == 500 && SwingUtilities.isLeftMouseButton(mouseEvent) && this.curLink != null) {
            this.console.issueCommand(this.curLink.getCommand());
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.updateClickCount(mouseEvent);
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.getID() == 503) {
            this.processPossibleLinkUpdate(mouseEvent);
        }
    }

    private void processPossibleLinkUpdate(MouseEvent mouseEvent) {
        Link link = this.getLink(mouseEvent.getX(), mouseEvent.getY());
        if (link == null) {
            if (this.curLink != null) {
                this.curLink = null;
                this.setCursor(this.regCursor, false);
            }
        } else if (!link.equals(this.curLink)) {
            this.curLink = link;
            this.setCursor(Cursor.getPredefinedCursor(12), false);
        }
    }

    protected Link getLink(int n, int n2) {
        int n3 = this.links.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            Link link = (Link)this.links.elementAt(i);
            int n5 = link.getStartPosition().getOffset();
            if (!this.isOverText(n, n2, n5, n4 = link.getEndPosition().getOffset())) continue;
            return link;
        }
        return null;
    }

    protected boolean isOverText(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Rectangle rectangle2;
        try {
            rectangle2 = this.modelToView(n3);
            rectangle = this.modelToView(n4);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return false;
        }
        if (rectangle2 == null || rectangle == null) {
            return false;
        }
        if (rectangle2.y + rectangle2.height <= rectangle.y) {
            if (n2 > rectangle2.y) {
                if (n2 <= rectangle2.y + rectangle2.height) {
                    if (n > rectangle2.x) {
                        try {
                            int n5 = Utilities.getRowEnd((JTextComponent)((Object)this), n3);
                            if (n5 == -1) {
                                return false;
                            }
                            Rectangle rectangle3 = this.modelToView(n5);
                            if (n <= rectangle3.x + rectangle3.width) {
                                return true;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                            return false;
                        }
                    }
                } else {
                    if (n2 < rectangle.y) {
                        return true;
                    }
                    if (n2 < rectangle.y + rectangle.height && n < rectangle.x + rectangle.width) {
                        return true;
                    }
                }
            }
            if (n2 > rectangle2.y + rectangle2.height && n2 < rectangle.y) {
                return true;
            }
        } else if (rectangle2.union(rectangle).contains(n, n2)) {
            return true;
        }
        return false;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Command command;
        Link link = this.getLink(mouseEvent.getX(), mouseEvent.getY());
        if (link != null && !(command = link.getCommand()).isSpecial()) {
            String string = command.getCommandString();
            try {
                int n = link.getStartPosition().getOffset();
                int n2 = link.getEndPosition().getOffset() - n;
                String string2 = this.getText(n, n2);
                if (string2.equals(string)) {
                    return null;
                }
                return string;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setCursor(Cursor cursor) {
        this.setCursor(cursor, true);
    }

    private void setCursor(Cursor cursor, boolean bl) {
        super.setCursor(cursor);
        if (bl) {
            this.regCursor = cursor;
        }
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return super.getScrollableBlockIncrement(rectangle, n, n2);
        }
        int n3 = rectangle.height - 3 * this.getScrollableUnitIncrement(rectangle, n, n2);
        return n3 <= 0 ? rectangle.height : n3;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return super.getScrollableUnitIncrement(rectangle, n, n2);
        }
        FontMetrics fontMetrics = GraphicsUtilities.getFontMetrics((Font)this.getFont());
        return fontMetrics.getHeight();
    }

    protected class ExpurgateMenuItem
    extends JMenuItem {
        public ExpurgateMenuItem(String string) {
            super(string);
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            ConsoleTextPane.this.expurgateSelection();
        }
    }

    protected class ExecuteMenuItem
    extends JMenuItem {
        public ExecuteMenuItem(String string) {
            super(string);
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            ConsoleTextPane.this.console.issueCommand(new Command(ConsoleTextPane.this.getSelectedText(), 0L));
        }
    }

    protected class CopyMenuItem
    extends JMenuItem {
        public CopyMenuItem(String string) {
            super(string);
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            ConsoleTextPane.this.copy();
        }
    }

    protected class IssueCommandMenuItem
    extends JMenuItem {
        private final String serverCommand;

        public IssueCommandMenuItem(String string, String string2) {
            super(string);
            this.serverCommand = string2;
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            ConsoleTextPane.this.console.issueCommand(new Command(this.serverCommand + " " + ConsoleTextPane.this.getSelectedText(), 0L));
        }
    }
}

