/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.kafka.trogdor.coordinator.Coordinator;
import org.apache.kafka.trogdor.rest.CoordinatorShutdownRequest;
import org.apache.kafka.trogdor.rest.CoordinatorStatusResponse;
import org.apache.kafka.trogdor.rest.CreateTaskRequest;
import org.apache.kafka.trogdor.rest.CreateTaskResponse;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.StopTaskRequest;
import org.apache.kafka.trogdor.rest.StopTaskResponse;
import org.apache.kafka.trogdor.rest.TasksResponse;

@Path(value="/coordinator")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CoordinatorRestResource {
    private final AtomicReference<Coordinator> coordinator = new AtomicReference();
    @Context
    private ServletContext context;

    public void setCoordinator(Coordinator myCoordinator) {
        this.coordinator.set(myCoordinator);
    }

    @GET
    @Path(value="/status")
    public CoordinatorStatusResponse status() throws Throwable {
        return this.coordinator().status();
    }

    @POST
    @Path(value="/task/create")
    public CreateTaskResponse createTask(CreateTaskRequest request) throws Throwable {
        return this.coordinator().createTask(request);
    }

    @PUT
    @Path(value="/task/stop")
    public StopTaskResponse stopTask(StopTaskRequest request) throws Throwable {
        return this.coordinator().stopTask(request);
    }

    @GET
    @Path(value="/tasks")
    public TasksResponse tasks() throws Throwable {
        return this.coordinator().tasks();
    }

    @PUT
    @Path(value="/shutdown")
    public Empty beginShutdown(CoordinatorShutdownRequest request) throws Throwable {
        this.coordinator().beginShutdown(request.stopAgents());
        return Empty.INSTANCE;
    }

    private Coordinator coordinator() {
        Coordinator myCoordinator = this.coordinator.get();
        if (myCoordinator == null) {
            throw new RuntimeException("CoordinatorRestResource has not been initialized yet.");
        }
        return myCoordinator;
    }
}

