/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.apache.kafka.connect.util.TopicAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfigBackingStore
implements ConfigBackingStore {
    private static final Logger log = LoggerFactory.getLogger(KafkaConfigBackingStore.class);
    public static final String TARGET_STATE_PREFIX = "target-state-";
    public static final String CONNECTOR_PREFIX = "connector-";
    public static final String TASK_PREFIX = "task-";
    public static final String COMMIT_TASKS_PREFIX = "commit-";
    public static final Schema CONNECTOR_CONFIGURATION_V0;
    public static final Schema TASK_CONFIGURATION_V0;
    public static final Schema CONNECTOR_TASKS_COMMIT_V0;
    public static final Schema TARGET_STATE_V0;
    private static final long READ_TO_END_TIMEOUT_MS = 30000L;
    private final Object lock;
    private final Converter converter;
    private volatile boolean started = false;
    private ConfigBackingStore.UpdateListener updateListener;
    private final String topic;
    private final KafkaBasedLog<String, byte[]> configLog;
    private final Map<String, Integer> connectorTaskCounts = new HashMap<String, Integer>();
    private final Map<String, Map<String, String>> connectorConfigs = new HashMap<String, Map<String, String>>();
    private final Map<ConnectorTaskId, Map<String, String>> taskConfigs = new HashMap<ConnectorTaskId, Map<String, String>>();
    private final Set<String> inconsistent = new HashSet<String>();
    private volatile long offset;
    private final Map<String, Map<ConnectorTaskId, Map<String, String>>> deferredTaskUpdates = new HashMap<String, Map<ConnectorTaskId, Map<String, String>>>();
    private final Map<String, TargetState> connectorTargetStates = new HashMap<String, TargetState>();

    public static String TARGET_STATE_KEY(String connectorName) {
        return TARGET_STATE_PREFIX + connectorName;
    }

    public static String CONNECTOR_KEY(String connectorName) {
        return CONNECTOR_PREFIX + connectorName;
    }

    public static String TASK_KEY(ConnectorTaskId taskId) {
        return TASK_PREFIX + taskId.connector() + "-" + taskId.task();
    }

    public static String COMMIT_TASKS_KEY(String connectorName) {
        return COMMIT_TASKS_PREFIX + connectorName;
    }

    public KafkaConfigBackingStore(Converter converter, WorkerConfig config) {
        this.lock = new Object();
        this.converter = converter;
        this.offset = -1L;
        this.topic = config.getString("config.storage.topic");
        if (this.topic.equals("")) {
            throw new ConfigException("Must specify topic for connector configuration.");
        }
        this.configLog = this.setupAndCreateKafkaBasedLog(this.topic, config);
    }

    @Override
    public void setUpdateListener(ConfigBackingStore.UpdateListener listener) {
        this.updateListener = listener;
    }

    @Override
    public void start() {
        log.info("Starting KafkaConfigBackingStore");
        this.configLog.start();
        this.started = true;
        log.info("Started KafkaConfigBackingStore");
    }

    @Override
    public void stop() {
        log.info("Closing KafkaConfigBackingStore");
        this.configLog.stop();
        log.info("Closed KafkaConfigBackingStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterConfigState snapshot() {
        Object object = this.lock;
        synchronized (object) {
            return new ClusterConfigState(this.offset, new HashMap<String, Integer>(this.connectorTaskCounts), new HashMap<String, Map<String, String>>(this.connectorConfigs), new HashMap<String, TargetState>(this.connectorTargetStates), new HashMap<ConnectorTaskId, Map<String, String>>(this.taskConfigs), new HashSet<String>(this.inconsistent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String connector) {
        Object object = this.lock;
        synchronized (object) {
            return this.connectorConfigs.containsKey(connector);
        }
    }

    @Override
    public void putConnectorConfig(String connector, Map<String, String> properties) {
        log.debug("Writing connector configuration {} for connector {} configuration", properties, (Object)connector);
        Struct connectConfig = new Struct(CONNECTOR_CONFIGURATION_V0);
        connectConfig.put("properties", properties);
        byte[] serializedConfig = this.converter.fromConnectData(this.topic, CONNECTOR_CONFIGURATION_V0, (Object)connectConfig);
        this.updateConnectorConfig(connector, serializedConfig);
    }

    @Override
    public void removeConnectorConfig(String connector) {
        log.debug("Removing connector configuration for connector {}", (Object)connector);
        try {
            this.configLog.send(KafkaConfigBackingStore.CONNECTOR_KEY(connector), null);
            this.configLog.send(KafkaConfigBackingStore.TARGET_STATE_KEY(connector), null);
            this.configLog.readToEnd().get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to remove connector configuration from Kafka: ", (Throwable)e);
            throw new ConnectException("Error removing connector configuration from Kafka", (Throwable)e);
        }
    }

    @Override
    public void removeTaskConfigs(String connector) {
        throw new UnsupportedOperationException("Removal of tasks is not currently supported");
    }

    private void updateConnectorConfig(String connector, byte[] serializedConfig) {
        try {
            this.configLog.send(KafkaConfigBackingStore.CONNECTOR_KEY(connector), serializedConfig);
            this.configLog.readToEnd().get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write connector configuration to Kafka: ", (Throwable)e);
            throw new ConnectException("Error writing connector configuration to Kafka", (Throwable)e);
        }
    }

    @Override
    public void putTaskConfigs(String connector, List<Map<String, String>> configs) {
        try {
            this.configLog.readToEnd().get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write root configuration to Kafka: ", (Throwable)e);
            throw new ConnectException("Error writing root configuration to Kafka", (Throwable)e);
        }
        int taskCount = configs.size();
        int index = 0;
        for (Map<String, String> taskConfig : configs) {
            Struct connectConfig = new Struct(TASK_CONFIGURATION_V0);
            connectConfig.put("properties", taskConfig);
            byte[] serializedConfig = this.converter.fromConnectData(this.topic, TASK_CONFIGURATION_V0, (Object)connectConfig);
            log.debug("Writing configuration for task " + index + " configuration: " + taskConfig);
            ConnectorTaskId connectorTaskId = new ConnectorTaskId(connector, index);
            this.configLog.send(KafkaConfigBackingStore.TASK_KEY(connectorTaskId), serializedConfig);
            ++index;
        }
        try {
            if (taskCount > 0) {
                this.configLog.readToEnd().get(30000L, TimeUnit.MILLISECONDS);
            }
            Struct connectConfig = new Struct(CONNECTOR_TASKS_COMMIT_V0);
            connectConfig.put("tasks", (Object)taskCount);
            byte[] serializedConfig = this.converter.fromConnectData(this.topic, CONNECTOR_TASKS_COMMIT_V0, (Object)connectConfig);
            log.debug("Writing commit for connector " + connector + " with " + taskCount + " tasks.");
            this.configLog.send(KafkaConfigBackingStore.COMMIT_TASKS_KEY(connector), serializedConfig);
            this.configLog.readToEnd().get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write root configuration to Kafka: ", (Throwable)e);
            throw new ConnectException("Error writing root configuration to Kafka", (Throwable)e);
        }
    }

    @Override
    public void refresh(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            this.configLog.readToEnd().get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ConnectException("Error trying to read to end of config log", (Throwable)e);
        }
    }

    @Override
    public void putTargetState(String connector, TargetState state) {
        Struct connectTargetState = new Struct(TARGET_STATE_V0);
        connectTargetState.put("state", (Object)state.name());
        byte[] serializedTargetState = this.converter.fromConnectData(this.topic, TARGET_STATE_V0, (Object)connectTargetState);
        log.debug("Writing target state {} for connector {}", (Object)state, (Object)connector);
        this.configLog.send(KafkaConfigBackingStore.TARGET_STATE_KEY(connector), serializedTargetState);
    }

    KafkaBasedLog<String, byte[]> setupAndCreateKafkaBasedLog(String topic, WorkerConfig config) {
        HashMap<String, Object> producerProps = new HashMap<String, Object>();
        producerProps.putAll(config.originals());
        producerProps.put("key.serializer", StringSerializer.class.getName());
        producerProps.put("value.serializer", ByteArraySerializer.class.getName());
        producerProps.put("retries", Integer.MAX_VALUE);
        HashMap<String, Object> consumerProps = new HashMap<String, Object>();
        consumerProps.putAll(config.originals());
        consumerProps.put("key.deserializer", StringDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        HashMap<String, Object> adminProps = new HashMap<String, Object>(config.originals());
        NewTopic topicDescription = TopicAdmin.defineTopic(topic).compacted().partitions(1).replicationFactor(config.getShort("config.storage.replication.factor")).build();
        return this.createKafkaBasedLog(topic, producerProps, consumerProps, new ConsumeCallback(), topicDescription, adminProps);
    }

    private KafkaBasedLog<String, byte[]> createKafkaBasedLog(String topic, Map<String, Object> producerProps, Map<String, Object> consumerProps, Callback<ConsumerRecord<String, byte[]>> consumedCallback, final NewTopic topicDescription, final Map<String, Object> adminProps) {
        Runnable createTopics = new Runnable(){

            @Override
            public void run() {
                log.debug("Creating admin client to manage Connect internal config topic");
                try (TopicAdmin admin = new TopicAdmin(adminProps);){
                    admin.createTopics(topicDescription);
                }
            }
        };
        return new KafkaBasedLog<String, byte[]>(topic, producerProps, consumerProps, consumedCallback, Time.SYSTEM, createTopics);
    }

    private ConnectorTaskId parseTaskId(String key) {
        String[] parts = key.split("-");
        if (parts.length < 3) {
            return null;
        }
        try {
            int taskNum = Integer.parseInt(parts[parts.length - 1]);
            String connectorName = Utils.join((Object[])Arrays.copyOfRange(parts, 1, parts.length - 1), (String)"-");
            return new ConnectorTaskId(connectorName, taskNum);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Set<Integer> taskIds(String connector, Map<ConnectorTaskId, Map<String, String>> configs) {
        TreeSet<Integer> tasks = new TreeSet<Integer>();
        if (configs == null) {
            return tasks;
        }
        for (ConnectorTaskId taskId : configs.keySet()) {
            assert (taskId.connector().equals(connector));
            tasks.add(taskId.task());
        }
        return tasks;
    }

    private boolean completeTaskIdSet(Set<Integer> idSet, int expectedSize) {
        if (idSet.size() < expectedSize) {
            return false;
        }
        for (int i = 0; i < expectedSize; ++i) {
            if (idSet.contains(i)) continue;
            return false;
        }
        return true;
    }

    private static int intValue(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return (int)((Long)value).longValue();
        }
        throw new ConnectException("Expected integer value to be either Integer or Long");
    }

    static {
        TASK_CONFIGURATION_V0 = CONNECTOR_CONFIGURATION_V0 = SchemaBuilder.struct().field("properties", SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.OPTIONAL_STRING_SCHEMA).build()).build();
        CONNECTOR_TASKS_COMMIT_V0 = SchemaBuilder.struct().field("tasks", Schema.INT32_SCHEMA).build();
        TARGET_STATE_V0 = SchemaBuilder.struct().field("state", Schema.STRING_SCHEMA).build();
    }

    private class ConsumeCallback
    implements Callback<ConsumerRecord<String, byte[]>> {
        private ConsumeCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(Throwable error, ConsumerRecord<String, byte[]> record) {
            SchemaAndValue value;
            if (error != null) {
                log.error("Unexpected in consumer callback for KafkaConfigBackingStore: ", error);
                return;
            }
            try {
                value = KafkaConfigBackingStore.this.converter.toConnectData(KafkaConfigBackingStore.this.topic, (byte[])record.value());
            }
            catch (DataException e) {
                log.error("Failed to convert config data to Kafka Connect format: ", (Throwable)e);
                return;
            }
            KafkaConfigBackingStore.this.offset = record.offset() + 1L;
            if (((String)record.key()).startsWith(KafkaConfigBackingStore.TARGET_STATE_PREFIX)) {
                String connectorName = ((String)record.key()).substring(KafkaConfigBackingStore.TARGET_STATE_PREFIX.length());
                boolean removed = false;
                Object object = KafkaConfigBackingStore.this.lock;
                synchronized (object) {
                    if (value.value() == null) {
                        log.debug("Removed target state for connector {} due to null value in topic.", (Object)connectorName);
                        KafkaConfigBackingStore.this.connectorTargetStates.remove(connectorName);
                        removed = true;
                        if (KafkaConfigBackingStore.this.connectorConfigs.containsKey(connectorName)) {
                            KafkaConfigBackingStore.this.connectorTargetStates.put(connectorName, TargetState.STARTED);
                        }
                    } else {
                        if (!(value.value() instanceof Map)) {
                            log.error("Found target state ({}) in wrong format: {}", record.key(), value.value().getClass());
                            return;
                        }
                        Object targetState = ((Map)value.value()).get("state");
                        if (!(targetState instanceof String)) {
                            log.error("Invalid data for target state for connector ({}): 'state' field should be a Map but is {}", (Object)connectorName, targetState == null ? null : targetState.getClass());
                            return;
                        }
                        try {
                            TargetState state = TargetState.valueOf((String)targetState);
                            log.debug("Setting target state for connector {} to {}", (Object)connectorName, targetState);
                            KafkaConfigBackingStore.this.connectorTargetStates.put(connectorName, state);
                        }
                        catch (IllegalArgumentException e) {
                            log.error("Invalid target state for connector ({}): {}", (Object)connectorName, targetState);
                            return;
                        }
                    }
                }
                if (KafkaConfigBackingStore.this.started && !removed) {
                    KafkaConfigBackingStore.this.updateListener.onConnectorTargetStateChange(connectorName);
                }
            } else if (((String)record.key()).startsWith(KafkaConfigBackingStore.CONNECTOR_PREFIX)) {
                String connectorName = ((String)record.key()).substring(KafkaConfigBackingStore.CONNECTOR_PREFIX.length());
                boolean removed = false;
                Object object = KafkaConfigBackingStore.this.lock;
                synchronized (object) {
                    if (value.value() == null) {
                        log.info("Removed connector " + connectorName + " due to null configuration. This is usually intentional and does not indicate an issue.");
                        KafkaConfigBackingStore.this.connectorConfigs.remove(connectorName);
                        removed = true;
                    } else {
                        if (!(value.value() instanceof Map)) {
                            log.error("Found connector configuration (" + (String)record.key() + ") in wrong format: " + value.value().getClass());
                            return;
                        }
                        Object newConnectorConfig = ((Map)value.value()).get("properties");
                        if (!(newConnectorConfig instanceof Map)) {
                            log.error("Invalid data for connector config ({}): properties field should be a Map but is {}", (Object)connectorName, newConnectorConfig == null ? null : newConnectorConfig.getClass());
                            return;
                        }
                        log.debug("Updating configuration for connector " + connectorName + " configuration: " + newConnectorConfig);
                        KafkaConfigBackingStore.this.connectorConfigs.put(connectorName, (Map)newConnectorConfig);
                        if (!KafkaConfigBackingStore.this.connectorTargetStates.containsKey(connectorName)) {
                            KafkaConfigBackingStore.this.connectorTargetStates.put(connectorName, TargetState.STARTED);
                        }
                    }
                }
                if (KafkaConfigBackingStore.this.started) {
                    if (removed) {
                        KafkaConfigBackingStore.this.updateListener.onConnectorConfigRemove(connectorName);
                    } else {
                        KafkaConfigBackingStore.this.updateListener.onConnectorConfigUpdate(connectorName);
                    }
                }
            } else {
                if (((String)record.key()).startsWith(KafkaConfigBackingStore.TASK_PREFIX)) {
                    Object connectorName = KafkaConfigBackingStore.this.lock;
                    synchronized (connectorName) {
                        ConnectorTaskId taskId = KafkaConfigBackingStore.this.parseTaskId((String)record.key());
                        if (taskId == null) {
                            log.error("Ignoring task configuration because " + (String)record.key() + " couldn't be parsed as a task config key");
                            return;
                        }
                        if (!(value.value() instanceof Map)) {
                            log.error("Ignoring task configuration for task " + taskId + " because it is in the wrong format: " + value.value());
                            return;
                        }
                        Object newTaskConfig = ((Map)value.value()).get("properties");
                        if (!(newTaskConfig instanceof Map)) {
                            log.error("Invalid data for task config (" + taskId + "): properties filed should be a Map but is " + newTaskConfig.getClass());
                            return;
                        }
                        HashMap<ConnectorTaskId, Map> deferred = (HashMap<ConnectorTaskId, Map>)KafkaConfigBackingStore.this.deferredTaskUpdates.get(taskId.connector());
                        if (deferred == null) {
                            deferred = new HashMap<ConnectorTaskId, Map>();
                            KafkaConfigBackingStore.this.deferredTaskUpdates.put(taskId.connector(), deferred);
                        }
                        log.debug("Storing new config for task " + taskId + " this will wait for a commit message before the new config will take effect. New config: " + newTaskConfig);
                        deferred.put(taskId, (Map)newTaskConfig);
                    }
                }
                if (((String)record.key()).startsWith(KafkaConfigBackingStore.COMMIT_TASKS_PREFIX)) {
                    String connectorName = ((String)record.key()).substring(KafkaConfigBackingStore.COMMIT_TASKS_PREFIX.length());
                    ArrayList<ConnectorTaskId> updatedTasks = new ArrayList<ConnectorTaskId>();
                    Object object = KafkaConfigBackingStore.this.lock;
                    synchronized (object) {
                        if (!(value.value() instanceof Map)) {
                            log.error("Ignoring connector tasks configuration commit for connector " + connectorName + " because it is in the wrong format: " + value.value());
                            return;
                        }
                        Map deferred = (Map)KafkaConfigBackingStore.this.deferredTaskUpdates.get(connectorName);
                        int newTaskCount = KafkaConfigBackingStore.intValue(((Map)value.value()).get("tasks"));
                        Set taskIdSet = KafkaConfigBackingStore.this.taskIds(connectorName, deferred);
                        if (!KafkaConfigBackingStore.this.completeTaskIdSet(taskIdSet, newTaskCount)) {
                            log.debug("We have an incomplete set of task configs for connector " + connectorName + " probably due to compaction. So we are not doing anything with the new configuration.");
                            KafkaConfigBackingStore.this.inconsistent.add(connectorName);
                        } else {
                            if (deferred != null) {
                                KafkaConfigBackingStore.this.taskConfigs.putAll(deferred);
                                updatedTasks.addAll(KafkaConfigBackingStore.this.taskConfigs.keySet());
                            }
                            KafkaConfigBackingStore.this.inconsistent.remove(connectorName);
                        }
                        if (deferred != null) {
                            deferred.clear();
                        }
                        KafkaConfigBackingStore.this.connectorTaskCounts.put(connectorName, newTaskCount);
                    }
                    if (KafkaConfigBackingStore.this.started) {
                        KafkaConfigBackingStore.this.updateListener.onTaskConfigUpdate(updatedTasks);
                    }
                } else {
                    log.error("Discarding config update record with invalid key: " + (String)record.key());
                }
            }
        }
    }
}

