/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.AdminClientIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001\u001d\u0011a%\u00113nS:\u001cE.[3oi^KG\u000f\u001b)pY&\u001c\u0017.Z:J]R,wM]1uS>tG+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011QB\u0003\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!9!\u0004\u0001a\u0001\n\u0003Y\u0012AB2mS\u0016tG/F\u0001\u001d!\tir%D\u0001\u001f\u0015\ty\u0002%A\u0003bI6LgN\u0003\u0002\"E\u000591\r\\5f]R\u001c(BA\u0003$\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\n\u0005!r\"aC!e[&t7\t\\5f]RDqA\u000b\u0001A\u0002\u0013\u00051&\u0001\u0006dY&,g\u000e^0%KF$\"\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\tUs\u0017\u000e\u001e\u0005\bg%\n\t\u00111\u0001\u001d\u0003\rAH%\r\u0005\u0007k\u0001\u0001\u000b\u0015\u0002\u000f\u0002\u000f\rd\u0017.\u001a8uA!9q\u0007\u0001b\u0001\n\u0003A\u0014a\u00032s_.,'oQ8v]R,\u0012!\u000f\t\u0003[iJ!a\u000f\u0018\u0003\u0007%sG\u000f\u0003\u0004>\u0001\u0001\u0006I!O\u0001\rEJ|7.\u001a:D_VtG\u000f\t\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u000eO2|'-\u00197US6,w.\u001e;\u0016\u0003\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u000bI,H.Z:\u000b\u0005\u0019+\u0013!\u00026v]&$\u0018B\u0001%D\u0005\u001d!\u0016.\\3pkRD#A\u0010&\u0011\u0005-cU\"A#\n\u00055+%\u0001\u0002*vY\u0016DQa\u0014\u0001\u0005BA\u000bQa]3u+B$\u0012\u0001\f\u0015\u0003\u001dJ\u0003\"aS*\n\u0005Q+%A\u0002\"fM>\u0014X\rC\u0003W\u0001\u0011\u0005\u0003+\u0001\u0005uK\u0006\u0014Hi\\<oQ\t)\u0006\f\u0005\u0002L3&\u0011!,\u0012\u0002\u0006\u0003\u001a$XM\u001d\u0005\u00069\u0002!\t!X\u0001\rGJ,\u0017\r^3D_:4\u0017nZ\u000b\u0002=B!q\f\u001a4r\u001b\u0005\u0001'BA1c\u0003\u0011)H/\u001b7\u000b\u0003\r\fAA[1wC&\u0011Q\r\u0019\u0002\u0004\u001b\u0006\u0004\bCA4o\u001d\tAG\u000e\u0005\u0002j]5\t!N\u0003\u0002l\r\u00051AH]8pizJ!!\u001c\u0018\u0002\rA\u0013X\rZ3g\u0013\ty\u0007O\u0001\u0004TiJLgn\u001a\u0006\u0003[:\u0002\"A];\u000e\u0003MT!\u0001\u001e2\u0002\t1\fgnZ\u0005\u0003mN\u0014aa\u00142kK\u000e$\b\"\u0002=\u0001\t\u0003J\u0018aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003i\u0004Ra_A\u0001\u0003\u000fq!\u0001 @\u000f\u0005%l\u0018\"A\u0018\n\u0005}t\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\t)AA\u0002TKFT!a \u0018\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004\u0005\u0003\u0019\u0019XM\u001d<fe&!\u0011\u0011CA\u0006\u0005-Y\u0015MZ6b\u0007>tg-[4\t\r\u0005U\u0001\u0001\"\u0001Q\u0003U!Xm\u001d;WC2LG-\u00117uKJ\u001cuN\u001c4jONDC!a\u0005\u0002\u001aA\u00191*a\u0007\n\u0007\u0005uQI\u0001\u0003UKN$\bBBA\u0011\u0001\u0011\u0005\u0001+A\fuKN$\u0018J\u001c<bY&$\u0017\t\u001c;fe\u000e{gNZ5hg\"\"\u0011qDA\r\u0011\u0019\t9\u0003\u0001C\u0001!\u0006\u0011C/Z:u\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d#vKR{\u0007k\u001c7jGfDC!!\n\u0002\u001a\u001d9\u0011Q\u0006\u0002\t\u0002\u0005=\u0012AJ!e[&t7\t\\5f]R<\u0016\u000e\u001e5Q_2L7-[3t\u0013:$Xm\u001a:bi&|g\u000eV3tiB\u0019\u0001$!\r\u0007\r\u0005\u0011\u0001\u0012AA\u001a'\u0019\t\t$!\u000e\u0002<A\u0019Q&a\u000e\n\u0007\u0005ebF\u0001\u0004B]f\u0014VM\u001a\t\u0004[\u0005u\u0012bAA ]\ta1+\u001a:jC2L'0\u00192mK\"9Q#!\r\u0005\u0002\u0005\rCCAA\u0018\r\u001d\t9%!\r\u0001\u0003\u0013\u0012a\u0001U8mS\u000eL8#BA#c\u0006-\u0003\u0003BA'\u0003+j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u0007a>d\u0017nY=\u000b\u0007\u00055!%\u0003\u0003\u0002X\u0005=#!E!mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds\"9Q#!\u0012\u0005\u0002\u0005mCCAA/!\u0011\ty&!\u0012\u000e\u0005\u0005E\u0002\u0002DA2\u0003\u000b\u0002\r\u00111A\u0005\u0002\u0005\u0015\u0014aB2p]\u001aLwm]\u000b\u0003\u0003O\u0002D!!\u001b\u0002rA1q-a\u001bg\u0003[J!!\u001a9\u0011\t\u0005=\u0014\u0011\u000f\u0007\u0001\t1\t\u0019(!\u001e\u0002\u0002\u0003\u0005)\u0011AA=\u0005\ryF%\r\u0005\r\u0003o\n)\u00051A\u0001B\u0003&\u0011qM\u0001\tG>tg-[4tAE!\u00111PAA!\ri\u0013QP\u0005\u0004\u0003\u007fr#a\u0002(pi\"Lgn\u001a\t\u0004[\u0005\r\u0015bAAC]\t\u0019\u0011I\\=\t\u0019\u0005%\u0015Q\ta\u0001\u0002\u0004%\t!a#\u0002\u0017\r|gNZ5hg~#S-\u001d\u000b\u0004Y\u00055\u0005\"C\u001a\u0002\b\u0006\u0005\t\u0019AAHa\u0011\t\t*!&\u0011\r\u001d\fYGZAJ!\u0011\ty'!&\u0005\u0019\u0005M\u0014QRA\u0001\u0002\u0003\u0015\t!!\u001f\t\u0015\u0005e\u0015Q\ta\u0001\n\u0003\tY*\u0001\u0004dY>\u001cX\rZ\u000b\u0003\u0003;\u00032!LAP\u0013\r\t\tK\f\u0002\b\u0005>|G.Z1o\u0011)\t)+!\u0012A\u0002\u0013\u0005\u0011qU\u0001\u000bG2|7/\u001a3`I\u0015\fHc\u0001\u0017\u0002*\"I1'a)\u0002\u0002\u0003\u0007\u0011Q\u0014\u0005\n\u0003[\u000b)\u0005)Q\u0005\u0003;\u000bqa\u00197pg\u0016$\u0007\u0005\u0003\u0005\u00022\u0006\u0015C\u0011AAZ\u0003%\u0019wN\u001c4jOV\u0014X\rF\u0002-\u0003kC\u0001\"a\u0019\u00020\u0002\u0007\u0011q\u0017\u0019\u0005\u0003s\u000bi\fE\u0003`I\u001a\fY\f\u0005\u0003\u0002p\u0005uF\u0001DA`\u0003k\u000b\t\u0011!A\u0003\u0002\u0005e$aA0%e!A\u00111YA#\t\u0003\t)-\u0001\u0005wC2LG-\u0019;f)\ra\u0013q\u0019\u0005\t\u0003\u0013\f\t\r1\u0001\u0002L\u0006y!/Z9vKN$X*\u001a;bI\u0006$\u0018\r\u0005\u0003\u0002N\u0006Mg\u0002BA'\u0003\u001fLA!!5\u0002P\u0005\t\u0012\t\u001c;fe\u000e{gNZ5h!>d\u0017nY=\n\t\u0005U\u0017q\u001b\u0002\u0010%\u0016\fX/Z:u\u001b\u0016$\u0018\rZ1uC*!\u0011\u0011[A(\u0011\u001d\tY.!\u0012\u0005\u0002A\u000bQa\u00197pg\u0016D!\"a8\u00022\u0005\u0005I\u0011BAq\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003E\u0004")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private AdminClient client = null;
    private final int brokerCount;

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        configs.foreach((Function1 & Serializable & scala.Serializable)props -> props.put(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), Policy.class));
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testValidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testInvalidAlterConfigsDueToPolicy() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, 1, 1, this.createTopic$default$4());
        List topicConfigEntries1 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2")}))).asJava();
        List topicConfigEntries2 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.8")}))).asJava();
        List topicConfigEntries3 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "-1")}))).asJava();
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().head()).config().brokerId())).toString());
        List brokerConfigEntries = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "12313")}))).asJava();
        ObjectRef alterResult = ObjectRef.create((Object)this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava()));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132))).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134))).getCause() instanceof InvalidRequestException));
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135))).getCause() instanceof InvalidRequestException));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assert.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        topicConfigEntries2 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.7")}))).asJava();
        alterResult.elem = this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162))).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164))).getCause() instanceof InvalidRequestException));
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165))).getCause() instanceof InvalidRequestException));
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assert.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, ?> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, ?> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, ?> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            this.configs_$eq(((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(configs).asScala()).toMap(Predef$.MODULE$.$conforms()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable & scala.Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(!this.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(requestMetadata.resource().name())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "resource name should not be empty");
            Predef$.MODULE$.require(requestMetadata.resource().name().contains("topic"));
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

