/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnKey;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u0013\t\u0011BK]1og\u0006\u001cG/[8o\u0019><G+Z:u\u0015\t\u0019A!A\u0006ue\u0006t7/Y2uS>t'BA\u0003\u0007\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BE\u0007\u0002\u0019)\u0011QBD\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001fA\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003E\t1a\u001c:h\u0013\t\u0019BB\u0001\u0006K+:LGoU;ji\u0016DQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00017\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0006'\"|'\u000f\u001e\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA!9Q\u0005\u0001b\u0001\n\u00031\u0013\u0001\u0006;sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5/F\u0001(!\ti\u0002&\u0003\u0002*=\t\u0019\u0011J\u001c;\t\r-\u0002\u0001\u0015!\u0003(\u0003U!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\bu_BL7\rU1si&$\u0018n\u001c8t+\u0005y\u0003c\u0001\u00198u9\u0011\u0011'\u000e\t\u0003eyi\u0011a\r\u0006\u0003i!\ta\u0001\u0010:p_Rt\u0014B\u0001\u001c\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001(\u000f\u0002\u0004'\u0016$(B\u0001\u001c\u001f!\tY\u0014)D\u0001=\u0015\tid(\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f}R!\u0001\u0011\t\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u0011EH\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\u0011\u0003\u0001\u0015!\u00030\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0003G\u0001\u0011\u0005q)A\u0012tQ>,H\u000e\u001a+ie><X\t_2faRLwN\\,sSR,\u0017J\u001c<bY&$G\u000b\u001f8\u0015\u0003!\u0003\"!H%\n\u0005)s\"\u0001B+oSRD#!\u0012'\u0011\u00055{U\"\u0001(\u000b\u00055\u0001\u0012B\u0001)O\u0005\u0011!Vm\u001d;\t\u000bI\u0003A\u0011A$\u0002/MDw.\u001e7e%\u0016\fGm\u0016:ji\u0016lUm]:bO\u0016\u001c\bFA)M\u0001")
public class TransactionLogTest
extends JUnitSuite {
    private final short producerEpoch;
    private final int transactionTimeoutMs;
    private final Set<TopicPartition> topicPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)}));

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void shouldThrowExceptionWriteInvalidTxn() {
        String transactionalId = "transactionalId";
        long producerId = 23423L;
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), 0L);
        txnMetadata.addPartitions(this.topicPartitions());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TransactionLogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    @Test
    public void shouldReadWriteMessages() {
        Map pidMappings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zero"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"one"), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"two"), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"three"), (Object)BoxesRunTime.boxToLong((long)3L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"four"), (Object)BoxesRunTime.boxToLong((long)4L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"five"), (Object)BoxesRunTime.boxToLong((long)5L))}));
        Map transactionStates = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)Empty$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)Ongoing$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)PrepareCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)CompleteCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)4L)), (Object)PrepareAbort$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)5L)), (Object)CompleteAbort$.MODULE$)}));
        Seq txnRecords = ((TraversableOnce)pidMappings.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionMetadata txnMetadata;
            String transactionalId;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long producerId;
                transactionalId = (String)tuple2._1();
                txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId = tuple2._2$mcJ$sp(), this.producerEpoch(), this.transactionTimeoutMs(), (TransactionState)transactionStates.apply((Object)BoxesRunTime.boxToLong((long)producerId)), 0L);
                if (!txnMetadata.state().equals(Empty$.MODULE$)) {
                    txnMetadata.addPartitions(this.topicPartitions());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
            byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
            SimpleRecord simpleRecord = new SimpleRecord(keyBytes, valueBytes);
            return simpleRecord;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])txnRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        IntRef count = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionLogTest.$anonfun$shouldReadWriteMessages$2(this, pidMappings, transactionStates, count, record);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)pidMappings.size(), (long)count.elem);
    }

    public static final /* synthetic */ void $anonfun$shouldReadWriteMessages$2(TransactionLogTest $this, Map pidMappings$1, Map transactionStates$1, IntRef count$1, Record record) {
        TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
        String transactionalId = txnKey.transactionalId();
        TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)pidMappings$1.apply((Object)transactionalId)), (long)txnMetadata.producerId());
        Assert.assertEquals((long)$this.producerEpoch(), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)$this.transactionTimeoutMs(), (long)txnMetadata.txnTimeoutMs());
        Assert.assertEquals((Object)transactionStates$1.apply((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId())), (Object)txnMetadata.state());
        if (txnMetadata.state().equals(Empty$.MODULE$)) {
            Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)txnMetadata.topicPartitions());
        } else {
            Assert.assertEquals($this.topicPartitions(), (Object)txnMetadata.topicPartitions());
        }
        ++count$1.elem;
    }

    public TransactionLogTest() {
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 1000;
    }
}

