require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_SIGINFO_H_)) {
    eval 'sub _SYS_SIGINFO_H_ () {1;}' unless defined(&_SYS_SIGINFO_H_);
    require 'machine/signal.ph';
    require 'sys/featuretest.ph';
    if(defined(&_KERNEL)) {
	require 'sys/queue.ph';
    }
    if(defined(&_LP64)) {
    }
    if(defined(&_KERNEL)) {
	eval 'sub KSI_TRAP () {0x1;}' unless defined(&KSI_TRAP);
	eval 'sub KSI_EMPTY () {0x2;}' unless defined(&KSI_EMPTY);
	eval 'sub KSI_QUEUED () {0x4;}' unless defined(&KSI_QUEUED);
	eval 'sub KSI_FROMPOOL () {0x8;}' unless defined(&KSI_FROMPOOL);
	eval 'sub KSI_INIT {
	    my($ksi) = @_;
    	    eval q( &do {  &memset(($ksi), 0, $sizeof{($ksi)}); }  &while (0));
	}' unless defined(&KSI_INIT);
	eval 'sub KSI_INIT_EMPTY {
	    my($ksi) = @_;
    	    eval q( &do {  &KSI_INIT(($ksi)); ($ksi)-> &ksi_flags =  &KSI_EMPTY; }  &while (0));
	}' unless defined(&KSI_INIT_EMPTY);
	eval 'sub KSI_INIT_TRAP {
	    my($ksi) = @_;
    	    eval q( &do {  &KSI_INIT(($ksi)); ($ksi)-> &ksi_flags =  &KSI_TRAP; }  &while (0));
	}' unless defined(&KSI_INIT_TRAP);
	eval 'sub KSI_COPY {
	    my($fksi, $tksi) = @_;
    	    eval q( &do { ($tksi)-> &ksi_info = ($fksi)-> &ksi_info; ($tksi)-> &ksi_flags = ($fksi)-> &ksi_flags; }  &while (0));
	}' unless defined(&KSI_COPY);
	eval 'sub KSI_TRAP_P {
	    my($ksi) = @_;
    	    eval q(((($ksi)-> &ksi_flags &  &KSI_TRAP) != 0));
	}' unless defined(&KSI_TRAP_P);
	eval 'sub KSI_EMPTY_P {
	    my($ksi) = @_;
    	    eval q(((($ksi)-> &ksi_flags &  &KSI_EMPTY) != 0));
	}' unless defined(&KSI_EMPTY_P);
	eval 'sub KSI_TRAPCODE {
	    my($ksi) = @_;
    	    eval q(( &KSI_TRAP_P($ksi) ? ($ksi)-> &ksi_trap : 0));
	}' unless defined(&KSI_TRAPCODE);
    }
    eval 'sub si_signo () { ($_info->{_signo});}' unless defined(&si_signo);
    eval 'sub si_code () { ($_info->{_code});}' unless defined(&si_code);
    eval 'sub si_errno () { ($_info->{_errno});}' unless defined(&si_errno);
    eval 'sub si_value () { ($_info->{_reason}->{_rt}->{_value});}' unless defined(&si_value);
    eval 'sub si_pid () { ($_info->{_reason}->{_child}->{_pid});}' unless defined(&si_pid);
    eval 'sub si_uid () { ($_info->{_reason}->{_child}->{_uid});}' unless defined(&si_uid);
    eval 'sub si_status () { ($_info->{_reason}->{_child}->{_status});}' unless defined(&si_status);
    eval 'sub si_utime () { ($_info->{_reason}->{_child}->{_utime});}' unless defined(&si_utime);
    eval 'sub si_stime () { ($_info->{_reason}->{_child}->{_stime});}' unless defined(&si_stime);
    eval 'sub si_addr () { ($_info->{_reason}->{_fault}->{_addr});}' unless defined(&si_addr);
    eval 'sub si_trap () { ($_info->{_reason}->{_fault}->{_trap});}' unless defined(&si_trap);
    eval 'sub si_trap2 () { ($_info->{_reason}->{_fault}->{_trap2});}' unless defined(&si_trap2);
    eval 'sub si_trap3 () { ($_info->{_reason}->{_fault}->{_trap3});}' unless defined(&si_trap3);
    eval 'sub si_band () { ($_info->{_reason}->{_poll}->{_band});}' unless defined(&si_band);
    eval 'sub si_fd () { ($_info->{_reason}->{_poll}->{_fd});}' unless defined(&si_fd);
    eval 'sub si_sysnum () { ($_info->{_reason}->{_syscall}->{_sysnum});}' unless defined(&si_sysnum);
    eval 'sub si_retval () { ($_info->{_reason}->{_syscall}->{_retval});}' unless defined(&si_retval);
    eval 'sub si_error () { ($_info->{_reason}->{_syscall}->{_error});}' unless defined(&si_error);
    eval 'sub si_args () { ($_info->{_reason}->{_syscall}->{_args});}' unless defined(&si_args);
    eval 'sub si_pe_report_event () { ($_info->{_reason}->{_ptrace_state}->{_pe_report_event});}' unless defined(&si_pe_report_event);
    eval 'sub si_pe_other_pid () { ($_info->{_reason}->{_ptrace_state}->{_option}->{_pe_other_pid});}' unless defined(&si_pe_other_pid);
    eval 'sub si_pe_lwp () { ($_info->{_reason}->{_ptrace_state}->{_option}->{_pe_lwp});}' unless defined(&si_pe_lwp);
    if(defined(&_KERNEL)) {
	eval 'sub ksi_signo () { ($ksi_info->{_signo});}' unless defined(&ksi_signo);
	eval 'sub ksi_code () { ($ksi_info->{_code});}' unless defined(&ksi_code);
	eval 'sub ksi_errno () { ($ksi_info->{_errno});}' unless defined(&ksi_errno);
	eval 'sub ksi_value () { ($ksi_info->{_reason}->{_rt}->{_value});}' unless defined(&ksi_value);
	eval 'sub ksi_pid () { ($ksi_info->{_reason}->{_child}->{_pid});}' unless defined(&ksi_pid);
	eval 'sub ksi_uid () { ($ksi_info->{_reason}->{_child}->{_uid});}' unless defined(&ksi_uid);
	eval 'sub ksi_status () { ($ksi_info->{_reason}->{_child}->{_status});}' unless defined(&ksi_status);
	eval 'sub ksi_utime () { ($ksi_info->{_reason}->{_child}->{_utime});}' unless defined(&ksi_utime);
	eval 'sub ksi_stime () { ($ksi_info->{_reason}->{_child}->{_stime});}' unless defined(&ksi_stime);
	eval 'sub ksi_addr () { ($ksi_info->{_reason}->{_fault}->{_addr});}' unless defined(&ksi_addr);
	eval 'sub ksi_trap () { ($ksi_info->{_reason}->{_fault}->{_trap});}' unless defined(&ksi_trap);
	eval 'sub ksi_trap2 () { ($ksi_info->{_reason}->{_fault}->{_trap2});}' unless defined(&ksi_trap2);
	eval 'sub ksi_trap3 () { ($ksi_info->{_reason}->{_fault}->{_trap3});}' unless defined(&ksi_trap3);
	eval 'sub ksi_band () { ($ksi_info->{_reason}->{_poll}->{_band});}' unless defined(&ksi_band);
	eval 'sub ksi_fd () { ($ksi_info->{_reason}->{_poll}->{_fd});}' unless defined(&ksi_fd);
	eval 'sub ksi_sysnum () { ($ksi_info->{_reason}->{_syscall}->{_sysnum});}' unless defined(&ksi_sysnum);
	eval 'sub ksi_retval () { ($ksi_info->{_reason}->{_syscall}->{_retval});}' unless defined(&ksi_retval);
	eval 'sub ksi_error () { ($ksi_info->{_reason}->{_syscall}->{_error});}' unless defined(&ksi_error);
	eval 'sub ksi_args () { ($ksi_info->{_reason}->{_syscall}->{_args});}' unless defined(&ksi_args);
	eval 'sub ksi_pe_report_event () { ($ksi_info->{_reason}->{_ptrace_state}->{_pe_report_event});}' unless defined(&ksi_pe_report_event);
	eval 'sub ksi_pe_other_pid () { ($ksi_info->{_reason}->{_ptrace_state}->{_option}->{_pe_other_pid});}' unless defined(&ksi_pe_other_pid);
	eval 'sub ksi_pe_lwp () { ($ksi_info->{_reason}->{_ptrace_state}->{_option}->{_pe_lwp});}' unless defined(&ksi_pe_lwp);
    }
    eval 'sub ILL_ILLOPC () {1;}' unless defined(&ILL_ILLOPC);
    eval 'sub ILL_ILLOPN () {2;}' unless defined(&ILL_ILLOPN);
    eval 'sub ILL_ILLADR () {3;}' unless defined(&ILL_ILLADR);
    eval 'sub ILL_ILLTRP () {4;}' unless defined(&ILL_ILLTRP);
    eval 'sub ILL_PRVOPC () {5;}' unless defined(&ILL_PRVOPC);
    eval 'sub ILL_PRVREG () {6;}' unless defined(&ILL_PRVREG);
    eval 'sub ILL_COPROC () {7;}' unless defined(&ILL_COPROC);
    eval 'sub ILL_BADSTK () {8;}' unless defined(&ILL_BADSTK);
    eval 'sub FPE_INTDIV () {1;}' unless defined(&FPE_INTDIV);
    eval 'sub FPE_INTOVF () {2;}' unless defined(&FPE_INTOVF);
    eval 'sub FPE_FLTDIV () {3;}' unless defined(&FPE_FLTDIV);
    eval 'sub FPE_FLTOVF () {4;}' unless defined(&FPE_FLTOVF);
    eval 'sub FPE_FLTUND () {5;}' unless defined(&FPE_FLTUND);
    eval 'sub FPE_FLTRES () {6;}' unless defined(&FPE_FLTRES);
    eval 'sub FPE_FLTINV () {7;}' unless defined(&FPE_FLTINV);
    eval 'sub FPE_FLTSUB () {8;}' unless defined(&FPE_FLTSUB);
    eval 'sub SEGV_MAPERR () {1;}' unless defined(&SEGV_MAPERR);
    eval 'sub SEGV_ACCERR () {2;}' unless defined(&SEGV_ACCERR);
    eval 'sub BUS_ADRALN () {1;}' unless defined(&BUS_ADRALN);
    eval 'sub BUS_ADRERR () {2;}' unless defined(&BUS_ADRERR);
    eval 'sub BUS_OBJERR () {3;}' unless defined(&BUS_OBJERR);
    eval 'sub TRAP_BRKPT () {1;}' unless defined(&TRAP_BRKPT);
    eval 'sub TRAP_TRACE () {2;}' unless defined(&TRAP_TRACE);
    eval 'sub TRAP_EXEC () {3;}' unless defined(&TRAP_EXEC);
    eval 'sub TRAP_CHLD () {4;}' unless defined(&TRAP_CHLD);
    eval 'sub TRAP_LWP () {5;}' unless defined(&TRAP_LWP);
    eval 'sub TRAP_DBREG () {6;}' unless defined(&TRAP_DBREG);
    eval 'sub TRAP_SCE () {7;}' unless defined(&TRAP_SCE);
    eval 'sub TRAP_SCX () {8;}' unless defined(&TRAP_SCX);
    eval 'sub CLD_EXITED () {1;}' unless defined(&CLD_EXITED);
    eval 'sub CLD_KILLED () {2;}' unless defined(&CLD_KILLED);
    eval 'sub CLD_DUMPED () {3;}' unless defined(&CLD_DUMPED);
    eval 'sub CLD_TRAPPED () {4;}' unless defined(&CLD_TRAPPED);
    eval 'sub CLD_STOPPED () {5;}' unless defined(&CLD_STOPPED);
    eval 'sub CLD_CONTINUED () {6;}' unless defined(&CLD_CONTINUED);
    eval 'sub POLL_IN () {1;}' unless defined(&POLL_IN);
    eval 'sub POLL_OUT () {2;}' unless defined(&POLL_OUT);
    eval 'sub POLL_MSG () {3;}' unless defined(&POLL_MSG);
    eval 'sub POLL_ERR () {4;}' unless defined(&POLL_ERR);
    eval 'sub POLL_PRI () {5;}' unless defined(&POLL_PRI);
    eval 'sub POLL_HUP () {6;}' unless defined(&POLL_HUP);
    eval 'sub SI_USER () {0;}' unless defined(&SI_USER);
    eval 'sub SI_QUEUE () {-1;}' unless defined(&SI_QUEUE);
    eval 'sub SI_TIMER () {-2;}' unless defined(&SI_TIMER);
    eval 'sub SI_ASYNCIO () {-3;}' unless defined(&SI_ASYNCIO);
    eval 'sub SI_MESGQ () {-4;}' unless defined(&SI_MESGQ);
    if(defined(&_KERNEL) || defined(&_NETBSD_SOURCE)) {
	eval 'sub SI_LWP () {-5;}' unless defined(&SI_LWP);
	eval 'sub SI_NOINFO () {32767;}' unless defined(&SI_NOINFO);
    }
}
1;
