/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.parosproxy.paros.view.WaitMessageDialog;

public class MenuFileControl
implements SessionListener {
    private static Log log = LogFactory.getLog(class$org$parosproxy$paros$control$MenuFileControl == null ? (class$org$parosproxy$paros$control$MenuFileControl = MenuFileControl.class$("org.parosproxy.paros.control.MenuFileControl")) : class$org$parosproxy$paros$control$MenuFileControl);
    private View view = null;
    private Model model = null;
    private Control control = null;
    private WaitMessageDialog waitMessageDialog = null;
    static /* synthetic */ Class class$org$parosproxy$paros$control$MenuFileControl;

    public MenuFileControl(Model model, View view, Control control) {
        this.view = view;
        this.model = model;
        this.control = control;
    }

    public void exit() {
        boolean bl = this.model.getSession().isNewState();
        if (bl) {
            if (this.view.showConfirmDialog("The current session is not saved.  Discard?") != 0) {
                return;
            }
            this.model.getSession().discard();
        }
        WaitMessageDialog waitMessageDialog = this.view.getWaitMessageDialog("Shutting down server and database...");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                MenuFileControl.this.control.shutdown(false);
                log.info("Paros 3.2.13 terminated.");
                System.exit(0);
            }
        });
        thread.start();
        waitMessageDialog.setVisible(true);
    }

    public void newSession(boolean bl) throws ClassNotFoundException, Exception {
        if (bl) {
            if (this.model.getSession().isNewState()) {
                if (this.view.showConfirmDialog("The current session is not saved.  Discard and create new session?") != 0) {
                    return;
                }
                this.model.getSession().discard();
            } else if (this.view.showConfirmDialog("The current session will be closed.  Create new session?") != 0) {
                return;
            }
            this.model.createAndOpenUntitledDb();
        }
        Session session = new Session(this.model);
        log.info("new session file created");
        this.model.setSession(session);
        this.view.getSiteTreePanel().getTreeSite().setModel(session.getSiteTree());
        this.control.getExtensionLoader().sessionChangedAllPlugin(session);
        this.view.getMainFrame().setTitle(session.getSessionName() + " - " + "Paros");
        this.view.getOutputPanel().clear();
    }

    public void openSession() {
        JFileChooser jFileChooser = new JFileChooser(this.model.getOptionsParam().getUserDirectory());
        File file = null;
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".session");
            }

            public String getDescription() {
                return "Paros session";
            }
        });
        int n = jFileChooser.showOpenDialog(this.view.getMainFrame());
        if (n == 0) {
            try {
                file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                this.model.getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
                Session session = this.model.getSession();
                log.info("opening session file " + file.getAbsolutePath());
                this.waitMessageDialog = this.view.getWaitMessageDialog("Loading session file.  Please wait ...");
                session.open(file, this);
                this.waitMessageDialog.setVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void saveSession() {
        Session session = this.model.getSession();
        if (session.isNewState()) {
            this.view.showWarningDialog("Please use Save As...");
            return;
        }
        try {
            this.waitMessageDialog = this.view.getWaitMessageDialog("Saving session file.  Please wait ...");
            session.save(session.getFileName(), this);
            log.info("saving session file " + session.getFileName());
            this.waitMessageDialog.setVisible(true);
        }
        catch (Exception exception) {
            this.view.showWarningDialog("Error saving session file.");
            log.error("error saving session file " + session.getFileName());
            log.error(exception.getMessage());
        }
    }

    public void saveAsSession() {
        Session session = this.model.getSession();
        JFileChooser jFileChooser = new JFileChooser(this.model.getOptionsParam().getUserDirectory());
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".session");
            }

            public String getDescription() {
                return "Paros session";
            }
        });
        File file = null;
        int n = jFileChooser.showSaveDialog(this.view.getMainFrame());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            this.model.getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
            String string = file.getAbsolutePath();
            if (!string.endsWith(".session")) {
                string = string + ".session";
            }
            try {
                this.waitMessageDialog = this.view.getWaitMessageDialog("Saving new session file.  Please wait ...");
                session.save(string, this);
                log.info("save as session file " + session.getFileName());
                this.waitMessageDialog.setVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void properties() {
        SessionDialog sessionDialog = this.view.getSessionDialog("Session Properties");
        sessionDialog.initParam(this.model.getSession());
        sessionDialog.showDialog(false);
    }

    public void sessionOpened(File file, Exception exception) {
        if (exception == null) {
            this.control.getExtensionLoader().sessionChangedAllPlugin(this.model.getSession());
            this.view.getMainFrame().setTitle(file.getName().replaceAll(".session\\z", "") + " - " + "Paros");
        } else {
            this.view.showWarningDialog("Error opening session file");
            log.error("error opening session file " + file.getAbsolutePath());
            log.error(exception.getMessage());
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    public void sessionSaved(Exception exception) {
        if (exception == null) {
            this.view.getMainFrame().getMainMenuBar().getMenuFileSave().setEnabled(true);
            File file = new File(this.model.getSession().getFileName());
            this.view.getMainFrame().setTitle(file.getName().replaceAll(".session\\z", "") + " - " + "Paros");
        } else {
            this.view.showWarningDialog("Error saving session file.");
            exception.printStackTrace();
            log.error("error saving session file " + this.model.getSession().getFileName());
            log.error(exception.getStackTrace());
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

