/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.grouping.core.hierarchy;

import com.projectlibre1.association.Association;
import com.projectlibre1.association.AssociationList;
import com.projectlibre1.configuration.Settings;
import com.projectlibre1.grouping.core.LazyParent;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.NodeBridge;
import com.projectlibre1.grouping.core.NodeFactory;
import com.projectlibre1.grouping.core.hierarchy.AbstractMutableNodeHierarchy;
import com.projectlibre1.grouping.core.hierarchy.HierarchyUtils;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.grouping.core.model.NodeModelUtil;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.dependency.Dependency;
import com.projectlibre1.pm.dependency.DependencyService;
import com.projectlibre1.pm.dependency.HasDependencies;
import com.projectlibre1.pm.resource.Resource;
import com.projectlibre1.pm.resource.ResourceImpl;
import com.projectlibre1.pm.resource.ResourcePool;
import com.projectlibre1.pm.snapshot.Snapshottable;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.task.SubProj;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.pm.task.TaskLinkReference;
import com.projectlibre1.pm.task.TaskSnapshot;
import com.projectlibre1.undo.NodeIndentEdit;
import com.projectlibre1.undo.NodeUndoInfo;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.Environment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MutableNodeHierarchy
extends AbstractMutableNodeHierarchy {
    public static int DEFAULT_NB_END_VOID_NODES = 50;
    public static int DEFAULT_NB_MULTIPROJECT_END_VOID_NODES = 1;
    private final Node root = NodeFactory.getInstance().createRootNode();
    protected int nbEndVoidNodes = DEFAULT_NB_END_VOID_NODES;
    protected int nbMultiprojectEndVoidNodes = DEFAULT_NB_MULTIPROJECT_END_VOID_NODES;
    protected transient EventListenerList listenerList = new EventListenerList();

    public static boolean isEvent(int n) {
        return (n & 1) == 1;
    }

    public static boolean isUndo(int n) {
        return (n & 2) == 2;
    }

    private void setSubprojectLevel(Node node, int n) {
        node.setSubprojectLevel(n);
        int n2 = this.getChildrenSubprojectLevel(node);
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            this.setSubprojectLevel(node2, n2);
        }
    }

    private int getChildrenSubprojectLevel(Node node) {
        if (node == null || node.isRoot()) {
            return 0;
        }
        if (NodeModelUtil.nodeIsSubproject(node)) {
            return node.getSubprojectLevel() + 1;
        }
        return node.getSubprojectLevel();
    }

    @Override
    public void add(Node node, List list, int n, int n2) {
        Node node2;
        Node node3 = node2 = node == null ? this.root : node;
        if (list.size() == 0) {
            return;
        }
        int n3 = this.getChildrenSubprojectLevel(node);
        int n4 = node2.getChildCount();
        if (n > n4) {
            NodeFactory nodeFactory = NodeFactory.getInstance();
            for (int i = n4; i < n; ++i) {
                Node node4 = nodeFactory.createVoidNode();
                this.setSubprojectLevel(node4, n3);
                node2.add(node4);
            }
        }
        int n5 = n;
        for (Node node4 : list) {
            this.setSubprojectLevel(node4, n3);
            if (n == -1) {
                node2.add(node4);
                continue;
            }
            node2.insert(node4, n5++);
        }
        if (MutableNodeHierarchy.isEvent(n2)) {
            this.renumber();
            this.fireNodesInserted(this, MutableNodeHierarchy.addDescendants(list));
        }
    }

    @Override
    public void paste(Node node, List list, int n, NodeModel nodeModel, int n2) {
        Object object8;
        Node[] nodeArray;
        Node node2 = node == null ? this.root : node;
        Project project = null;
        ResourcePool resourcePool = null;
        if (nodeModel.getDataFactory() instanceof Project) {
            project = (Project)nodeModel.getDataFactory();
        } else if (nodeModel.getDataFactory() instanceof ResourcePool) {
            resourcePool = (ResourcePool)nodeModel.getDataFactory();
        }
        int n3 = this.getChildrenSubprojectLevel(node);
        int n4 = node2.getChildCount();
        if (n > n4) {
            NodeFactory nodeFactory = NodeFactory.getInstance();
            nodeArray = nodeFactory.createVoidNode();
            for (int i = n4; i < n; ++i) {
                this.setSubprojectLevel((Node)nodeArray, n3);
                node2.add((MutableTreeNode)nodeArray);
            }
        }
        int n5 = n;
        for (Node node3 : list) {
            if (!(project != null && node3.getImpl() instanceof Task || resourcePool != null && node3.getImpl() instanceof Resource) && !node3.isVoid()) continue;
            this.setSubprojectLevel(node3, n3);
            if (n == -1) {
                node2.add(node3);
                continue;
            }
            node2.insert(node3, n5++);
        }
        nodeArray = MutableNodeHierarchy.addDescendants(list);
        ArrayList arrayList = new ArrayList();
        boolean bl = nodeModel.getDocument() != null && nodeArray.length > 0;
        int n6 = 0;
        if (bl) {
            n6 = nodeModel.getDocument().fireMultipleTransaction(0, true);
        }
        ArrayList<Node> arrayList2 = new ArrayList<Node>(nodeArray.length);
        if (project != null) {
            Task task2;
            Object object22;
            HashMap<Long, Resource> hashMap = new HashMap<Long, Resource>();
            for (Object object22 : project.getResourcePool().getResourceList()) {
                hashMap.put(object22.getUniqueId(), (Resource)object22);
            }
            object8 = null;
            if (Environment.isKeepExternalLinks()) {
                object8 = new HashMap();
                for (Task task2 : project.getTasks()) {
                    ((HashMap)object8).put(task2.getUniqueId(), task2);
                }
            }
            object22 = node != null && node.getImpl() instanceof Task ? ((task2 = (Task)node.getImpl()).isSubproject() ? ((SubProj)((Object)task2)).getSubproject() : task2.getOwningProject()) : (Project)nodeModel.getDataFactory();
            for (int i = 0; i < nodeArray.length; ++i) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                if (!(nodeArray[i].getImpl() instanceof Task)) continue;
                Task task3 = (Task)nodeArray[i].getImpl();
                Node node4 = this.getParentSubproject((Node)nodeArray[i].getParent());
                if (node4 != null) {
                    object22 = ((SubProj)node4.getImpl()).getSubproject();
                }
                if (!task3.isExternal()) {
                    task3.setProjectId(((Project)object22).getUniqueId());
                }
                ((Project)object22).validateObject(task3, nodeModel, this, null, false);
                HashSet<Object> hashSet = new HashSet<Object>();
                AssociationList associationList = task3.getDependencyList(true);
                if (associationList != null && associationList.size() > 0 && Environment.isKeepExternalLinks()) {
                    object7 = associationList.iterator();
                    while (object7.hasNext()) {
                        object6 = (Dependency)object7.next();
                        if (!(((Dependency)object6).getPredecessor() instanceof Task)) {
                            object5 = (TaskLinkReference)((Dependency)object6).getPredecessor();
                            object4 = (Task)((HashMap)object8).get(object5.getUniqueId());
                            if (object4 == null) {
                                object7.remove();
                                continue;
                            }
                            ((Dependency)object6).setPredecessor((HasDependencies)object4);
                            ((Task)object4).getSuccessorList().add((Association)object6);
                        }
                        hashSet.add(object6);
                    }
                }
                if ((object7 = task3.getDependencyList(false)) != null && object7.size() > 0 && Environment.isKeepExternalLinks()) {
                    object6 = object7.iterator();
                    while (object6.hasNext()) {
                        object5 = (Dependency)object6.next();
                        if (!(((Dependency)object5).getSuccessor() instanceof Task)) {
                            object4 = (TaskLinkReference)((Dependency)object5).getSuccessor();
                            object3 = (Task)((HashMap)object8).get(object4.getUniqueId());
                            if (object3 == null) {
                                object6.remove();
                                continue;
                            }
                            ((Dependency)object5).setSuccessor((HasDependencies)object3);
                            ((Task)object3).getPredecessorList().add((Association)object5);
                        }
                        hashSet.add(object5);
                    }
                }
                arrayList.addAll(hashSet);
                for (int j = 0; j < Settings.numBaselines(); ++j) {
                    object5 = (TaskSnapshot)task3.getSnapshot(new Integer(j));
                    if (object5 == null || ((AssociationList)(object4 = ((TaskSnapshot)object5).getHasAssignments().getAssignments())).size() <= 0) continue;
                    object3 = ((AssociationList)object4).listIterator();
                    while (object3.hasNext()) {
                        Assignment assignment = (Assignment)object3.next();
                        Resource resource = assignment.getResource();
                        if (resource == ResourceImpl.getUnassignedInstance()) continue;
                        Resource resource2 = (Resource)hashMap.get(resource.getUniqueId());
                        if (resource2 != null) {
                            if (!Snapshottable.CURRENT.equals(j)) continue;
                            if (resource2 != resource) {
                                resource = resource2;
                                assignment.getDetail().setResource(resource);
                            }
                            resource.addAssignment(assignment);
                            NodeUndoInfo nodeUndoInfo = new NodeUndoInfo(false);
                            ((ResourcePool)assignment.getResource().getDocument()).getObjectEventManager().fireCreateEvent(this, assignment, nodeUndoInfo);
                            continue;
                        }
                        assignment.getDetail().setResource(ResourceImpl.getUnassignedInstance());
                    }
                }
                project.initializeId(task3);
                project.addPastedTask(task3);
                arrayList2.add(nodeArray[i]);
            }
        } else if (resourcePool != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!(nodeArray[i].getImpl() instanceof Resource)) continue;
                object8 = (Resource)nodeArray[i].getImpl();
                nodeModel.getDataFactory().validateObject(object8, nodeModel, this, null, false);
                resourcePool.initializeId((Resource)object8);
                arrayList2.add(nodeArray[i]);
            }
        }
        if (project != null) {
            project.getSchedulingAlgorithm().markBoundsAsDirty();
        }
        if (bl) {
            nodeModel.getDocument().fireMultipleTransaction(n6, false);
        }
        if (MutableNodeHierarchy.isEvent(n2)) {
            this.renumber();
            this.fireNodesInserted(this, arrayList2.toArray(new Node[arrayList2.size()]));
            for (Object object8 : arrayList) {
                DependencyService.getInstance().updateSentinels((Dependency)object8);
                ((Dependency)object8).fireCreateEvent(this);
            }
        }
    }

    private Node getParentSubproject(Node node) {
        if (node.isRoot()) {
            return null;
        }
        if (node.getImpl() instanceof SubProj) {
            return node;
        }
        return this.getParentSubproject((Node)node.getParent());
    }

    @Override
    public void cleanVoidChildren() {
        this.cleanVoidChildren(this.root);
    }

    private void cleanVoidChildren(Node node) {
        ListIterator listIterator = node.childrenIterator();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (node2.isVoid()) {
                listIterator.remove();
                continue;
            }
            this.cleanVoidChildren(node2);
        }
    }

    public static void addDescendants(Node node, List list) {
        Enumeration<TreeNode> enumeration = ((NodeBridge)node).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
    }

    public static void addDescendants(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MutableNodeHierarchy.addDescendants((Node)iterator.next(), list2);
        }
    }

    private static Node[] addDescendants(List list) {
        ArrayList arrayList = new ArrayList();
        Node[] nodeArray = list.listIterator();
        while (nodeArray.hasNext()) {
            Node node = (Node)nodeArray.next();
            MutableNodeHierarchy.extractSameProjectBranch(node, arrayList);
        }
        nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        return nodeArray;
    }

    private static void extractSameProjectBranch(Node node, ArrayList arrayList) {
        arrayList.add(node);
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            MutableNodeHierarchy.extractSameProjectBranch(node2, arrayList);
        }
    }

    @Override
    public void remove(List list, NodeModel nodeModel, int n, boolean bl) {
        if (list != null) {
            boolean bl2 = nodeModel.getDocument() != null && list.size() > 0 && MutableNodeHierarchy.isEvent(n);
            int n2 = 0;
            if (bl2) {
                n2 = nodeModel.getDocument().fireMultipleTransaction(0, true);
            }
            ArrayList arrayList = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = new LinkedList();
                this.removeSubTree((Node)iterator.next(), nodeModel, linkedList, n, bl);
                arrayList.addAll(linkedList);
            }
            if (MutableNodeHierarchy.isEvent(n)) {
                this.renumber();
                this.fireNodesRemoved(this, arrayList.toArray());
            }
            if (bl2) {
                nodeModel.getDocument().fireMultipleTransaction(n2, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubTree(Node node, NodeModel nodeModel, LinkedList linkedList, int n, boolean bl) {
        if (this.getUpdateLevel() == 0) {
            try {
                node.removeFromParent();
                this.beginUpdate();
                int n2 = 0;
                LinkedList<TreeNode> linkedList2 = new LinkedList<TreeNode>();
                Enumeration<TreeNode> enumeration = ((NodeBridge)node).postorderEnumeration();
                while (enumeration.hasMoreElements()) {
                    linkedList2.add(enumeration.nextElement());
                }
                for (Node node2 : linkedList2) {
                    if (nodeModel.removeApartFromHierarchy(node2, false, n, bl)) {
                        linkedList.add(node2);
                        continue;
                    }
                    ++n2;
                }
                node.removeFromParent();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    @Override
    public void removeAll(NodeModel nodeModel, int n) {
        this.remove(this.buildList(), nodeModel, n, true);
    }

    @Override
    public void move(Node node, Node node2, int n) {
        this.setSubprojectLevel(node, this.getChildrenSubprojectLevel(node2));
        node2.add(node);
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Enumeration<TreeNode> enumeration = ((NodeBridge)node).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        if (MutableNodeHierarchy.isEvent(n)) {
            this.fireNodesChanged(this, arrayList.toArray());
        }
    }

    @Override
    public void indent(List list, int n, NodeModel nodeModel, int n2) {
        boolean bl = nodeModel.getDocument() != null;
        int n3 = 0;
        if (bl) {
            n3 = nodeModel.getDocument().fireMultipleTransaction(0, true);
        }
        List list2 = this.internalIndent(list, n, n2);
        if (bl) {
            nodeModel.getDocument().fireMultipleTransaction(n3, false);
        }
        if (nodeModel.getUndoableEditSupport() != null & MutableNodeHierarchy.isUndo(n2) && list2 != null && list2.size() > 0) {
            nodeModel.getUndoableEditSupport().postEdit(new NodeIndentEdit(nodeModel, list2, n));
        }
    }

    private List internalIndent(List list, int n, int n2) {
        if (n != 1 && n != -1) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        HierarchyUtils.extractParents(list, linkedList);
        ArrayList arrayList = new ArrayList();
        if (n > 0) {
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                if (!this.internalIndent((Node)listIterator.next(), n, n2 & 2, arrayList)) {
                    listIterator.remove();
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    listIterator.add(iterator.next());
                }
                arrayList.clear();
            }
        } else {
            ListIterator listIterator = linkedList.listIterator(linkedList.size());
            while (listIterator.hasPrevious()) {
                if (!this.internalIndent((Node)listIterator.previous(), n, n2 & 2, arrayList)) {
                    listIterator.remove();
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    listIterator.add(iterator.next());
                }
                arrayList.clear();
            }
        }
        if (MutableNodeHierarchy.isEvent(n2) && linkedList.size() > 0) {
            this.fireNodesChanged(this, linkedList.toArray());
        }
        return linkedList;
    }

    private boolean internalIndent(Node node, int n, int n2, List list) {
        if (node == null || node == this.root || !node.isIndentable(n)) {
            return false;
        }
        if (n == 1) {
            Node node2 = this.getParent(node);
            int n3 = node2.getIndex(node);
            if (n3 == 0) {
                return false;
            }
            Node node3 = null;
            Iterator iterator = node2.childrenIterator(n3);
            while (iterator.hasPrevious()) {
                Node node4 = (Node)iterator.previous();
                if (node.canBeChildOf(node4)) {
                    node3 = node4;
                    break;
                }
                if (!node4.isVoid()) continue;
                list.add(node4);
            }
            if (node3 == null || node3.getImpl() instanceof Assignment) {
                return false;
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                node3.add((Node)iterator.next());
            }
            node3.add(node);
            if (MutableNodeHierarchy.isEvent(n2)) {
                this.fireNodesChanged(this, new Node[]{node});
            }
        } else if (n == -1) {
            Object object;
            Node node5 = this.getParent(node);
            if (node5 == null || node5 == this.root) {
                return false;
            }
            if (node5.isLazyParent()) {
                return false;
            }
            Node node6 = this.getParent(node5);
            int n4 = node5.getIndex(node);
            if (n4 > 0) {
                ListIterator listIterator = node5.childrenIterator(n4);
                while (listIterator.hasPrevious() && (object = (Node)listIterator.previous()).isVoid()) {
                    list.add(object);
                }
            }
            n4 = node6.getIndex(node5) + 1;
            node6.insert(node, n4);
            object = list.iterator();
            while (object.hasNext()) {
                node6.insert((Node)object.next(), n4);
            }
            if (MutableNodeHierarchy.isEvent(n2)) {
                this.fireNodesChanged(this, new Node[]{node});
            }
        }
        return true;
    }

    @Override
    public void fireUpdate() {
        this.fireStructureChanged(this);
    }

    @Override
    public void fireUpdate(Node[] nodeArray) {
        this.fireNodesChanged(this, nodeArray);
    }

    @Override
    public void fireInsertion(Node[] nodeArray) {
        this.fireNodesInserted(this, nodeArray);
    }

    @Override
    public void fireRemoval(Node[] nodeArray) {
        this.fireNodesRemoved(this, nodeArray);
    }

    @Override
    public Node getParent(Node node) {
        if (node == null) {
            return null;
        }
        return (Node)node.getParent();
    }

    @Override
    public List getChildren(Node node) {
        return node == null ? this.root.getChildren() : node.getChildren();
    }

    @Override
    public int getLevel(Node node) {
        int n = 0;
        Node node2 = node;
        while (node2 != null) {
            ++n;
            node2 = this.getParent(node2);
        }
        return n - 1;
    }

    private List buildList() {
        return this.buildList(null);
    }

    private List buildList(Node node) {
        ArrayList arrayList = new ArrayList();
        this.buildList(node, arrayList);
        return arrayList;
    }

    private void buildList(Node node, List list) {
        List list2;
        Node node2;
        Node node3 = node2 = node == null ? this.root : node;
        if (node2 != this.root) {
            list.add(node2);
        }
        if ((list2 = this.getChildren(node2)) != null) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                this.buildList((Node)iterator.next(), list);
            }
        }
    }

    private Node searchPrevious(Node node) {
        if (node == null || node == this.root) {
            return null;
        }
        Node node2 = this.getParent(node);
        List list = this.getChildren(node2);
        if (list == null) {
            return null;
        }
        for (Node node3 : list) {
            if (node3.equals(node)) {
                return node2;
            }
            node2 = node3;
        }
        return null;
    }

    private Node searchLast(Node node) {
        Node node2;
        Node node3 = node2 = node == null ? this.root : node;
        while (!this.isLeaf(node2)) {
            List list = this.getChildren(node2);
            node2 = (Node)list.get(list.size() - 1);
        }
        return node2;
    }

    private Node searchLast(int n) {
        Node node = null;
        for (int i = 0; !this.isLeaf(node) && i < n; ++i) {
            List list = this.getChildren(node);
            node = (Node)list.get(list.size() - 1);
        }
        return node;
    }

    private boolean contains(Object object) {
        Alert.error("contains not implemented");
        return false;
    }

    @Override
    public Object clone() {
        Alert.error("clone not implemented");
        return null;
    }

    @Override
    public Node search(Object object, Comparator comparator) {
        return this.search(this.root, object, comparator);
    }

    private Node search(Node node, Object object, Comparator comparator) {
        if (comparator.compare(node == null ? this.root : node, object) == 0) {
            return node;
        }
        List list = this.getChildren(node);
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node2 = this.search((Node)iterator.next(), object, comparator);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    @Override
    public boolean isSummary(Node node) {
        List list = this.getChildren(node);
        if (list == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((Node)iterator.next()).getImpl() instanceof Assignment) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        List list = this.getChildren((Node)object);
        return list == null || list.size() == 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        Node node = (Node)treePath.getLastPathComponent();
    }

    protected boolean checkSubprojectEndVoidNodes(Node node, List list) {
        Node node2;
        int n = 0;
        boolean bl = false;
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            node2 = (Node)enumeration.nextElement();
            if (this.checkSubprojectEndVoidNodes(node2, list)) {
                bl = true;
            }
            if (!NodeModelUtil.nodeIsSubproject(node)) continue;
            if (node2.isVoid()) {
                ++n;
                continue;
            }
            n = 0;
        }
        if (NodeModelUtil.nodeIsSubproject(node)) {
            Object object;
            int n2 = this.nbMultiprojectEndVoidNodes;
            if (node.getImpl() instanceof SubProj && (object = ((SubProj)node.getImpl()).getSubproject()) != null && ((Project)object).isReadOnly()) {
                n2 = 0;
            }
            if (n < n2 && (object = (LazyParent)node.getImpl()).isDataFetched()) {
                int n3 = this.getChildrenSubprojectLevel(node);
                for (int i = 0; i < this.nbMultiprojectEndVoidNodes - n; ++i) {
                    node2 = NodeFactory.getInstance().createVoidNode();
                    this.setSubprojectLevel(node2, n3);
                    node.add(node2);
                    list.add(node2);
                }
            }
        }
        return bl;
    }

    @Override
    public void checkEndVoidNodes(int n) {
        this.checkEndVoidNodes(false, n);
    }

    @Override
    public void checkEndVoidNodes(boolean bl, int n) {
        Node node;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (!bl) {
            this.checkSubprojectEndVoidNodes(this.root, arrayList);
        }
        int n2 = bl ? this.nbMultiprojectEndVoidNodes : this.nbEndVoidNodes;
        int n3 = 0;
        ListIterator listIterator = this.root.childrenIterator(this.root.getChildCount());
        while (listIterator.hasPrevious() && (node = (Node)listIterator.previous()).isVoid()) {
            ++n3;
        }
        if (n3 < n2) {
            for (int i = 0; i < n2 - n3; ++i) {
                node = NodeFactory.getInstance().createVoidNode();
                this.root.add(node);
                arrayList.add(node);
            }
        } else if (n3 > n2) {
            int n4 = n3 - n2;
            ListIterator listIterator2 = this.root.childrenIterator(this.root.getChildCount());
            while (listIterator2.hasPrevious() && (node = (Node)listIterator2.previous()).isVoid()) {
                listIterator2.remove();
                if (--n4 != 0) continue;
            }
        }
        if (MutableNodeHierarchy.isEvent(n) && arrayList.size() > 0) {
            this.fireNodesInserted(this, arrayList.toArray());
        }
    }

    @Override
    public int getNbEndVoidNodes() {
        return this.nbEndVoidNodes;
    }

    @Override
    public void setNbEndVoidNodes(int n) {
        if (n == -1) {
            n = DEFAULT_NB_END_VOID_NODES;
        }
        this.nbEndVoidNodes = n;
    }
}

