# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `pdf-reader` gem.
# Please instead update this file by running `bundle exec spoom srb sigs export`.

module PDF; end

class PDF::Reader
  sig { params(input: T.any(::IO, ::String, ::StringIO, ::Tempfile), opts: T::Hash[T.untyped, T.untyped]).void }
  def initialize(input, opts = T.unsafe(nil)); end

  sig { returns(T.nilable(T::Hash[T.untyped, T.untyped])) }
  def info; end

  sig { returns(T.nilable(::String)) }
  def metadata; end

  sig { returns(::PDF::Reader::ObjectHash) }
  def objects; end

  sig { params(num: ::Integer).returns(::PDF::Reader::Page) }
  def page(num); end

  sig { returns(::Integer) }
  def page_count; end

  sig { returns(T::Array[::PDF::Reader::Page]) }
  def pages; end

  sig { returns(::Float) }
  def pdf_version; end

  private

  sig { params(obj: T.untyped).returns(T.untyped) }
  def doc_strings_to_utf8(obj); end

  sig { params(str: ::String).returns(T::Boolean) }
  def has_utf16_bom?(str); end

  sig { params(obj: ::String).returns(::String) }
  def pdfdoc_to_utf8(obj); end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def root; end

  sig { params(obj: ::String).returns(::String) }
  def utf16_to_utf8(obj); end

  class << self
    sig do
      params(
        input: T.any(::IO, ::String, ::Tempfile),
        opts: T::Hash[T.untyped, T.untyped],
        block: T.proc.params(arg0: ::PDF::Reader).void
      ).returns(T.untyped)
    end
    def open(input, opts = T.unsafe(nil), &block); end
  end
end

class PDF::Reader::AdvancedTextRunFilter
  sig { params(text_runs: T::Array[::PDF::Reader::TextRun], filter_hash: T::Hash[::Symbol, T.untyped]).void }
  def initialize(text_runs, filter_hash); end

  sig { returns(T::Array[::PDF::Reader::TextRun]) }
  def exclude; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def filter_hash; end

  sig { returns(T::Array[::PDF::Reader::TextRun]) }
  def only; end

  sig { returns(T::Array[::PDF::Reader::TextRun]) }
  def text_runs; end

  private

  sig { params(attribute_value: T.untyped, operator: ::Symbol, filter_value: T.untyped).returns(T::Boolean) }
  def apply_operator(attribute_value, operator, filter_value); end

  sig do
    params(
      text_run: ::PDF::Reader::TextRun,
      conditions: T::Array[T::Hash[::Symbol, T.untyped]]
    ).returns(T::Boolean)
  end
  def evaluate_and_filters(text_run, conditions); end

  sig do
    params(
      text_run: ::PDF::Reader::TextRun,
      attribute: ::Symbol,
      conditions: T::Hash[::Symbol, T.untyped]
    ).returns(T::Boolean)
  end
  def evaluate_attribute_conditions(text_run, attribute, conditions); end

  sig { params(text_run: ::PDF::Reader::TextRun).returns(T::Boolean) }
  def evaluate_filter(text_run); end

  sig { params(text_run: ::PDF::Reader::TextRun, filter_hash: T::Hash[::Symbol, T.untyped]).returns(T::Boolean) }
  def evaluate_filters(text_run, filter_hash); end

  sig do
    params(
      text_run: ::PDF::Reader::TextRun,
      conditions: T::Array[T::Hash[::Symbol, T.untyped]]
    ).returns(T::Boolean)
  end
  def evaluate_or_filters(text_run, conditions); end

  class << self
    sig do
      params(
        text_runs: T::Array[::PDF::Reader::TextRun],
        filter_hash: T::Hash[::Symbol, T.untyped]
      ).returns(T::Array[::PDF::Reader::TextRun])
    end
    def exclude(text_runs, filter_hash); end

    sig do
      params(
        text_runs: T::Array[::PDF::Reader::TextRun],
        filter_hash: T::Hash[::Symbol, T.untyped]
      ).returns(T::Array[::PDF::Reader::TextRun])
    end
    def only(text_runs, filter_hash); end
  end
end

PDF::Reader::AdvancedTextRunFilter::VALID_OPERATORS = T.let(T.unsafe(nil), Array)

class PDF::Reader::AesV2SecurityHandler
  sig { params(key: ::String).void }
  def initialize(key); end

  sig { params(buf: ::String, ref: ::PDF::Reader::Reference).returns(::String) }
  def decrypt(buf, ref); end

  private

  sig { params(buf: ::String, ref: ::PDF::Reader::Reference, padding: T::Boolean).returns(::String) }
  def internal_decrypt(buf, ref, padding = T.unsafe(nil)); end
end

class PDF::Reader::AesV3SecurityHandler
  sig { params(key: ::String).void }
  def initialize(key); end

  sig { params(buf: ::String, ref: ::PDF::Reader::Reference).returns(::String) }
  def decrypt(buf, ref); end

  private

  sig { params(buf: ::String, ref: ::PDF::Reader::Reference, padding: T::Boolean).returns(::String) }
  def internal_decrypt(buf, ref, padding = T.unsafe(nil)); end
end

class PDF::Reader::BoundingRectangleRunsFilter
  class << self
    sig do
      params(
        runs: T::Array[::PDF::Reader::TextRun],
        rect: ::PDF::Reader::Rectangle
      ).returns(T::Array[::PDF::Reader::TextRun])
    end
    def runs_within_rect(runs, rect); end
  end
end

class PDF::Reader::Buffer
  sig { params(io: T.any(::IO, ::StringIO, ::Tempfile), opts: T::Hash[::Symbol, T.untyped]).void }
  def initialize(io, opts = T.unsafe(nil)); end

  sig { returns(T::Boolean) }
  def empty?; end

  sig { returns(::Integer) }
  def find_first_xref_offset; end

  sig { returns(::Integer) }
  def pos; end

  sig { params(bytes: ::Integer, opts: T::Hash[::Symbol, T.untyped]).returns(T.nilable(::String)) }
  def read(bytes, opts = T.unsafe(nil)); end

  sig { returns(T.nilable(T.any(::PDF::Reader::Reference, ::String))) }
  def token; end

  private

  sig { void }
  def check_size_is_non_zero; end

  sig { returns(T::Boolean) }
  def in_content_stream?; end

  sig { void }
  def merge_indirect_reference; end

  sig { returns(T.nilable(::Integer)) }
  def peek_byte; end

  sig { void }
  def prepare_hex_token; end

  sig { void }
  def prepare_inline_token; end

  sig { void }
  def prepare_literal_token; end

  sig { void }
  def prepare_regular_token; end

  sig { void }
  def prepare_tokens; end

  sig { void }
  def reset_pos; end

  sig { void }
  def save_pos; end

  sig { returns(::Symbol) }
  def state; end
end

PDF::Reader::Buffer::CR = T.let(T.unsafe(nil), String)
PDF::Reader::Buffer::CRLF = T.let(T.unsafe(nil), String)
PDF::Reader::Buffer::DIGITS_ONLY = T.let(T.unsafe(nil), Regexp)
PDF::Reader::Buffer::FWD_SLASH = T.let(T.unsafe(nil), String)
PDF::Reader::Buffer::ID = T.let(T.unsafe(nil), String)
PDF::Reader::Buffer::LEFT_PAREN = T.let(T.unsafe(nil), String)
PDF::Reader::Buffer::LESS_THAN = T.let(T.unsafe(nil), String)
PDF::Reader::Buffer::LF = T.let(T.unsafe(nil), String)
PDF::Reader::Buffer::NULL_BYTE = T.let(T.unsafe(nil), String)
PDF::Reader::Buffer::STREAM = T.let(T.unsafe(nil), String)
PDF::Reader::Buffer::TOKEN_DELIMITER = T.let(T.unsafe(nil), Array)
PDF::Reader::Buffer::TOKEN_WHITESPACE = T.let(T.unsafe(nil), Array)
PDF::Reader::Buffer::TRAILING_BYTECOUNT = T.let(T.unsafe(nil), Integer)
PDF::Reader::Buffer::WHITE_SPACE = T.let(T.unsafe(nil), Array)

class PDF::Reader::CMap
  sig { params(data: ::String).void }
  def initialize(data); end

  sig { params(c: ::Integer).returns(T::Array[::Integer]) }
  def decode(c); end

  sig { returns(T::Hash[::Integer, T::Array[::Integer]]) }
  def map; end

  sig { returns(::Integer) }
  def size; end

  private

  sig { params(start_code: ::String, end_code: ::String, dst: ::String).void }
  def bfrange_type_one(start_code, end_code, dst); end

  sig { params(start_code: ::String, end_code: ::String, dst: T::Array[::String]).void }
  def bfrange_type_two(start_code, end_code, dst); end

  sig { params(instructions: ::String).returns(::PDF::Reader::Parser) }
  def build_parser(instructions); end

  sig { params(instructions: T::Array[::String]).void }
  def process_bfchar_instructions(instructions); end

  sig { params(instructions: T::Array[T.any(::String, T::Array[::String])]).void }
  def process_bfrange_instructions(instructions); end

  sig { params(data: ::String, initial_mode: ::Symbol).void }
  def process_data(data, initial_mode = T.unsafe(nil)); end

  sig { params(str: ::String).returns(T::Array[::Integer]) }
  def str_to_int(str); end
end

PDF::Reader::CMap::CMAP_KEYWORDS = T.let(T.unsafe(nil), Hash)

class PDF::Reader::CidWidths
  extend ::Forwardable

  sig { params(default: ::Numeric, array: T::Array[::Numeric]).void }
  def initialize(default, array); end

  def [](*args, **_arg1, &block); end
  def fetch(*args, **_arg1, &block); end

  private

  sig { params(default: ::Numeric, array: T::Array[::Numeric]).returns(T::Hash[::Numeric, ::Numeric]) }
  def parse_array(default, array); end

  sig { params(first: ::Integer, widths: T::Array[::Numeric]).returns(T::Hash[::Numeric, ::Numeric]) }
  def parse_first_form(first, widths); end

  sig { params(first: ::Integer, final: ::Integer, width: ::Numeric).returns(T::Hash[::Numeric, ::Numeric]) }
  def parse_second_form(first, final, width); end
end

class PDF::Reader::Encoding
  sig { params(enc: T.nilable(T.any(::Symbol, T::Hash[::Symbol, T.untyped]))).void }
  def initialize(enc); end

  sig { returns(T::Hash[::Integer, ::Integer]) }
  def differences; end

  sig { params(diff: T::Array[T.any(::Integer, ::Symbol)]).returns(T::Hash[::Integer, ::Integer]) }
  def differences=(diff); end

  sig { params(glyph_code: ::Integer).returns(T::Array[::Symbol]) }
  def int_to_name(glyph_code); end

  sig { params(glyph_code: ::Integer).returns(::String) }
  def int_to_utf8_string(glyph_code); end

  sig { params(str: ::String).returns(::String) }
  def to_utf8(str); end

  sig { returns(::String) }
  def unpack; end

  private

  sig { params(str: ::String).returns(::String) }
  def convert_to_utf8(str); end

  sig { returns(T::Hash[::Integer, ::Integer]) }
  def default_mapping; end

  sig { params(enc: ::Symbol).returns(T.nilable(::String)) }
  def get_mapping_file(enc); end

  sig { params(enc: ::Symbol).returns(::String) }
  def get_unpack(enc); end

  sig { returns(::PDF::Reader::GlyphHash) }
  def glyphlist; end

  sig { params(glyph_code: ::Integer).returns(::String) }
  def internal_int_to_utf8_string(glyph_code); end

  sig { params(times: ::Integer).returns(::String) }
  def little_boxes(times); end

  sig { params(file: ::String).void }
  def load_mapping(file); end

  sig { returns(T::Boolean) }
  def utf8_conversion_impossible?; end
end

PDF::Reader::Encoding::CONTROL_CHARS = T.let(T.unsafe(nil), Array)
PDF::Reader::Encoding::UNKNOWN_CHAR = T.let(T.unsafe(nil), Integer)
class PDF::Reader::EncryptedPDFError < ::PDF::Reader::UnsupportedFeatureError; end

class PDF::Reader::Error
  class << self
    sig { params(lvalue: T.untyped, rvalue: T.untyped).returns(T.untyped) }
    def assert_equal(lvalue, rvalue); end

    sig { params(lvalue: T.untyped, rvalue: T.untyped, chars: T.untyped).returns(T.untyped) }
    def str_assert(lvalue, rvalue, chars = T.unsafe(nil)); end

    sig { params(lvalue: T.untyped, rvalue: T.untyped, chars: T.untyped).returns(T.untyped) }
    def str_assert_not(lvalue, rvalue, chars = T.unsafe(nil)); end

    sig { params(object: ::Object, name: ::String).void }
    def validate_not_nil(object, name); end

    sig { params(object: ::Object, name: ::String, klass: ::Module).void }
    def validate_type(object, name, klass); end

    sig { params(object: ::Object, name: ::String, klass: ::Module).void }
    def validate_type_as_malformed(object, name, klass); end
  end
end

class PDF::Reader::EventPoint
  sig { params(x: ::Numeric, run: ::PDF::Reader::TextRun).void }
  def initialize(x, run); end

  sig { returns(::PDF::Reader::TextRun) }
  def run; end

  sig { returns(T::Boolean) }
  def start?; end

  sig { returns(::Numeric) }
  def x; end
end

module PDF::Reader::Filter
  class << self
    sig { params(name: ::Symbol, options: T::Hash[T.untyped, T.untyped]).returns(T.untyped) }
    def with(name, options = T.unsafe(nil)); end
  end
end

class PDF::Reader::Filter::Ascii85
  sig { params(options: T::Hash[T.untyped, T.untyped]).void }
  def initialize(options = T.unsafe(nil)); end

  sig { params(data: ::String).returns(::String) }
  def filter(data); end
end

class PDF::Reader::Filter::AsciiHex
  sig { params(options: T::Hash[T.untyped, T.untyped]).void }
  def initialize(options = T.unsafe(nil)); end

  sig { params(data: ::String).returns(::String) }
  def filter(data); end
end

class PDF::Reader::Filter::Depredict
  sig { params(options: T::Hash[T.untyped, T.untyped]).void }
  def initialize(options = T.unsafe(nil)); end

  sig { params(data: ::String).returns(::String) }
  def filter(data); end

  private

  sig { params(data: T.untyped).returns(::String) }
  def png_depredict(data); end

  sig { params(data: T.untyped).returns(::String) }
  def tiff_depredict(data); end
end

class PDF::Reader::Filter::Flate
  sig { params(options: T::Hash[T.untyped, T.untyped]).void }
  def initialize(options = T.unsafe(nil)); end

  sig { params(data: ::String).returns(::String) }
  def filter(data); end

  private

  sig { params(data: T.untyped).returns(T.untyped) }
  def zlib_inflate(data); end
end

PDF::Reader::Filter::Flate::ZLIB_AUTO_DETECT_ZLIB_OR_GZIP = T.let(T.unsafe(nil), Integer)
PDF::Reader::Filter::Flate::ZLIB_RAW_DEFLATE = T.let(T.unsafe(nil), Integer)

class PDF::Reader::Filter::Lzw
  sig { params(options: T::Hash[T.untyped, T.untyped]).void }
  def initialize(options = T.unsafe(nil)); end

  sig { params(data: ::String).returns(::String) }
  def filter(data); end
end

class PDF::Reader::Filter::Null
  sig { params(options: T::Hash[T.untyped, T.untyped]).void }
  def initialize(options = T.unsafe(nil)); end

  sig { params(data: ::String).returns(::String) }
  def filter(data); end
end

class PDF::Reader::Filter::RunLength
  sig { params(options: T::Hash[T.untyped, T.untyped]).void }
  def initialize(options = T.unsafe(nil)); end

  sig { params(data: ::String).returns(::String) }
  def filter(data); end
end

class PDF::Reader::Font
  sig { params(ohash: ::PDF::Reader::ObjectHash, obj: T::Hash[::Symbol, T.untyped]).void }
  def initialize(ohash, obj); end

  sig { returns(T.nilable(::Symbol)) }
  def basefont; end

  sig { returns(::Numeric) }
  def cid_default_width; end

  sig { returns(T::Array[::Numeric]) }
  def cid_widths; end

  sig { returns(T::Array[::PDF::Reader::Font]) }
  def descendantfonts; end

  def descendantfonts=(_arg0); end

  sig { returns(::PDF::Reader::Encoding) }
  def encoding; end

  def encoding=(_arg0); end

  sig { returns(T.nilable(::Integer)) }
  def first_char; end

  sig { returns(T.nilable(::PDF::Reader::FontDescriptor)) }
  def font_descriptor; end

  sig { params(code_point: T.any(::Integer, ::String)).returns(::Numeric) }
  def glyph_width(code_point); end

  sig { params(code_point: T.any(::Integer, ::String)).returns(::Numeric) }
  def glyph_width_in_text_space(code_point); end

  sig { returns(T.nilable(::Integer)) }
  def last_char; end

  sig { returns(T.nilable(::Symbol)) }
  def subtype; end

  def subtype=(_arg0); end

  sig { params(params: T.any(::Integer, ::String, T::Array[T.any(::Integer, ::String)])).returns(::String) }
  def to_utf8(params); end

  sig { returns(T.nilable(::PDF::Reader::CMap)) }
  def tounicode; end

  def tounicode=(_arg0); end

  sig { params(data: ::String).returns(T.nilable(T::Array[T.nilable(T.any(::Float, ::Integer, ::String))])) }
  def unpack(data); end

  sig { returns(T::Array[::Numeric]) }
  def widths; end

  private

  sig { params(obj: T::Hash[::Symbol, T.untyped]).returns(::PDF::Reader::Encoding) }
  def build_encoding(obj); end

  sig { returns(T.untyped) }
  def build_width_calculator; end

  sig { params(font_name: T.nilable(T.any(::String, ::Symbol))).returns(::PDF::Reader::Encoding) }
  def default_encoding(font_name); end

  sig { params(obj: T::Hash[::Symbol, T.untyped]).void }
  def extract_base_info(obj); end

  sig { params(obj: T::Hash[::Symbol, T.untyped]).void }
  def extract_descendants(obj); end

  sig { params(obj: T::Hash[::Symbol, T.untyped]).void }
  def extract_descriptor(obj); end

  sig { params(obj: T::Hash[::Symbol, T.untyped]).void }
  def extract_type3_info(obj); end

  sig { params(x: ::Numeric, y: ::Numeric).returns([::Numeric, ::Numeric]) }
  def font_matrix_transform(x, y); end

  sig do
    params(
      params: T.any(::Integer, ::String, T::Array[T.any(::Integer, ::String)]),
      cmap: ::PDF::Reader::CMap
    ).returns(::String)
  end
  def to_utf8_via_cmap(params, cmap); end

  sig { params(params: T.any(::Integer, ::String, T::Array[T.any(::Integer, ::String)])).returns(::String) }
  def to_utf8_via_encoding(params); end

  sig { params(unpack_me: ::String, unpack_arg: ::String).returns(T::Array[::Integer]) }
  def unpack_string_to_array_of_ints(unpack_me, unpack_arg); end
end

class PDF::Reader::FontDescriptor
  sig { params(ohash: ::PDF::Reader::ObjectHash, fd_hash: T::Hash[T.untyped, T.untyped]).void }
  def initialize(ohash, fd_hash); end

  sig { returns(::Numeric) }
  def ascent; end

  sig { returns(::Numeric) }
  def avg_width; end

  sig { returns(::Numeric) }
  def cap_height; end

  sig { returns(::Numeric) }
  def descent; end

  sig { returns(T::Array[::Numeric]) }
  def font_bounding_box; end

  sig { returns(T.nilable(::String)) }
  def font_family; end

  sig { returns(::Integer) }
  def font_flags; end

  sig { returns(::String) }
  def font_name; end

  sig { returns(::Symbol) }
  def font_stretch; end

  sig { returns(::Numeric) }
  def font_weight; end

  sig { returns(::Numeric) }
  def glyph_to_pdf_scale_factor; end

  sig { params(char_code: ::Integer).returns(::Numeric) }
  def glyph_width(char_code); end

  sig { returns(T.nilable(::Numeric)) }
  def italic_angle; end

  sig { returns(::Numeric) }
  def leading; end

  sig { returns(::Numeric) }
  def max_width; end

  sig { returns(::Numeric) }
  def missing_width; end

  sig { returns(T.nilable(::Numeric)) }
  def stem_v; end

  sig { returns(T.nilable(::Numeric)) }
  def x_height; end

  private

  sig { returns(::TTFunk::File) }
  def ttf_program_stream; end
end

class PDF::Reader::FormXObject
  extend ::Forwardable

  sig { params(page: T.untyped, xobject: T.untyped, options: T::Hash[T.untyped, T.untyped]).void }
  def initialize(page, xobject, options = T.unsafe(nil)); end

  def color_spaces(*args, **_arg1, &block); end

  sig { returns(T.untyped) }
  def font_objects; end

  def fonts(*args, **_arg1, &block); end
  def graphic_states(*args, **_arg1, &block); end
  def patterns(*args, **_arg1, &block); end
  def procedure_sets(*args, **_arg1, &block); end
  def properties(*args, **_arg1, &block); end

  sig { returns(T.untyped) }
  def raw_content; end

  def shadings(*args, **_arg1, &block); end

  sig { params(receivers: T.untyped).returns(T.untyped) }
  def walk(*receivers); end

  sig { returns(T.untyped) }
  def xobject; end

  def xobjects(*args, **_arg1, &block); end

  private

  sig { returns(T.untyped) }
  def cached_tokens_key; end

  sig { params(receivers: T.untyped, name: T.untyped, params: T::Array[T.untyped]).returns(T.untyped) }
  def callback(receivers, name, params = T.unsafe(nil)); end

  sig { params(receivers: T.untyped, instructions: T.untyped).returns(T.untyped) }
  def content_stream(receivers, instructions); end

  sig { returns(T.untyped) }
  def content_stream_md5; end

  sig { returns(T.untyped) }
  def resources; end

  sig { returns(T.untyped) }
  def tokens; end
end

class PDF::Reader::GlyphHash
  sig { void }
  def initialize; end

  sig { params(name: T.nilable(::Symbol)).returns(T.nilable(::Integer)) }
  def name_to_unicode(name); end

  sig { params(codepoint: ::Integer).returns(T::Array[::Symbol]) }
  def unicode_to_name(codepoint); end

  private

  sig { returns(::PDF::Reader::GlyphHash::ReturnData) }
  def load_adobe_glyph_mapping; end
end

class PDF::Reader::GlyphHash::ReturnData
  def initialize(by_name, by_codepoint); end

  sig { returns(T::Hash[::Integer, T::Array[::Symbol]]) }
  def by_codepoint; end

  sig { returns(T::Hash[::Symbol, ::Integer]) }
  def by_name; end
end

class PDF::Reader::InvalidObjectError < ::PDF::Reader::MalformedPDFError; end
class PDF::Reader::InvalidPageError < ::ArgumentError; end

class PDF::Reader::KeyBuilderV5
  sig { params(opts: T::Hash[::Symbol, ::String]).void }
  def initialize(opts = T.unsafe(nil)); end

  sig { params(pass: ::String).returns(::String) }
  def key(pass); end

  private

  sig { params(password: ::String).returns(T.nilable(::String)) }
  def auth_owner_pass(password); end

  sig { params(password: ::String).returns(T.nilable(::String)) }
  def auth_owner_pass_r6(password); end

  sig { params(password: ::String).returns(T.nilable(::String)) }
  def auth_user_pass(password); end

  sig { params(password: ::String).returns(T.nilable(::String)) }
  def auth_user_pass_r6(password); end

  sig { params(password: ::String, salt: ::String, user_key: ::String).returns(::String) }
  def r6_digest(password, salt, user_key = T.unsafe(nil)); end

  sig { params(str: ::String).returns(::Integer) }
  def unpack_128bit_bigendian_int(str); end
end

class PDF::Reader::LZW
  class << self
    sig { params(data: ::String).returns(::String) }
    def decode(data); end

    private

    sig do
      params(
        string_table: ::PDF::Reader::LZW::StringTable,
        some_code: T.nilable(::Integer),
        other_code: T.nilable(::Integer)
      ).returns(::String)
    end
    def create_new_string(string_table, some_code, other_code); end
  end
end

class PDF::Reader::LZW::BitStream
  sig { params(data: ::String, bits_in_chunk: ::Integer).void }
  def initialize(data, bits_in_chunk); end

  sig { returns(::Integer) }
  def read; end

  sig { params(bits_in_chunk: ::Integer).void }
  def set_bits_in_chunk(bits_in_chunk); end
end

PDF::Reader::LZW::CODE_CLEAR_TABLE = T.let(T.unsafe(nil), Integer)
PDF::Reader::LZW::CODE_EOD = T.let(T.unsafe(nil), Integer)

class PDF::Reader::LZW::StringTable
  sig { void }
  def initialize; end

  sig { params(key: ::Integer).returns(T.nilable(::String)) }
  def [](key); end

  sig { params(string: ::String).void }
  def add(string); end

  sig { returns(::Integer) }
  def string_table_pos; end
end

class PDF::Reader::MalformedPDFError < ::RuntimeError; end

class PDF::Reader::NoTextFilter
  class << self
    sig { params(runs: T::Array[::PDF::Reader::TextRun]).returns(T::Array[::PDF::Reader::TextRun]) }
    def exclude_empty_strings(runs); end
  end
end

class PDF::Reader::NullSecurityHandler
  sig { params(buf: ::String, _ref: ::PDF::Reader::Reference).returns(::String) }
  def decrypt(buf, _ref); end
end

class PDF::Reader::ObjectCache
  sig { params(lru_size: T.untyped).void }
  def initialize(lru_size = T.unsafe(nil)); end

  def [](key); end
  def []=(key, value); end
  def each(&block); end
  def each_key(&block); end
  def each_pair(&block); end
  def each_value(&block); end
  def empty?; end
  def fetch(key, local_default = T.unsafe(nil)); end
  def has_key?(key); end
  def has_value?(value); end

  sig { returns(T.untyped) }
  def hits; end

  def include?(key); end
  def key?(key); end
  def keys; end
  def length; end
  def member?(key); end

  sig { returns(T.untyped) }
  def misses; end

  def size; end
  def to_s; end
  def values; end

  private

  def cacheable?(obj); end
  def update_stats(key); end
end

PDF::Reader::ObjectCache::CACHEABLE_TYPES = T.let(T.unsafe(nil), Array)

class PDF::Reader::ObjectHash
  include ::Enumerable

  sig { params(input: T.any(::IO, ::String, ::StringIO, ::Tempfile), opts: T::Hash[::Symbol, T.untyped]).void }
  def initialize(input, opts = T.unsafe(nil)); end

  sig { params(key: T.any(::Integer, ::PDF::Reader::Reference)).returns(T.untyped) }
  def [](key); end

  sig { returns(T.untyped) }
  def default; end

  def default=(_arg0); end
  def deref(*args, **_arg1, &blk); end

  sig { params(key: T.untyped).returns(T.untyped) }
  def deref!(key); end

  sig { params(key: T.untyped).returns(T.nilable(T::Array[T.untyped])) }
  def deref_array(key); end

  sig { params(key: T.untyped).returns(T.nilable(T::Array[T.untyped])) }
  def deref_array!(key); end

  sig { params(key: T.untyped).returns(T.nilable(T::Array[::Numeric])) }
  def deref_array_of_numbers(key); end

  sig { params(key: T.untyped).returns(T.nilable(T::Hash[::Symbol, T.untyped])) }
  def deref_hash(key); end

  sig { params(key: T.untyped).returns(T.nilable(T::Hash[::Symbol, T.untyped])) }
  def deref_hash!(key); end

  sig { params(key: T.untyped).returns(T.nilable(::Integer)) }
  def deref_integer(key); end

  sig { params(key: T.untyped).returns(T.nilable(::Symbol)) }
  def deref_name(key); end

  sig { params(key: T.untyped).returns(T.nilable(T.any(::Symbol, T::Array[T.untyped]))) }
  def deref_name_or_array(key); end

  sig { params(key: T.untyped).returns(T.nilable(::Numeric)) }
  def deref_number(key); end

  sig { params(key: T.untyped).returns(T.nilable(::PDF::Reader::Stream)) }
  def deref_stream(key); end

  sig { params(key: T.untyped).returns(T.nilable(T.any(::PDF::Reader::Stream, T::Array[T.untyped]))) }
  def deref_stream_or_array(key); end

  sig { params(key: T.untyped).returns(T.nilable(::String)) }
  def deref_string(key); end

  sig do
    override
      .params(
        block: T.proc.params(arg0: ::PDF::Reader::Reference, arg1: T.untyped).returns(T.untyped)
      ).returns(T.untyped)
  end
  def each(&block); end

  sig { params(block: T.proc.params(arg0: ::PDF::Reader::Reference).returns(T.untyped)).returns(T.untyped) }
  def each_key(&block); end

  def each_pair(*args, **_arg1, &blk); end

  sig { params(block: T.proc.params(arg0: T.untyped).returns(T.untyped)).returns(T.untyped) }
  def each_value(&block); end

  sig { returns(T::Boolean) }
  def empty?; end

  sig { returns(T::Boolean) }
  def encrypted?; end

  sig { params(key: T.untyped, local_default: T.untyped).returns(T.untyped) }
  def fetch(key, local_default = T.unsafe(nil)); end

  sig { params(check_key: T.untyped).returns(T::Boolean) }
  def has_key?(check_key); end

  sig { params(value: T.untyped).returns(T::Boolean) }
  def has_value?(value); end

  def include?(*args, **_arg1, &blk); end
  def key?(*args, **_arg1, &blk); end

  sig { returns(T::Array[::PDF::Reader::Reference]) }
  def keys; end

  def length(*args, **_arg1, &blk); end
  def member?(*args, **_arg1, &blk); end

  sig { params(ref: T.any(::Integer, ::PDF::Reader::Reference)).returns(T.nilable(::Symbol)) }
  def obj_type(ref); end

  sig { params(key: T.untyped).returns(T.untyped) }
  def object(key); end

  sig { returns(T::Array[T.any(::PDF::Reader::Reference, T::Hash[::Symbol, T.untyped])]) }
  def page_references; end

  sig { returns(::Float) }
  def pdf_version; end

  sig { returns(T.untyped) }
  def sec_handler; end

  sig { returns(T::Boolean) }
  def sec_handler?; end

  sig { returns(::Integer) }
  def size; end

  sig { params(ref: T.any(::Integer, ::PDF::Reader::Reference)).returns(T::Boolean) }
  def stream?(ref); end

  sig { returns(T.untyped) }
  def to_a; end

  sig { returns(::String) }
  def to_s; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def trailer; end

  def value?(*args, **_arg1, &blk); end

  sig { returns(T.untyped) }
  def values; end

  sig { params(ids: T.untyped).returns(T.untyped) }
  def values_at(*ids); end

  private

  sig do
    params(
      ref: ::PDF::Reader::Reference,
      obj: T.untyped
    ).returns(T.nilable(T.any(::Numeric, ::PDF::Reader::Reference, ::PDF::Reader::Stream, ::PDF::Reader::Token, ::String, ::Symbol, T::Array[T.untyped], T::Hash[T.untyped, T.untyped])))
  end
  def decrypt(ref, obj); end

  sig do
    params(
      key: T.untyped,
      seen: T::Hash[::Integer, T.untyped]
    ).returns(T.nilable(T.any(::Numeric, ::PDF::Reader::Reference, ::PDF::Reader::Stream, ::PDF::Reader::Token, ::String, ::Symbol, T::Array[T.untyped], T::Hash[T.untyped, T.untyped])))
  end
  def deref_internal!(key, seen); end

  sig { params(input: T.any(::IO, ::String, ::StringIO, ::Tempfile)).returns(T.any(::IO, ::StringIO, ::Tempfile)) }
  def extract_io_from(input); end

  sig do
    params(
      key: ::PDF::Reader::Reference
    ).returns(T.nilable(T.any(::Numeric, ::PDF::Reader::Reference, ::PDF::Reader::Stream, ::PDF::Reader::Token, ::String, ::Symbol, T::Array[T.untyped], T::Hash[T.untyped, T.untyped])))
  end
  def fetch_object(key); end

  sig do
    params(
      key: ::PDF::Reader::Reference
    ).returns(T.nilable(T.any(::Numeric, ::PDF::Reader::Reference, ::PDF::Reader::Stream, ::PDF::Reader::Token, ::String, ::Symbol, T::Array[T.untyped], T::Hash[T.untyped, T.untyped])))
  end
  def fetch_object_stream(key); end

  sig do
    params(
      obj: T.any(::PDF::Reader::Reference, T::Hash[::Symbol, T.untyped])
    ).returns(T::Array[T.any(::PDF::Reader::Reference, T::Hash[::Symbol, T.untyped])])
  end
  def get_page_objects(obj); end

  sig { params(offset: ::Integer).returns(::PDF::Reader::Buffer) }
  def new_buffer(offset = T.unsafe(nil)); end

  sig { returns(T::Hash[::PDF::Reader::Reference, ::PDF::Reader::ObjectStream]) }
  def object_streams; end

  sig { params(input: ::String).returns(::String) }
  def read_as_binary(input); end

  sig { returns(::Float) }
  def read_version; end

  sig { returns(PDF::Reader::XRef[::PDF::Reader::Reference]) }
  def xref; end
end

class PDF::Reader::ObjectStream
  sig { params(stream: ::PDF::Reader::Stream).void }
  def initialize(stream); end

  sig do
    params(
      objid: ::Integer
    ).returns(T.nilable(T.any(::Numeric, ::PDF::Reader::Reference, ::PDF::Reader::Token, ::String, ::Symbol, T::Array[T.untyped], T::Hash[T.untyped, T.untyped])))
  end
  def [](objid); end

  sig { returns(::Integer) }
  def size; end

  private

  sig { returns(::PDF::Reader::Buffer) }
  def buffer; end

  sig { returns(::Integer) }
  def first; end

  sig { returns(T::Hash[::Integer, ::Integer]) }
  def offsets; end
end

class PDF::Reader::OverlappingRunsFilter
  class << self
    sig do
      params(
        sweep_line_status: T::Array[::PDF::Reader::TextRun],
        event_point: ::PDF::Reader::EventPoint
      ).returns(T::Boolean)
    end
    def detect_intersection(sweep_line_status, event_point); end

    sig { params(runs: T::Array[::PDF::Reader::TextRun]).returns(T::Array[::PDF::Reader::TextRun]) }
    def exclude_redundant_runs(runs); end
  end
end

PDF::Reader::OverlappingRunsFilter::OVERLAPPING_THRESHOLD = T.let(T.unsafe(nil), Float)

class PDF::Reader::Page
  extend ::Forwardable

  sig { params(objects: ::PDF::Reader::ObjectHash, pagenum: ::Integer, options: T::Hash[::Symbol, T.untyped]).void }
  def initialize(objects, pagenum, options = T.unsafe(nil)); end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def attributes; end

  sig { returns(T::Hash[::Symbol, T::Array[::Numeric]]) }
  def boxes; end

  sig { returns(T.any(::PDF::Reader::ObjectCache, T::Hash[T.untyped, T.untyped])) }
  def cache; end

  def color_spaces(*args, **_arg1, &block); end
  def fonts(*args, **_arg1, &block); end
  def graphic_states(*args, **_arg1, &block); end

  sig { returns(::Numeric) }
  def height; end

  sig { returns(::String) }
  def inspect; end

  sig { returns(::Integer) }
  def number; end

  sig { returns(::PDF::Reader::ObjectHash) }
  def objects; end

  sig { returns(::String) }
  def orientation; end

  sig { returns(T::Array[::Numeric]) }
  def origin; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def page_object; end

  def patterns(*args, **_arg1, &block); end
  def procedure_sets(*args, **_arg1, &block); end
  def properties(*args, **_arg1, &block); end

  sig { returns(::String) }
  def raw_content; end

  sig { returns(T::Hash[::Symbol, ::PDF::Reader::Rectangle]) }
  def rectangles; end

  sig { returns(::Integer) }
  def rotate; end

  sig { params(opts: T::Hash[::Symbol, T.untyped]).returns(T::Array[::PDF::Reader::TextRun]) }
  def runs(opts = T.unsafe(nil)); end

  def shadings(*args, **_arg1, &block); end

  sig { params(opts: T::Hash[::Symbol, T.untyped]).returns(::String) }
  def text(opts = T.unsafe(nil)); end

  def to_s(*args, **_arg1, &blk); end

  sig { params(receivers: T.untyped).returns(T.untyped) }
  def walk(*receivers); end

  sig { returns(::Numeric) }
  def width; end

  def xobjects(*args, **_arg1, &block); end

  private

  sig { params(origin: T.untyped, seen: T::Set[::Integer]).returns(T.untyped) }
  def ancestors(origin = T.unsafe(nil), seen = T.unsafe(nil)); end

  sig { params(receivers: T::Array[::Object], name: ::Symbol, params: T::Array[T.untyped]).void }
  def callback(receivers, name, params = T.unsafe(nil)); end

  sig { params(receivers: T::Array[T.untyped], instructions: ::String).void }
  def content_stream(receivers, instructions); end

  sig { returns(T.untyped) }
  def page_with_ancestors; end

  sig { returns(::PDF::Reader::Resources) }
  def resources; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def root; end

  sig { params(obj: T::Hash[::Symbol, T.untyped]).returns(T::Hash[::Symbol, T.untyped]) }
  def select_inheritable(obj); end
end

class PDF::Reader::PageLayout
  sig do
    params(
      runs: T::Array[::PDF::Reader::TextRun],
      mediabox: T.any(::PDF::Reader::Rectangle, T::Array[::Numeric])
    ).void
  end
  def initialize(runs, mediabox); end

  sig { returns(::String) }
  def to_s; end

  private

  sig { returns(T.untyped) }
  def col_count; end

  sig { returns(T.untyped) }
  def col_multiplier; end

  sig { params(rows: T.untyped).returns(T.untyped) }
  def interesting_rows(rows); end

  sig { params(haystack: T.untyped, needle: T.untyped, index: T.untyped).returns(T.untyped) }
  def local_string_insert(haystack, needle, index); end

  sig { params(collection: T.untyped).returns(T.untyped) }
  def mean(collection); end

  sig { params(collection: T.untyped).returns(T.untyped) }
  def median(collection); end

  sig { returns(::Numeric) }
  def page_height; end

  sig { returns(::Numeric) }
  def page_width; end

  sig { params(mediabox: T.untyped).returns(T.untyped) }
  def process_mediabox(mediabox); end

  sig { returns(T.untyped) }
  def row_count; end

  sig { returns(T.untyped) }
  def row_multiplier; end
end

PDF::Reader::PageLayout::DEFAULT_FONT_SIZE = T.let(T.unsafe(nil), Integer)

class PDF::Reader::PageState
  sig { params(page: T.untyped).void }
  def initialize(page); end

  def begin_text_object; end
  def clone_state; end
  def concatenate_matrix(a, b, c, d, e, f); end
  def ctm_transform(x, y); end
  def current_font; end
  def end_text_object; end
  def find_color_space(label); end
  def find_font(label); end
  def find_xobject(label); end
  def font_size; end
  def invoke_xobject(label); end
  def move_text_position(x, y); end
  def move_text_position_and_set_leading(x, y); end
  def move_to_next_line_and_show_text(str); end
  def move_to_start_of_next_line; end
  def process_glyph_displacement(w0, tj, word_boundary); end

  sig { returns(T.untyped) }
  def restore_graphics_state; end

  sig { returns(T.untyped) }
  def save_graphics_state; end

  def set_character_spacing(char_spacing); end
  def set_horizontal_text_scaling(h_scaling); end
  def set_spacing_next_line_show_text(aw, ac, string); end
  def set_text_font_and_size(label, size); end
  def set_text_leading(leading); end
  def set_text_matrix_and_text_line_matrix(a, b, c, d, e, f); end
  def set_text_rendering_mode(mode); end
  def set_text_rise(rise); end
  def set_word_spacing(word_spacing); end
  def show_text_with_positioning(params); end
  def stack_depth; end
  def trm_transform(x, y); end

  private

  def build_fonts(raw_fonts); end
  def ctm; end
  def identity_matrix; end
  def state; end
  def text_rendering_matrix; end
end

PDF::Reader::PageState::DEFAULT_GRAPHICS_STATE = T.let(T.unsafe(nil), Hash)

class PDF::Reader::PageTextReceiver
  extend ::Forwardable

  def begin_text_object(*args, **_arg1, &block); end
  def concatenate_matrix(*args, **_arg1, &block); end
  def content; end
  def end_text_object(*args, **_arg1, &block); end
  def font_size(*args, **_arg1, &block); end
  def invoke_xobject(label); end
  def move_text_position(*args, **_arg1, &block); end
  def move_text_position_and_set_leading(*args, **_arg1, &block); end
  def move_to_next_line_and_show_text(str); end
  def move_to_start_of_next_line(*args, **_arg1, &block); end

  sig { returns(T.untyped) }
  def options; end

  def page=(page); end
  def restore_graphics_state(*args, **_arg1, &block); end
  def runs(opts = T.unsafe(nil)); end
  def save_graphics_state(*args, **_arg1, &block); end
  def set_character_spacing(*args, **_arg1, &block); end
  def set_horizontal_text_scaling(*args, **_arg1, &block); end
  def set_spacing_next_line_show_text(aw, ac, string); end
  def set_text_font_and_size(*args, **_arg1, &block); end
  def set_text_leading(*args, **_arg1, &block); end
  def set_text_matrix_and_text_line_matrix(*args, **_arg1, &block); end
  def set_text_rendering_mode(*args, **_arg1, &block); end
  def set_text_rise(*args, **_arg1, &block); end
  def set_word_spacing(*args, **_arg1, &block); end
  def show_text(string); end
  def show_text_with_positioning(params); end

  sig { returns(T.untyped) }
  def state; end

  private

  def apply_rotation(x, y); end
  def group_chars_into_runs(chars); end
  def internal_show_text(string); end
  def merge_runs(runs); end
end

PDF::Reader::PageTextReceiver::SPACE = T.let(T.unsafe(nil), String)
class PDF::Reader::PagesStrategy; end
PDF::Reader::PagesStrategy::OPERATORS = T.let(T.unsafe(nil), Hash)

class PDF::Reader::Parser
  sig { params(buffer: ::PDF::Reader::Buffer, objects: T.nilable(::PDF::Reader::ObjectHash)).void }
  def initialize(buffer, objects = T.unsafe(nil)); end

  sig do
    params(
      id: ::Integer,
      gen: ::Integer
    ).returns(T.nilable(T.any(::Numeric, ::PDF::Reader::Reference, ::PDF::Reader::Stream, ::PDF::Reader::Token, ::String, ::Symbol, T::Array[T.untyped], T::Hash[T.untyped, T.untyped])))
  end
  def object(id, gen); end

  sig do
    params(
      operators: T::Hash[T.any(::PDF::Reader::Token, ::String), ::Symbol]
    ).returns(T.nilable(T.any(::Numeric, ::PDF::Reader::Reference, ::PDF::Reader::Token, ::String, ::Symbol, T::Array[T.untyped], T::Hash[T.untyped, T.untyped])))
  end
  def parse_token(operators = T.unsafe(nil)); end

  private

  sig { returns(T::Array[T.untyped]) }
  def array; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def dictionary; end

  sig { returns(::String) }
  def hex_string; end

  sig { returns(::Symbol) }
  def pdf_name; end

  sig { params(dict: T::Hash[::Symbol, T.untyped]).returns(::PDF::Reader::Stream) }
  def stream(dict); end

  sig { returns(::String) }
  def string; end
end

PDF::Reader::Parser::MAPPING = T.let(T.unsafe(nil), Hash)
PDF::Reader::Parser::STRATEGIES = T.let(T.unsafe(nil), Hash)
PDF::Reader::Parser::TOKEN_STRATEGY = T.let(T.unsafe(nil), Proc)

class PDF::Reader::Point
  sig { params(x: ::Numeric, y: ::Numeric).void }
  def initialize(x, y); end

  sig { params(other: ::PDF::Reader::Point).returns(T::Boolean) }
  def ==(other); end

  sig { returns(::Numeric) }
  def x; end

  sig { returns(::Numeric) }
  def y; end
end

class PDF::Reader::PrintReceiver
  sig { params(methodname: ::Symbol, args: T.untyped).void }
  def method_missing(methodname, *args); end

  sig { params(meth: T.untyped).returns(T::Boolean) }
  def respond_to?(meth); end
end

class PDF::Reader::Rc4SecurityHandler
  sig { params(key: ::String).void }
  def initialize(key); end

  sig { params(buf: ::String, ref: ::PDF::Reader::Reference).returns(::String) }
  def decrypt(buf, ref); end
end

class PDF::Reader::Rectangle
  sig { params(x1: ::Numeric, y1: ::Numeric, x2: ::Numeric, y2: ::Numeric).void }
  def initialize(x1, y1, x2, y2); end

  sig { params(other: ::PDF::Reader::Rectangle).returns(T::Boolean) }
  def ==(other); end

  sig { params(degrees: ::Integer).void }
  def apply_rotation(degrees); end

  sig { returns(::PDF::Reader::Point) }
  def bottom_left; end

  sig { returns(::PDF::Reader::Point) }
  def bottom_right; end

  sig { params(point: ::PDF::Reader::Point).returns(T::Boolean) }
  def contains?(point); end

  sig { returns(::Numeric) }
  def height; end

  sig { returns(T::Array[::Numeric]) }
  def to_a; end

  sig { returns(::PDF::Reader::Point) }
  def top_left; end

  sig { returns(::PDF::Reader::Point) }
  def top_right; end

  sig { returns(::Numeric) }
  def width; end

  private

  sig { params(x1: ::Numeric, y1: ::Numeric, x2: ::Numeric, y2: ::Numeric).void }
  def set_corners(x1, y1, x2, y2); end

  class << self
    sig { params(arr: T::Array[::Numeric]).returns(::PDF::Reader::Rectangle) }
    def from_array(arr); end
  end
end

class PDF::Reader::Reference
  sig { params(id: ::Integer, gen: ::Integer).void }
  def initialize(id, gen); end

  sig { params(obj: ::Object).returns(T::Boolean) }
  def ==(obj); end

  def eql?(*args, **_arg1, &blk); end

  sig { returns(::Integer) }
  def gen; end

  sig { returns(::Integer) }
  def hash; end

  sig { returns(::Integer) }
  def id; end

  sig { returns(T::Array[::PDF::Reader::Reference]) }
  def to_a; end

  sig { returns(::Integer) }
  def to_i; end
end

class PDF::Reader::RegisterReceiver
  sig { void }
  def initialize; end

  sig { params(methodname: ::Symbol).returns(T::Array[T::Hash[::Symbol, T.untyped]]) }
  def all(methodname); end

  sig { params(methodname: ::Symbol).returns(T::Array[T::Array[T.untyped]]) }
  def all_args(methodname); end

  sig { returns(T::Array[T::Hash[::Symbol, T.untyped]]) }
  def callbacks; end

  def callbacks=(_arg0); end

  sig { params(methodname: ::Symbol).returns(::Integer) }
  def count(methodname); end

  sig { params(methodname: ::Symbol).returns(T.nilable(T::Hash[::Symbol, T.untyped])) }
  def final_occurance_of(methodname); end

  sig { params(methodname: ::Symbol).returns(T.nilable(T::Hash[::Symbol, T.untyped])) }
  def first_occurance_of(methodname); end

  sig { params(methodname: ::Symbol, args: T.untyped).void }
  def method_missing(methodname, *args); end

  sig { params(meth: T.untyped).returns(T::Boolean) }
  def respond_to?(meth); end

  sig { params(methods: ::Symbol).returns(T.nilable(T::Array[T::Hash[::Symbol, T.untyped]])) }
  def series(*methods); end
end

class PDF::Reader::Resources
  sig { params(objects: ::PDF::Reader::ObjectHash, resources: T::Hash[T.untyped, T.untyped]).void }
  def initialize(objects, resources); end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def color_spaces; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def fonts; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def graphic_states; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def patterns; end

  sig { returns(T::Array[::Symbol]) }
  def procedure_sets; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def properties; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def shadings; end

  sig { returns(T::Hash[::Symbol, ::PDF::Reader::Stream]) }
  def xobjects; end
end

class PDF::Reader::SecurityHandlerFactory
  class << self
    sig do
      params(
        encrypt: T::Hash[::Symbol, T.untyped],
        doc_id: T.nilable(T::Array[T.untyped]),
        password: T.nilable(::String)
      ).returns(T.any(::PDF::Reader::AesV2SecurityHandler, ::PDF::Reader::AesV3SecurityHandler, ::PDF::Reader::NullSecurityHandler, ::PDF::Reader::Rc4SecurityHandler, ::PDF::Reader::UnimplementedSecurityHandler))
    end
    def build(encrypt, doc_id, password); end

    sig do
      params(
        encrypt: T::Hash[::Symbol, T.untyped],
        doc_id: T::Array[T.untyped],
        password: ::String
      ).returns(T.any(::PDF::Reader::AesV2SecurityHandler, ::PDF::Reader::Rc4SecurityHandler))
    end
    def build_standard_handler(encrypt, doc_id, password); end

    sig do
      params(
        encrypt: T::Hash[::Symbol, T.untyped],
        doc_id: T::Array[T.untyped],
        password: ::String
      ).returns(::PDF::Reader::AesV3SecurityHandler)
    end
    def build_v5_handler(encrypt, doc_id, password); end

    sig { params(encrypt: T::Hash[::Symbol, T.untyped]).returns(T::Boolean) }
    def standard?(encrypt); end

    sig { params(encrypt: T::Hash[::Symbol, T.untyped]).returns(T.untyped) }
    def standard_v5?(encrypt); end
  end
end

class PDF::Reader::StandardKeyBuilder
  sig { params(opts: T::Hash[::Symbol, T.untyped]).void }
  def initialize(opts = T.unsafe(nil)); end

  sig { params(pass: ::String).returns(::String) }
  def key(pass = T.unsafe(nil)); end

  private

  sig { params(pass: ::String).returns(T.nilable(::String)) }
  def auth_owner_pass(pass); end

  sig { params(pass: ::String).returns(T.nilable(::String)) }
  def auth_user_pass(pass); end

  sig { params(user_pass: ::String).returns(::String) }
  def make_file_key(user_pass); end

  sig { params(p: T.nilable(::String)).returns(::String) }
  def pad_pass(p = T.unsafe(nil)); end

  sig { params(buf: ::String, int: ::Integer).returns(::String) }
  def xor_each_byte(buf, int); end
end

PDF::Reader::StandardKeyBuilder::PassPadBytes = T.let(T.unsafe(nil), Array)

class PDF::Reader::Stream
  sig { params(hash: T::Hash[::Symbol, T.untyped], data: ::String).void }
  def initialize(hash, data); end

  sig { returns(::String) }
  def data; end

  def data=(_arg0); end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def hash; end

  def hash=(_arg0); end

  sig { returns(::String) }
  def unfiltered_data; end
end

class PDF::Reader::SynchronizedCache
  sig { void }
  def initialize; end

  sig { params(key: ::Object).returns(T.untyped) }
  def [](key); end

  sig { params(key: ::Object, value: T.nilable(::Object)).returns(T.untyped) }
  def []=(key, value); end
end

class PDF::Reader::TextRun
  include ::Comparable

  sig { params(x: ::Numeric, y: ::Numeric, width: ::Numeric, font_size: ::Numeric, text: ::String).void }
  def initialize(x, y, width, font_size, text); end

  sig { params(other: ::PDF::Reader::TextRun).returns(::PDF::Reader::TextRun) }
  def +(other); end

  sig { params(other: ::PDF::Reader::Point).returns(::Numeric) }
  def <=>(other); end

  sig { returns(::Numeric) }
  def endx; end

  sig { returns(::Numeric) }
  def endy; end

  sig { returns(::Numeric) }
  def font_size; end

  sig { returns(::String) }
  def inspect; end

  sig { params(other_run: ::PDF::Reader::TextRun).returns(T::Boolean) }
  def intersect?(other_run); end

  sig { params(other_run: ::PDF::Reader::TextRun).returns(::Numeric) }
  def intersection_area_percent(other_run); end

  sig { returns(::Numeric) }
  def mean_character_width; end

  sig { params(other: ::PDF::Reader::TextRun).returns(T::Boolean) }
  def mergable?(other); end

  sig { returns(::PDF::Reader::Point) }
  def origin; end

  sig { returns(::String) }
  def text; end

  def to_s(*args, **_arg1, &blk); end

  sig { returns(::Numeric) }
  def width; end

  sig { returns(::Numeric) }
  def x; end

  sig { returns(::Numeric) }
  def y; end

  private

  sig { returns(::Numeric) }
  def area; end

  sig { returns(::Float) }
  def character_count; end

  sig { returns(T::Range[::Numeric]) }
  def mergable_range; end
end

class PDF::Reader::Token < ::String
  sig { params(val: T.untyped).void }
  def initialize(val); end
end

class PDF::Reader::TransformationMatrix
  sig { params(a: ::Numeric, b: ::Numeric, c: ::Numeric, d: ::Numeric, e: ::Numeric, f: ::Numeric).void }
  def initialize(a, b, c, d, e, f); end

  sig { returns(::Numeric) }
  def a; end

  sig { returns(::Numeric) }
  def b; end

  sig { returns(::Numeric) }
  def c; end

  sig { returns(::Numeric) }
  def d; end

  sig { returns(::Numeric) }
  def e; end

  sig { returns(::Numeric) }
  def f; end

  sig { params(e2: ::Numeric).void }
  def horizontal_displacement_multiply!(e2); end

  sig { returns(::String) }
  def inspect; end

  sig do
    params(
      a: ::Numeric,
      b: ::Numeric,
      c: ::Numeric,
      d: ::Numeric,
      e: ::Numeric,
      f: ::Numeric
    ).returns(::PDF::Reader::TransformationMatrix)
  end
  def multiply!(a, b, c, d, e, f); end

  sig { returns([::Numeric]) }
  def to_a; end

  private

  sig { params(a2: ::Numeric, b2: ::Numeric, c2: ::Numeric, d2: ::Numeric, e2: ::Numeric, f2: ::Numeric).void }
  def faster_multiply!(a2, b2, c2, d2, e2, f2); end

  sig { params(a2: ::Numeric, b2: ::Numeric, c2: ::Numeric, d2: ::Numeric, e2: ::Numeric, f2: ::Numeric).void }
  def horizontal_displacement_multiply_reversed!(a2, b2, c2, d2, e2, f2); end

  sig { params(a2: ::Numeric, b2: ::Numeric, c2: ::Numeric, d2: ::Numeric, e2: ::Numeric, f2: ::Numeric).void }
  def regular_multiply!(a2, b2, c2, d2, e2, f2); end

  sig { params(a2: ::Numeric, b2: ::Numeric, c2: ::Numeric, d2: ::Numeric, e2: ::Numeric, f2: ::Numeric).void }
  def xy_scaling_multiply!(a2, b2, c2, d2, e2, f2); end

  sig { params(a2: ::Numeric, b2: ::Numeric, c2: ::Numeric, d2: ::Numeric, e2: ::Numeric, f2: ::Numeric).void }
  def xy_scaling_multiply_reversed!(a2, b2, c2, d2, e2, f2); end
end

class PDF::Reader::TypeCheck
  class << self
    sig { params(obj: T.untyped).returns(::Integer) }
    def cast_to_int!(obj); end

    sig { params(obj: T.untyped).returns(::Numeric) }
    def cast_to_numeric!(obj); end

    sig { params(obj: T.untyped).returns(T::Hash[::Symbol, T.untyped]) }
    def cast_to_pdf_dict!(obj); end

    sig { params(obj: T.untyped).returns(T::Hash[::Symbol, ::PDF::Reader::Stream]) }
    def cast_to_pdf_dict_with_stream_values!(obj); end

    sig { params(string: T.untyped).returns(::String) }
    def cast_to_string!(string); end

    sig { params(obj: T.untyped).returns(::Symbol) }
    def cast_to_symbol(obj); end

    sig { params(obj: T.untyped).returns(::Symbol) }
    def cast_to_symbol!(obj); end
  end
end

class PDF::Reader::UnimplementedSecurityHandler
  sig { params(buf: ::String, ref: ::PDF::Reader::Reference).returns(::String) }
  def decrypt(buf, ref); end

  class << self
    sig { params(encrypt: T::Hash[::Symbol, T.untyped]).returns(T::Boolean) }
    def supports?(encrypt); end
  end
end

class PDF::Reader::UnsupportedFeatureError < ::RuntimeError; end

class PDF::Reader::ValidatingReceiver
  sig { params(wrapped: T.untyped).void }
  def initialize(wrapped); end

  sig { params(args: T.untyped).void }
  def begin_inline_image(*args); end

  sig { params(args: T.untyped).void }
  def begin_inline_image_data(*args); end

  sig { params(args: T.untyped).void }
  def begin_text_object(*args); end

  sig { params(args: T.untyped).void }
  def concatenate_matrix(*args); end

  sig { params(args: T.untyped).void }
  def end_inline_image(*args); end

  sig { params(args: T.untyped).void }
  def end_text_object(*args); end

  sig { params(args: T.untyped).void }
  def invoke_xobject(*args); end

  sig { params(methodname: ::Symbol, args: T.untyped).void }
  def method_missing(methodname, *args); end

  sig { params(args: T.untyped).void }
  def move_text_position(*args); end

  sig { params(args: T.untyped).void }
  def move_text_position_and_set_leading(*args); end

  sig { params(args: T.untyped).void }
  def move_to_next_line_and_show_text(*args); end

  sig { params(args: T.untyped).void }
  def move_to_start_of_next_line(*args); end

  sig { params(page: ::PDF::Reader::Page).void }
  def page=(page); end

  sig { params(meth: T.untyped).returns(T::Boolean) }
  def respond_to?(meth); end

  sig { params(args: T.untyped).void }
  def restore_graphics_state(*args); end

  sig { params(args: T.untyped).void }
  def save_graphics_state(*args); end

  sig { params(args: T.untyped).void }
  def set_character_spacing(*args); end

  sig { params(args: T.untyped).void }
  def set_horizontal_text_scaling(*args); end

  sig { params(args: T.untyped).void }
  def set_spacing_next_line_show_text(*args); end

  sig { params(args: T.untyped).void }
  def set_text_font_and_size(*args); end

  sig { params(args: T.untyped).void }
  def set_text_leading(*args); end

  sig { params(args: T.untyped).void }
  def set_text_matrix_and_text_line_matrix(*args); end

  sig { params(args: T.untyped).void }
  def set_text_rendering_mode(*args); end

  sig { params(args: T.untyped).void }
  def set_text_rise(*args); end

  sig { params(args: T.untyped).void }
  def set_word_spacing(*args); end

  sig { params(args: T.untyped).void }
  def show_text(*args); end

  sig { params(args: T.untyped).void }
  def show_text_with_positioning(*args); end

  private

  sig { params(methodname: T.untyped, args: T.untyped).void }
  def call_wrapped(methodname, *args); end
end

module PDF::Reader::WidthCalculator; end

class PDF::Reader::WidthCalculator::BuiltIn
  sig { params(font: ::PDF::Reader::Font).void }
  def initialize(font); end

  sig { params(code_point: T.nilable(::Integer)).returns(::Numeric) }
  def glyph_width(code_point); end

  private

  sig { params(code_point: ::Integer).returns(T::Boolean) }
  def control_character?(code_point); end

  sig { params(font_name: T.nilable(::Symbol)).returns(::String) }
  def extract_basefont(font_name); end
end

PDF::Reader::WidthCalculator::BuiltIn::BUILTINS = T.let(T.unsafe(nil), Array)

class PDF::Reader::WidthCalculator::Composite
  sig { params(font: ::PDF::Reader::Font).void }
  def initialize(font); end

  sig { params(code_point: T.nilable(::Integer)).returns(::Numeric) }
  def glyph_width(code_point); end
end

class PDF::Reader::WidthCalculator::TrueType
  sig { params(font: ::PDF::Reader::Font).void }
  def initialize(font); end

  sig { params(code_point: T.nilable(::Integer)).returns(::Numeric) }
  def glyph_width(code_point); end

  private

  sig { params(code_point: ::Integer).returns(T.nilable(::Numeric)) }
  def glyph_width_from_descriptor(code_point); end

  sig { params(code_point: ::Integer).returns(T.nilable(::Numeric)) }
  def glyph_width_from_font(code_point); end
end

class PDF::Reader::WidthCalculator::TypeOneOrThree
  sig { params(font: ::PDF::Reader::Font).void }
  def initialize(font); end

  sig { params(code_point: T.nilable(::Integer)).returns(::Numeric) }
  def glyph_width(code_point); end
end

class PDF::Reader::WidthCalculator::TypeZero
  sig { params(font: ::PDF::Reader::Font).void }
  def initialize(font); end

  sig { params(code_point: T.nilable(::Integer)).returns(::Numeric) }
  def glyph_width(code_point); end
end

class PDF::Reader::XRef
  extend T::Generic
  include ::Enumerable

  Elem = type_member

  sig { params(io: T.any(::IO, ::StringIO, ::Tempfile)).void }
  def initialize(io); end

  sig { params(ref: T.untyped).returns(T.untyped) }
  def [](ref); end

  sig { override.params(block: T.proc.params(arg0: ::PDF::Reader::Reference).returns(T.untyped)).void }
  def each(&block); end

  sig { returns(T.untyped) }
  def size; end

  sig { returns(T::Hash[::Symbol, T.untyped]) }
  def trailer; end

  private

  sig { params(io: T.any(::IO, ::StringIO, ::Tempfile)).returns(T.nilable(::Integer)) }
  def calc_junk_offset(io); end

  sig { params(offset: T.nilable(::Integer)).returns(T::Hash[::Symbol, T.untyped]) }
  def load_offsets(offset = T.unsafe(nil)); end

  sig { params(stream: ::PDF::Reader::Stream).returns(T::Hash[::Symbol, T.untyped]) }
  def load_xref_stream(stream); end

  sig { params(buf: ::PDF::Reader::Buffer).returns(T::Hash[::Symbol, T.untyped]) }
  def load_xref_table(buf); end

  sig { params(offset: ::Integer).returns(::PDF::Reader::Buffer) }
  def new_buffer(offset = T.unsafe(nil)); end

  sig do
    params(
      id: ::Integer,
      gen: ::Integer,
      offset: T.any(::Integer, ::PDF::Reader::Reference)
    ).returns(T.any(::Integer, ::PDF::Reader::Reference))
  end
  def store(id, gen, offset); end

  sig { params(bytes: T.nilable(::String)).returns(::Integer) }
  def unpack_bytes(bytes); end
end

class PDF::Reader::ZeroWidthRunsFilter
  class << self
    sig { params(runs: T::Array[::PDF::Reader::TextRun]).returns(T::Array[::PDF::Reader::TextRun]) }
    def exclude_zero_width_runs(runs); end
  end
end
