/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QtScreenDevice;
import gnu.java.awt.peer.qt.QtToolkit;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.Locale;

public class QtGraphicsEnvironment
extends GraphicsEnvironment {
    QtToolkit toolkit;
    GraphicsDevice[] screens;

    public Font[] getAllFonts() {
        String[] fonts = this.getAvailableFontFamilyNames();
        Font[] fontObjs = new Font[fonts.length];
        int i = 0;
        while (i < fonts.length) {
            fontObjs[i] = new Font(fonts[i], 0, 12);
            ++i;
        }
        return fontObjs;
    }

    public String[] getAvailableFontFamilyNames() {
        return this.toolkit.getFontList();
    }

    public String[] getAvailableFontFamilyNames(Locale l) {
        return this.getAvailableFontFamilyNames();
    }

    public GraphicsDevice getDefaultScreenDevice() {
        return this.screens[this.toolkit.defaultScreen()];
    }

    public Graphics2D createGraphics(BufferedImage image) {
        return (Graphics2D)image.getGraphics();
    }

    public GraphicsDevice[] getScreenDevices() {
        return this.screens;
    }

    public QtToolkit getToolkit() {
        return this.toolkit;
    }

    public QtGraphicsEnvironment(QtToolkit tk) {
        this.toolkit = tk;
        int n = this.toolkit.numScreens();
        this.screens = new GraphicsDevice[n];
        int i = 0;
        while (i < n) {
            this.screens[i] = new QtScreenDevice(i);
            ++i;
        }
    }
}

