/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class CharsetDecoder {
    private static final int STATE_RESET = 0;
    private static final int STATE_CODING = 1;
    private static final int STATE_END = 2;
    private static final int STATE_FLUSHED = 3;
    private static final String DEFAULT_REPLACEMENT = "\ufffd";
    private final Charset charset;
    private final float averageCharsPerByte;
    private final float maxCharsPerByte;
    private String replacement;
    private int state;
    private CodingErrorAction malformedInputAction;
    private CodingErrorAction unmappableCharacterAction;

    public final float averageCharsPerByte() {
        return this.averageCharsPerByte;
    }

    public final Charset charset() {
        return this.charset;
    }

    public final CharBuffer decode(ByteBuffer in) throws CharacterCodingException {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        int remaining = in.remaining();
        int n = (int)((float)remaining * this.maxCharsPerByte());
        CharBuffer out = CharBuffer.allocate(n);
        if (remaining == 0) {
            this.state = 3;
            return out;
        }
        CoderResult cr = this.decode(in, out, true);
        if (cr.isError()) {
            cr.throwException();
        }
        if ((cr = this.flush(out)).isError()) {
            cr.throwException();
        }
        this.reset();
        out.flip();
        char[] resized = new char[out.remaining()];
        out.get(resized);
        return CharBuffer.wrap(resized);
    }

    public final CoderResult decode(ByteBuffer in, CharBuffer out, boolean endOfInput) {
        int newState = endOfInput + 1;
        if (!(this.state == 0 || this.state == 1 || endOfInput && this.state == 2)) {
            throw new IllegalStateException();
        }
        this.state = newState;
        while (true) {
            CodingErrorAction action;
            CoderResult cr;
            try {
                cr = this.decodeLoop(in, out);
            }
            catch (RuntimeException e) {
                throw new CoderMalfunctionError(e);
            }
            if (cr.isOverflow()) {
                return cr;
            }
            if (cr.isUnderflow()) {
                if (endOfInput && in.hasRemaining()) {
                    cr = CoderResult.malformedForLength(in.remaining());
                } else {
                    return cr;
                }
            }
            CodingErrorAction codingErrorAction = action = cr.isMalformed() ? this.malformedInputAction : this.unmappableCharacterAction;
            if (action == CodingErrorAction.REPORT) {
                return cr;
            }
            if (action == CodingErrorAction.REPLACE) {
                if (out.remaining() < this.replacement.length()) {
                    return CoderResult.OVERFLOW;
                }
                out.put(this.replacement);
            }
            in.position(in.position() + cr.length());
        }
    }

    protected abstract CoderResult decodeLoop(ByteBuffer var1, CharBuffer var2);

    public Charset detectedCharset() {
        throw new UnsupportedOperationException();
    }

    public final CoderResult flush(CharBuffer out) {
        if (this.state != 0 && this.state != 2) {
            throw new IllegalStateException();
        }
        this.state = 3;
        return this.implFlush(out);
    }

    protected CoderResult implFlush(CharBuffer out) {
        return CoderResult.UNDERFLOW;
    }

    public final CharsetDecoder onMalformedInput(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.malformedInputAction = newAction;
        this.implOnMalformedInput(newAction);
        return this;
    }

    protected void implOnMalformedInput(CodingErrorAction newAction) {
    }

    protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
    }

    protected void implReplaceWith(String newReplacement) {
    }

    protected void implReset() {
    }

    public boolean isAutoDetecting() {
        return false;
    }

    public boolean isCharsetDetected() {
        throw new UnsupportedOperationException();
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final float maxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public final CharsetDecoder onUnmappableCharacter(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.unmappableCharacterAction = newAction;
        this.implOnUnmappableCharacter(newAction);
        return this;
    }

    public final String replacement() {
        return this.replacement;
    }

    public final CharsetDecoder replaceWith(String newReplacement) {
        if (newReplacement == null) {
            throw new IllegalArgumentException("Null replacement");
        }
        if (newReplacement.length() == 0) {
            throw new IllegalArgumentException("Empty replacement");
        }
        this.replacement = newReplacement;
        this.implReplaceWith(newReplacement);
        return this;
    }

    public final CharsetDecoder reset() {
        this.state = 0;
        this.implReset();
        return this;
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    private final /* synthetic */ void this() {
        this.state = 0;
        this.malformedInputAction = CodingErrorAction.REPORT;
        this.unmappableCharacterAction = CodingErrorAction.REPORT;
    }

    private CharsetDecoder(Charset cs, float averageCharsPerByte, float maxCharsPerByte, String replacement) {
        this.this();
        if (averageCharsPerByte <= 0.0f) {
            throw new IllegalArgumentException("Non-positive averageCharsPerByte");
        }
        if (maxCharsPerByte <= 0.0f) {
            throw new IllegalArgumentException("Non-positive maxCharsPerByte");
        }
        this.charset = cs;
        this.averageCharsPerByte = averageCharsPerByte;
        this.maxCharsPerByte = maxCharsPerByte;
        this.replacement = replacement;
        this.implReplaceWith(replacement);
    }

    protected CharsetDecoder(Charset cs, float averageCharsPerByte, float maxCharsPerByte) {
        this(cs, averageCharsPerByte, maxCharsPerByte, DEFAULT_REPLACEMENT);
    }
}

