/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class AlgorithmParameters {
    private static final String ALGORITHM_PARAMETERS = "AlgorithmParameters";
    private AlgorithmParametersSpi paramSpi;
    private Provider provider;
    private String algorithm;

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static AlgorithmParameters getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        int i = 0;
        while (i < p.length) {
            try {
                return AlgorithmParameters.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static AlgorithmParameters getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return AlgorithmParameters.getInstance(algorithm, p);
    }

    public static AlgorithmParameters getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        try {
            return new AlgorithmParameters((AlgorithmParametersSpi)Engine.getInstance(ALGORITHM_PARAMETERS, algorithm, provider), provider, algorithm);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(algorithm);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        this.paramSpi.engineInit(paramSpec);
    }

    public final void init(byte[] params) throws IOException {
        this.paramSpi.engineInit(params);
    }

    public final void init(byte[] params, String format) throws IOException {
        this.paramSpi.engineInit(params, format);
    }

    public final AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        return this.paramSpi.engineGetParameterSpec(paramSpec);
    }

    public final byte[] getEncoded() throws IOException {
        return this.paramSpi.engineGetEncoded();
    }

    public final byte[] getEncoded(String format) throws IOException {
        return this.paramSpi.engineGetEncoded(format);
    }

    public final String toString() {
        return this.paramSpi.engineToString();
    }

    protected AlgorithmParameters(AlgorithmParametersSpi paramSpi, Provider provider, String algorithm) {
        this.paramSpi = paramSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }
}

