/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class QuantifiedExpression
extends Assignation {
    private int operator;

    public String getExpressionName() {
        return this.operator == 32 ? "some" : "every";
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.sequence = visitor.typeCheck(this.sequence, contextItemType);
        if (Literal.isEmptySequence(this.sequence)) {
            return Literal.makeLiteral(BooleanValue.get(this.operator != 32));
        }
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        this.sequence = ExpressionTool.unsorted(opt, this.sequence, false);
        SequenceType decl = this.getRequiredType();
        SequenceType sequenceType = SequenceType.makeSequenceType(decl.getPrimaryType(), 57344);
        RoleLocator role = new RoleLocator(3, this.getVariableQName(), 0);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, sequenceType, role, visitor.getStaticContext());
        ItemType actualItemType = this.sequence.getItemType(th);
        this.refineTypeInformation(actualItemType, 16384, null, this.sequence.getSpecialProperties(), visitor, this);
        this.action = visitor.typeCheck(this.action, contextItemType);
        XPathException err = TypeChecker.ebvError(this.action, visitor.getConfiguration().getTypeHierarchy());
        if (err != null) {
            err.setLocator(this);
            throw err;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e3;
        Expression e2;
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        this.sequence = visitor.optimize(this.sequence, contextItemType);
        this.action = visitor.optimize(this.action, contextItemType);
        Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.action, visitor, contextItemType);
        if (ebv != null) {
            this.action = ebv;
            this.adoptChildExpression(ebv);
        }
        PromotionOffer offer = new PromotionOffer(opt);
        offer.containingExpression = this;
        offer.action = 11;
        offer.bindingList = new Binding[]{this};
        this.action = this.doPromotion(this.action, offer);
        if (offer.containingExpression instanceof LetExpression) {
            offer.containingExpression = visitor.optimize(visitor.typeCheck(offer.containingExpression, contextItemType), contextItemType);
        }
        if ((e2 = offer.containingExpression) != this) {
            return e2;
        }
        if (visitor.isOptimizeForStreaming() && (e3 = visitor.getConfiguration().obtainOptimizer().optimizeQuantifiedExpressionForStreaming(this)) != this) {
            return visitor.optimize(e3, contextItemType);
        }
        return this;
    }

    public void checkForUpdatingSubexpressions() throws XPathException {
        this.sequence.checkForUpdatingSubexpressions();
        this.action.checkForUpdatingSubexpressions();
    }

    public boolean isUpdatingExpression() {
        return false;
    }

    public Expression copy() {
        QuantifiedExpression qe = new QuantifiedExpression();
        qe.setOperator(this.operator);
        qe.setVariableQName(this.variableName);
        qe.setRequiredType(this.requiredType);
        qe.setSequence(this.sequence.copy());
        Expression newAction = this.action.copy();
        qe.setAction(newAction);
        qe.variableName = this.variableName;
        qe.slotNumber = this.slotNumber;
        ExpressionTool.rebindVariableReferences(newAction, this, qe);
        return qe;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Item it;
        SequenceIterator<? extends Item> base = this.sequence.iterate(context);
        boolean some = this.operator == 32;
        int slot = this.getLocalSlotNumber();
        while ((it = base.next()) != null) {
            context.setLocalVariable(slot, it);
            if (some != this.action.effectiveBooleanValue(context)) continue;
            base.close();
            return some;
        }
        return !some;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public String toString() {
        return (this.operator == 32 ? "some" : "every") + " $" + this.getVariableEQName() + " in " + this.sequence.toString() + " satisfies " + ExpressionTool.parenthesize(this.action);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement(Token.tokens[this.operator]);
        out.emitAttribute("variable", this.getVariableName());
        out.startSubsidiaryElement("in");
        this.sequence.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("satisfies");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

