#! /usr/pkg/bin/perl
# -*- indent-tabs-mode: nil; -*-
# vim:ft=perl:et:sw=4
# $Id$

# Sympa - SYsteme de Multi-Postage Automatique
#
# Copyright (c) 1997, 1998, 1999 Institut Pasteur & Christophe Wolfhugel
# Copyright (c) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
# 2006, 2007, 2008, 2009, 2010, 2011 Comite Reseau des Universites
# Copyright (c) 2011, 2012, 2013, 2014, 2015, 2016, 2017 GIP RENATER
# Copyright 2017, 2018, 2019 The Sympa Community. See the AUTHORS.md file at
# the top-level directory of this distribution and at
# <https://github.com/sympa-community/sympa.git>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

use lib split(/:/, $ENV{SYMPALIB} || ''), '/usr/pkg/sympa/bin';
use strict;
use warnings;
use English qw(-no_match_vars);
use SOAP::Lite;

## Sympa API
use Conf;
use Sympa::DatabaseManager;
use Sympa::List;
use Sympa::Log;
use Sympa::Spool::Listmaster;
use Sympa::WWW::SOAP;
use Sympa::WWW::SOAP::Transport;

## Load sympa config
unless (Conf::load()) {
    printf STDERR
        "Unable to load sympa configuration, file %s or one of the vhost robot.conf files contain errors. Exiting\n",
        Conf::get_sympa_conf();
    exit 1;
}

# Open log
my $log = Sympa::Log->instance;
$log->{level} = $Conf::Conf{'log_level'};
$log->openlog(
    $Conf::Conf{'log_facility'} || $Conf::Conf{'syslog'},
    $Conf::Conf{'log_socket_type'},
    service => 'sympasoap'
);
$log->syslog('info', 'SympaSOAP started');

## We set the real UID with the effective UID value
## It is useful to allow execution of scripts like alias_manager
## that otherwise might loose the benefit of SetUID
$UID = $EUID;    ## UID
$GID = $EGID;    ## GID

unless (Sympa::DatabaseManager->instance) {
    $log->syslog('err', 'SympaSOAP requires a RDBMS to run');
}

## The process should not fork for sending mail
## Messages will be spooled instead
Sympa::Spool::Listmaster->instance->{use_bulk} = 1;

## Loading all Lists at startup, in order to increase execution speed

my $all_lists = Sympa::List::get_lists('*');

##############################################################################
#    Soap part
##############################################################################

Sympa::WWW::SOAP::Transport->new(
    cookie_expire => $Conf::Conf{'cookie_expire'})
    ->dispatch_with({'urn:sympasoap' => 'Sympa::WWW::SOAP'})->handle;

__END__

=encoding utf-8

=head1 NAME

sympa_soap_server, sympa_soap_server.fcgi - Sympa SOAP server

=head1 DESCRIPTION

Sympa SOAP server allows one to access Sympa service though SOAP.

To know details on Sympa SOAP server, see Sympa Administration Manual:
L<https://sympa-community.github.io/manual/customize/soap-api.html>.

=head1 HISTORY

Sympa SOAP server appeared on Sympa 4.0.

=cut
