/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.trie4j.bv.BytesRank0OnlySuccinctBitVector;

public class SBVIntMap<T>
implements Serializable {
    private int current;
    private Object[] values;
    private BytesRank0OnlySuccinctBitVector valueIndices = new BytesRank0OnlySuccinctBitVector();
    private static final long serialVersionUID = -4753279563025571408L;

    public SBVIntMap() {
        this.values = new Object[0];
        this.valueIndices = new BytesRank0OnlySuccinctBitVector();
    }

    public SBVIntMap(int initialCapacity) {
        this.values = new Object[0];
        this.valueIndices = new BytesRank0OnlySuccinctBitVector(initialCapacity);
    }

    public int size() {
        return this.valueIndices.size();
    }

    public int valuesSize() {
        return this.current;
    }

    public int addValue(T value) {
        this.valueIndices.append0();
        if (this.current >= this.values.length) {
            this.values = Arrays.copyOf(this.values, (int)((double)this.values.length * 1.2 + 1.0));
        }
        this.values[this.current] = value;
        ++this.current;
        return this.valueIndices.size();
    }

    public int addNone() {
        this.valueIndices.append1();
        return this.valueIndices.size();
    }

    public T get(int id) {
        if (!this.valueIndices.isZero(id)) {
            throw new NoSuchElementException("No element exists at " + id);
        }
        return (T)this.values[this.valueIndices.rank0(id) - 1];
    }

    public T getUnsafe(int id) {
        return (T)this.values[this.valueIndices.rank0(id) - 1];
    }

    public void set(int id, T value) {
        if (!this.valueIndices.isZero(id)) {
            throw new IllegalStateException("try to set value for invalid id.");
        }
        this.values[this.valueIndices.rank0((int)id) - 1] = value;
    }
}

