/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.FilterSpans;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public abstract class SpanPositionCheckQuery
extends SpanQuery
implements Cloneable {
    protected SpanQuery match;

    public SpanPositionCheckQuery(SpanQuery match) {
        this.match = Objects.requireNonNull(match);
    }

    public SpanQuery getMatch() {
        return this.match;
    }

    @Override
    public String getField() {
        return this.match.getField();
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.match.extractTerms(terms);
    }

    protected abstract FilterSpans.AcceptStatus acceptPosition(Spans var1) throws IOException;

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        Spans matchSpans = this.match.getSpans(context, acceptDocs, termContexts);
        return matchSpans == null ? null : new FilterSpans(matchSpans){

            @Override
            protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
                return SpanPositionCheckQuery.this.acceptPosition(candidate);
            }
        };
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanPositionCheckQuery clone = null;
        SpanQuery rewritten = (SpanQuery)this.match.rewrite(reader);
        if (rewritten != this.match) {
            clone = (SpanPositionCheckQuery)this.clone();
            clone.match = rewritten;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpanPositionCheckQuery spcq = (SpanPositionCheckQuery)o;
        return this.match.equals(spcq.match);
    }

    @Override
    public int hashCode() {
        return this.match.hashCode() ^ super.hashCode();
    }
}

