/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.omegat.core.machinetranslators.BaseCachedTranslate;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class YandexCloudTranslate
extends BaseCachedTranslate {
    private static final String PROPERTY_OAUTH_TOKEN = "yandex.cloud.oauth-token";
    private static final String PROPERTY_FOLDER_ID = "yandex.cloud.folder-id";
    private static final String PROPERTY_USE_GLOSSARY = "yandex.cloud.use-glossary";
    private static final String PROPERTY_KEEP_TAGS = "yandex.cloud.keep-tags";
    private static final int MAX_GLOSSARY_TERMS = 50;
    private static final int MAX_TEXT_LENGTH = 10000;
    private static final int IAM_TOKEN_TTL_SECONDS = 3600;
    private static final String IAM_TOKEN_URL = "https://iam.api.cloud.yandex.net/iam/v1/tokens";
    private static final String TRANSLATE_URL = "https://translate.api.cloud.yandex.net/translate/v2/translate";
    private String IAMErrorMessage = null;
    private String cachedIAMToken = null;
    private long lastIAMTokenTime = 0L;

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_YANDEX_CLOUD");
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String response;
        Object trText = text.length() > 10000 ? text.substring(0, 9997) + "..." : text;
        String prev = this.getFromCache(sLang, tLang, (String)trText);
        if (prev != null) {
            return prev;
        }
        String oAuthToken = this.getCredential(PROPERTY_OAUTH_TOKEN);
        if (oAuthToken == null || oAuthToken.isEmpty()) {
            throw new Exception(OStrings.getString("MT_ENGINE_YANDEX_CLOUD_OAUTH_TOKEN_NOT_FOUND"));
        }
        String folderId = this.getCredential(PROPERTY_FOLDER_ID);
        if (folderId == null || folderId.isEmpty()) {
            throw new Exception(OStrings.getString("MT_ENGINE_YANDEX_CLOUD_FOLDER_ID_NOT_FOUND"));
        }
        String IAMToken = this.getIAMToken(oAuthToken);
        if (IAMToken == null) {
            throw new Exception(this.IAMErrorMessage);
        }
        String request = this.createJsonRequest(sLang, tLang, (String)trText, folderId);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("Authorization", "Bearer " + IAMToken);
        try {
            response = HttpConnectionUtils.postJSON(TRANSLATE_URL, request, headers);
        }
        catch (HttpConnectionUtils.ResponseError e) {
            String errorMessage = this.extractErrorMessage(e.body);
            if (errorMessage == null) {
                errorMessage = OStrings.getString("MT_ENGINE_YANDEX_CLOUD_BAD_TRANSLATE_RESPONSE");
                throw new Exception(errorMessage);
            }
            throw e;
        }
        if (response == null) {
            return null;
        }
        String tr = this.extractTranslation(response);
        if (tr == null) {
            return null;
        }
        tr = this.cleanSpacesAroundTags(tr, (String)trText);
        this.putToCache(sLang, tLang, (String)trText, tr);
        return tr;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        JPanel extraPanel = new JPanel();
        extraPanel.setAlignmentX(0.0f);
        extraPanel.setLayout(new BoxLayout(extraPanel, 1));
        extraPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        final JCheckBox glossaryCheckBox = new JCheckBox(OStrings.getString("MT_ENGINE_YANDEX_CLOUD_GLOSSARY_CHECKBOX"));
        extraPanel.add(glossaryCheckBox);
        final JCheckBox keepTagsCheckBox = new JCheckBox(OStrings.getString("MT_ENGINE_YANDEX_CLOUD_KEEP_TAGS_CHECKBOX"));
        extraPanel.add(keepTagsCheckBox);
        MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                String folderId = this.panel.valueField1.getText().trim();
                YandexCloudTranslate.this.setCredential(YandexCloudTranslate.PROPERTY_FOLDER_ID, folderId, temporary);
                String oAuthToken = this.panel.valueField2.getText().trim();
                YandexCloudTranslate.this.setCredential(YandexCloudTranslate.PROPERTY_OAUTH_TOKEN, oAuthToken, temporary);
                Preferences.setPreference(YandexCloudTranslate.PROPERTY_USE_GLOSSARY, glossaryCheckBox.isSelected());
                Preferences.setPreference(YandexCloudTranslate.PROPERTY_KEEP_TAGS, keepTagsCheckBox.isSelected());
            }
        };
        dialog.panel.itemsPanel.add(extraPanel);
        dialog.panel.valueLabel1.setText(OStrings.getString("MT_ENGINE_YANDEX_CLOUD_FOLDER_ID_LABEL"));
        dialog.panel.valueField1.setText(this.getCredential(PROPERTY_FOLDER_ID));
        dialog.panel.valueLabel2.setText(OStrings.getString("MT_ENGINE_YANDEX_CLOUD_OAUTH_TOKEN_LABEL"));
        dialog.panel.valueField2.setText(this.getCredential(PROPERTY_OAUTH_TOKEN));
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(PROPERTY_OAUTH_TOKEN));
        glossaryCheckBox.setSelected(Preferences.isPreferenceDefault(PROPERTY_USE_GLOSSARY, false));
        keepTagsCheckBox.setSelected(Preferences.isPreferenceDefault(PROPERTY_KEEP_TAGS, true));
        dialog.show();
    }

    @Override
    protected String getPreferenceName() {
        return "allow_yandex_cloud_translate";
    }

    private String extractErrorMessage(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode rootNode = mapper.readTree(json);
            return rootNode.get("message").asText();
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_ENGINE_YANDEX_CLOUD_BAD_ERROR_REPORT", new Object[0]);
            return null;
        }
    }

    protected String createJsonRequest(Language sLang, Language tLang, String trText, String folderId) throws JsonProcessingException {
        Map<String, String> glossaryTerms;
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put("sourceLanguageCode", sLang.getLanguageCode().toLowerCase());
        params.put("targetLanguageCode", tLang.getLanguageCode().toLowerCase());
        params.put("folderId", folderId);
        if (Preferences.isPreference(PROPERTY_KEEP_TAGS)) {
            params.put("format", "HTML");
        }
        if (Preferences.isPreference(PROPERTY_USE_GLOSSARY) && !(glossaryTerms = this.glossarySupplier.get()).isEmpty()) {
            params.put("glossaryConfig", this.createGlossaryConfigPart(glossaryTerms));
        }
        params.put("texts", Collections.singletonList(trText));
        return new ObjectMapper().writeValueAsString(params);
    }

    protected String extractTranslation(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode rootNode = mapper.readTree(json);
            return rootNode.get("translations").get(0).get("text").asText();
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_JSON_ERROR", new Object[0]);
            return OStrings.getString("MT_ENGINE_YANDEX_CLOUD_BAD_TRANSLATE_RESPONSE");
        }
    }

    private String getIAMToken(String oAuthToken) {
        if (System.currentTimeMillis() - this.lastIAMTokenTime > 3600000L) {
            String response;
            String request = "{\"yandexPassportOauthToken\":\"" + oAuthToken + "\"}";
            ObjectMapper mapper = new ObjectMapper();
            try {
                response = HttpConnectionUtils.postJSON(IAM_TOKEN_URL, request, null);
            }
            catch (HttpConnectionUtils.ResponseError e) {
                this.IAMErrorMessage = this.extractErrorMessage(e.body);
                if (this.IAMErrorMessage == null) {
                    this.IAMErrorMessage = OStrings.getString("MT_ENGINE_YANDEX_CLOUD_BAD_IAM_RESPONSE");
                }
                return null;
            }
            catch (IOException e) {
                this.IAMErrorMessage = e.getLocalizedMessage();
                return null;
            }
            try {
                JsonNode rootNode = mapper.readTree(response);
                this.cachedIAMToken = rootNode.get("iamToken").asText();
                this.lastIAMTokenTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                Log.logErrorRB(e, "MT_ENGINE_YANDEX_CLOUD_BAD_IAM_RESPONSE", new Object[0]);
                this.IAMErrorMessage = OStrings.getString("MT_ENGINE_YANDEX_CLOUD_BAD_IAM_RESPONSE");
                return null;
            }
        }
        return this.cachedIAMToken;
    }

    protected GlossaryConfig createGlossaryConfigPart(Map<String, String> glossaryTerms) {
        ArrayList<GlossaryPair> pairs = new ArrayList<GlossaryPair>();
        for (Map.Entry<String, String> e : glossaryTerms.entrySet()) {
            pairs.add(new GlossaryPair(e.getKey(), e.getValue()));
            if (pairs.size() < 50) continue;
            break;
        }
        return new GlossaryConfig(new GlossaryData(pairs));
    }

    static class GlossaryPair {
        public final String sourceText;
        public final String translatedText;

        GlossaryPair(String sourceText, String translatedText) {
            this.sourceText = sourceText;
            this.translatedText = translatedText;
        }
    }

    static class GlossaryData {
        public final List<GlossaryPair> glossaryPairs;

        GlossaryData(List<GlossaryPair> glossaryPairs) {
            this.glossaryPairs = Collections.unmodifiableList(glossaryPairs);
        }
    }

    static class GlossaryConfig {
        public final GlossaryData glossaryData;

        GlossaryConfig(GlossaryData glossaryData) {
            this.glossaryData = glossaryData;
        }
    }
}

