/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import lts.Analyser;
import lts.CompactState;
import lts.ConnectedComponent;
import lts.CounterExample;
import lts.EventState;
import lts.LTSOutput;
import lts.Minimiser;
import lts.ProgressCheck;
import lts.Relation;

public class CompositeState {
    public static boolean minimiseFlag = false;
    public static boolean inc_min_Flag = false;
    public String name;
    public Vector machines;
    public CompactState composition;
    public Vector hidden;
    public boolean exposeNotHide = false;
    public boolean priorityIsLow = true;
    public boolean makeDeterministic = false;
    public boolean makeMinimal = false;
    public boolean makeCompose = false;
    public boolean isProperty = false;
    public Vector priorityLabels;
    public CompactState alphaStop;
    protected Vector errorTrace = null;

    public CompositeState(Vector vector) {
        this.name = "DEFAULT";
        this.machines = vector;
    }

    public CompositeState(String string, Vector vector) {
        this.name = string;
        this.machines = vector;
        this.initAlphaStop();
    }

    public Vector getErrorTrace() {
        return this.errorTrace;
    }

    public void setErrorTrace(List list) {
        if (list != null) {
            this.errorTrace = new Vector();
            this.errorTrace.addAll(list);
        }
    }

    public void compose(LTSOutput lTSOutput) {
        if (this.machines != null && this.machines.size() > 0) {
            Analyser analyser = new Analyser(this, lTSOutput, null);
            this.composition = analyser.composeNoHide();
            if (this.makeDeterministic) {
                this.applyHiding();
                this.determinise(lTSOutput);
            } else if (this.makeMinimal) {
                if (!this.incrementalMinimization(lTSOutput)) {
                    this.applyHiding();
                    this.minimise(lTSOutput);
                }
            } else {
                this.applyHiding();
            }
        }
    }

    private void applyHiding() {
        if (this.composition == null) {
            return;
        }
        if (this.hidden != null) {
            if (!this.exposeNotHide) {
                this.composition.conceal(this.hidden);
            } else {
                this.composition.expose(this.hidden);
            }
        }
    }

    boolean incrementalMinimization(LTSOutput lTSOutput) {
        Vector vector;
        if (!inc_min_Flag) {
            return false;
        }
        if (this.hidden == null) {
            return false;
        }
        if (this.composition == null) {
            return false;
        }
        if (this.composition.maxStates < 100) {
            return false;
        }
        Vector vector2 = vector = this.exposeNotHide ? this.composition.hide(this.hidden) : this.hidden;
        if (vector.size() <= 1) {
            return false;
        }
        lTSOutput.outln("***** Doing incremental minimization *****");
        long l = System.currentTimeMillis();
        CompactState compactState = this.composition;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Vector<String> vector3 = new Vector<String>(10);
            boolean bl = false;
            while (!bl && enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                vector3.addElement((String)object);
                bl = compactState.maxStates <= 100 ? false : compactState.usesLabel((String)object);
            }
            compactState.conceal(vector3);
            object = new Minimiser(compactState, lTSOutput);
            compactState = ((Minimiser)object).minimise();
        }
        this.composition = compactState;
        long l2 = System.currentTimeMillis();
        lTSOutput.outln("Incremental Minimization took: " + (l2 - l) + "ms");
        return true;
    }

    public void analyse(LTSOutput lTSOutput) {
        if (this.composition != null) {
            CounterExample counterExample = new CounterExample(this);
            counterExample.print(lTSOutput);
            this.errorTrace = counterExample.getErrorTrace();
        } else {
            Analyser analyser = new Analyser(this, lTSOutput, null);
            analyser.analyse();
            this.setErrorTrace(analyser.getErrorTrace());
        }
    }

    public void findComponents(LTSOutput lTSOutput) {
        if (this.composition != null) {
            ConnectedComponent connectedComponent = new ConnectedComponent(this.composition, lTSOutput);
            lTSOutput.outln("Connected Components: " + connectedComponent.numberComponents());
        }
    }

    public void checkProgress(LTSOutput lTSOutput) {
        ProgressCheck progressCheck;
        if (this.composition != null) {
            progressCheck = new ProgressCheck(this.composition, lTSOutput);
        } else {
            Analyser analyser = new Analyser(this, lTSOutput, null);
            progressCheck = new ProgressCheck(analyser, lTSOutput);
        }
        this.errorTrace = progressCheck.getErrorTrace();
    }

    public void minimise(LTSOutput lTSOutput) {
        if (this.composition != null) {
            Minimiser minimiser = new Minimiser(this.composition, lTSOutput);
            this.composition = minimiser.minimise();
        }
    }

    public void determinise(LTSOutput lTSOutput) {
        if (this.composition != null) {
            Minimiser minimiser = new Minimiser(this.composition, lTSOutput);
            this.composition = minimiser.trace_minimise();
            if (this.isProperty) {
                this.composition.makeProperty();
            }
        }
    }

    public CompactState create(LTSOutput lTSOutput) {
        this.compose(lTSOutput);
        if (minimiseFlag && !this.makeDeterministic && !this.makeMinimal) {
            this.minimise(lTSOutput);
        }
        return this.composition;
    }

    public boolean needNotCreate() {
        return !minimiseFlag && this.hidden == null && this.priorityLabels == null && !this.makeDeterministic && !this.makeMinimal && !this.makeCompose;
    }

    public void prefixLabels(String string) {
        this.name = string + ":" + this.name;
        this.alphaStop.prefixLabels(string);
        Enumeration enumeration = this.machines.elements();
        while (enumeration.hasMoreElements()) {
            CompactState compactState = (CompactState)enumeration.nextElement();
            compactState.prefixLabels(string);
        }
    }

    public void addAccess(Vector vector) {
        Object object;
        int n = vector.size();
        if (n == 0) {
            return;
        }
        String string = "{";
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = string + (String)object;
            if (++n2 >= n) continue;
            string = string + ",";
        }
        this.name = string + "}::" + this.name;
        this.alphaStop.addAccess(vector);
        object = this.machines.elements();
        while (object.hasMoreElements()) {
            CompactState compactState = (CompactState)object.nextElement();
            compactState.addAccess(vector);
        }
    }

    public CompactState relabel(Relation relation, LTSOutput lTSOutput) {
        this.alphaStop.relabel(relation);
        if (this.alphaStop.relabelDuplicates() && this.machines.size() > 1) {
            this.compose(lTSOutput);
            this.composition.relabel(relation);
            return this.composition;
        }
        Enumeration enumeration = this.machines.elements();
        while (enumeration.hasMoreElements()) {
            CompactState compactState = (CompactState)enumeration.nextElement();
            compactState.relabel(relation);
        }
        return null;
    }

    protected void initAlphaStop() {
        this.alphaStop = new CompactState();
        this.alphaStop.name = this.name;
        this.alphaStop.maxStates = 1;
        this.alphaStop.states = new EventState[this.alphaStop.maxStates];
        this.alphaStop.states[0] = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.machines.elements();
        while (enumeration.hasMoreElements()) {
            CompactState compactState = (CompactState)enumeration.nextElement();
            int n = 1;
            while (n < compactState.alphabet.length) {
                hashtable.put(compactState.alphabet[n], compactState.alphabet[n]);
                ++n;
            }
        }
        this.alphaStop.alphabet = new String[hashtable.size() + 1];
        this.alphaStop.alphabet[0] = "tau";
        int n = 1;
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            String string;
            this.alphaStop.alphabet[n] = string = (String)enumeration2.nextElement();
            ++n;
        }
    }
}

