<?php

/**
 * BasePerformanceTrackerLog
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                    $id                                        Type: integer(4), primary key
 * @property int                    $performance_track_id                      Type: integer(4)
 * @property string                 $log                                       Type: string(500)
 * @property string                 $comment                                   Type: string(3000)
 * @property int                    $status                                    Type: integer(2)
 * @property int                    $achievement                               Type: integer(2)
 * @property string                 $added_date                                Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                 $modified_date                             Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property int                    $reviewer_id                               Type: integer(4)
 * @property int                    $user_id                                   Type: integer(10)
 * @property PerformanceTrack       $PerformanceTrack                          
 * @property Employee               $Employee                                  
 * @property SystemUser             $SystemUser                                
 *  
 * @method int                      getId()                                    Type: integer(4), primary key
 * @method int                      getPerformanceTrackId()                    Type: integer(4)
 * @method string                   getLog()                                   Type: string(500)
 * @method string                   getComment()                               Type: string(3000)
 * @method int                      getStatus()                                Type: integer(2)
 * @method int                      getAchievement()                           Type: integer(2)
 * @method string                   getAddedDate()                             Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                   getModifiedDate()                          Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method int                      getReviewerId()                            Type: integer(4)
 * @method int                      getUserId()                                Type: integer(10)
 * @method PerformanceTrack         getPerformanceTrack()                      
 * @method Employee                 getEmployee()                              
 * @method SystemUser               getSystemUser()                            
 *  
 * @method PerformanceTrackerLog    setId(int $val)                            Type: integer(4), primary key
 * @method PerformanceTrackerLog    setPerformanceTrackId(int $val)            Type: integer(4)
 * @method PerformanceTrackerLog    setLog(string $val)                        Type: string(500)
 * @method PerformanceTrackerLog    setComment(string $val)                    Type: string(3000)
 * @method PerformanceTrackerLog    setStatus(int $val)                        Type: integer(2)
 * @method PerformanceTrackerLog    setAchievement(int $val)                   Type: integer(2)
 * @method PerformanceTrackerLog    setAddedDate(string $val)                  Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method PerformanceTrackerLog    setModifiedDate(string $val)               Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method PerformanceTrackerLog    setReviewerId(int $val)                    Type: integer(4)
 * @method PerformanceTrackerLog    setUserId(int $val)                        Type: integer(10)
 * @method PerformanceTrackerLog    setPerformanceTrack(PerformanceTrack $val) 
 * @method PerformanceTrackerLog    setEmployee(Employee $val)                 
 * @method PerformanceTrackerLog    setSystemUser(SystemUser $val)             
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BasePerformanceTrackerLog extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_performance_tracker_log');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('performance_track_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('log', 'string', 500, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 500,
             ));
        $this->hasColumn('comment', 'string', 3000, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 3000,
             ));
        $this->hasColumn('status', 'integer', 2, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 2,
             ));
        $this->hasColumn('achievement', 'integer', 2, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 2,
             ));
        $this->hasColumn('added_date', 'timestamp', 25, array(
             'type' => 'timestamp',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 25,
             ));
        $this->hasColumn('modified_date', 'timestamp', 25, array(
             'type' => 'timestamp',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 25,
             ));
        $this->hasColumn('reviewer_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('user_id', 'integer', 10, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 10,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('PerformanceTrack', array(
             'local' => 'performance_track_id',
             'foreign' => 'id'));

        $this->hasOne('Employee', array(
             'local' => 'reviewer_id',
             'foreign' => 'emp_number'));

        $this->hasOne('SystemUser', array(
             'local' => 'user_id',
             'foreign' => 'id'));
    }
}