/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix.gateway;

import com.zabbix.gateway.ItemChecker;
import com.zabbix.gateway.ZabbixException;
import com.zabbix.gateway.ZabbixItem;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalItemChecker
extends ItemChecker {
    private static final Logger logger = LoggerFactory.getLogger(InternalItemChecker.class);

    InternalItemChecker(JSONObject jSONObject) throws ZabbixException {
        super(jSONObject);
    }

    @Override
    protected String getStringValue(String string) throws Exception {
        ZabbixItem zabbixItem = new ZabbixItem(string);
        if (zabbixItem.getKeyId().equals("zabbix")) {
            if (3 != zabbixItem.getArgumentCount() || !zabbixItem.getArgument(1).equals("java") || !zabbixItem.getArgument(2).equals("")) {
                throw new ZabbixException("required key format: zabbix[java,,<parameter>]");
            }
            String string2 = zabbixItem.getArgument(3);
            if (string2.equals("version")) {
                return "6.0.24";
            }
            if (string2.equals("ping")) {
                return "1";
            }
            throw new ZabbixException("third parameter '%s' is not supported", string2);
        }
        throw new ZabbixException("key ID '%s' is not supported", zabbixItem.getKeyId());
    }
}

