/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.UndoableEdit;
import org.omegat.gui.editor.EditorTextArea3;
import org.omegat.util.gui.UIThreadsUtil;

public class TranslationUndoManager
implements UndoableEditListener {
    private final EditorTextArea3 editor;
    private final List<Change> undos = new ArrayList<Change>();
    private final List<Change> redos = new ArrayList<Change>();
    private Change currentState;
    private boolean inProgress;

    public TranslationUndoManager(EditorTextArea3 editor) {
        this.editor = editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        UIThreadsUtil.mustBeSwingThread();
        TranslationUndoManager translationUndoManager = this;
        synchronized (translationUndoManager) {
            this.undos.clear();
            this.redos.clear();
            this.currentState = null;
        }
        this.remember(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        Change ch;
        UIThreadsUtil.mustBeSwingThread();
        TranslationUndoManager translationUndoManager = this;
        synchronized (translationUndoManager) {
            if (this.undos.isEmpty()) {
                return;
            }
            if (this.currentState != null) {
                this.redos.add(this.currentState);
            }
            ch = this.currentState = this.undos.remove(this.undos.size() - 1);
        }
        if (ch != null) {
            this.apply(ch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        Change ch;
        UIThreadsUtil.mustBeSwingThread();
        TranslationUndoManager translationUndoManager = this;
        synchronized (translationUndoManager) {
            if (this.redos.isEmpty()) {
                return;
            }
            if (this.currentState != null) {
                this.undos.add(this.currentState);
            }
            ch = this.currentState = this.redos.remove(this.redos.size() - 1);
        }
        if (ch != null) {
            this.apply(ch);
        }
    }

    void apply(Change ch) {
        this.inProgress = true;
        try {
            this.editor.controller.replaceEditText(ch.text);
            if (ch.caretPos >= 0) {
                this.editor.setCaretPosition(this.editor.getOmDocument().getTranslationStart() + ch.caretPos);
            }
        }
        finally {
            this.inProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remember(int caretPos) {
        UIThreadsUtil.mustBeSwingThread();
        TranslationUndoManager translationUndoManager = this;
        synchronized (translationUndoManager) {
            Change ch = new Change();
            ch.text = this.editor.getOmDocument().extractTranslation();
            if (this.currentState != null) {
                if (ch.text.equals(this.currentState.text)) {
                    return;
                }
                this.currentState.caretPos = caretPos;
                this.undos.add(this.currentState);
            }
            this.currentState = ch;
            this.redos.clear();
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        UIThreadsUtil.mustBeSwingThread();
        if (this.inProgress || this.editor.getOmDocument().trustedChangesInProgress) {
            return;
        }
        AbstractDocument.DefaultDocumentEvent event = this.extractEvent(e.getEdit());
        if (event.getType() == DocumentEvent.EventType.CHANGE) {
            return;
        }
        int caretPos = event.getOffset() - this.editor.getOmDocument().getTranslationStart();
        if (event.getType() == DocumentEvent.EventType.REMOVE) {
            caretPos += event.getLength();
        }
        this.remember(caretPos);
    }

    private AbstractDocument.DefaultDocumentEvent extractEvent(UndoableEdit edit) {
        if (edit instanceof AbstractDocument.DefaultDocumentEvent) {
            return (AbstractDocument.DefaultDocumentEvent)edit;
        }
        if ("javax.swing.text.AbstractDocument.DefaultDocumentEventUndoableWrapper".equals(edit.getClass().getCanonicalName())) {
            try {
                return this.extractEventFromWrapper(edit);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to extract DefaultDocumentEvent from UndoableEdit", e);
            }
        }
        throw new RuntimeException("Failed to extract DefaultDocumentEvent from UndoableEdit; unknown class: " + edit.getClass().getName());
    }

    private AbstractDocument.DefaultDocumentEvent extractEventFromWrapper(UndoableEdit edit) throws Exception {
        Field ddeField = edit.getClass().getDeclaredField("dde");
        ddeField.setAccessible(true);
        return (AbstractDocument.DefaultDocumentEvent)ddeField.get(edit);
    }

    protected static final class Change {
        String text;
        int caretPos = -1;

        protected Change() {
        }
    }
}

