/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DetachedDockView;
import com.vlsolutions.swing.docking.DockTabbedPane;
import com.vlsolutions.swing.docking.DockView;
import com.vlsolutions.swing.docking.DockViewTitleBar;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.FloatingDialog;
import com.vlsolutions.swing.docking.FloatingDockableContainer;
import com.vlsolutions.swing.docking.MaximizedDockView;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.TabbedDockView;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;

public class DefaultDockableContainerFactory
extends DockableContainerFactory {
    @Override
    public SingleDockableContainer createDockableContainer(Dockable dockable, DockableContainerFactory.ParentType parentType) {
        switch (parentType) {
            case PARENT_TABBED_CONTAINER: {
                return new TabbedDockView(dockable);
            }
            case PARENT_DESKTOP: {
                return new MaximizedDockView(dockable);
            }
            case PARENT_SPLIT_CONTAINER: {
                return new DockView(dockable);
            }
            case PARENT_DETACHED_WINDOW: {
                return new DetachedDockView(dockable);
            }
        }
        throw new RuntimeException("Wrong dockable container type");
    }

    @Override
    public TabbedDockableContainer createTabbedDockableContainer() {
        return new DockTabbedPane();
    }

    @Override
    public FloatingDockableContainer createFloatingDockableContainer(Window owner) {
        if (owner instanceof Dialog) {
            return new FloatingDialog((Dialog)owner);
        }
        return new FloatingDialog((Frame)owner);
    }

    @Override
    public DockViewTitleBar createTitleBar() {
        return new DockViewTitleBar();
    }
}

