/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm;

import edu.berkeley.nlp.lm.AbstractContextEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.ConfigOptions;
import edu.berkeley.nlp.lm.ContextEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.map.ContextEncodedNgramMap;
import edu.berkeley.nlp.lm.map.HashNgramMap;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.values.ProbBackoffPair;
import edu.berkeley.nlp.lm.values.ProbBackoffValueContainer;
import java.io.Serializable;

public class ContextEncodedProbBackoffLm<W>
extends AbstractContextEncodedNgramLanguageModel<W>
implements ContextEncodedNgramLanguageModel<W>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final HashNgramMap<ProbBackoffPair> map;
    private final ProbBackoffValueContainer values;
    private final long numWords;

    public ContextEncodedProbBackoffLm(int lmOrder, WordIndexer<W> wordIndexer, ContextEncodedNgramMap<ProbBackoffPair> map, ConfigOptions opts) {
        super(lmOrder, wordIndexer, (float)opts.unknownWordLogProb);
        this.map = (HashNgramMap)map;
        this.values = (ProbBackoffValueContainer)map.getValues();
        this.numWords = map.getNumNgrams(0);
    }

    @Override
    public float getLogProb(long contextOffset, int contextOrder, int word, @Annotations.OutputParameter ContextEncodedNgramLanguageModel.LmContextInfo outputContext) {
        if (word < 0 || (long)word >= this.numWords) {
            return this.oovReturn(outputContext);
        }
        HashNgramMap<ProbBackoffPair> localMap = this.map;
        long longestOffset = -2L;
        int longestOrder = -2;
        float backoffSum = 0.0f;
        long currContextOffset = contextOffset;
        for (int currContextOrder = contextOrder; currContextOrder >= 0; --currContextOrder) {
            float backOff;
            int ngramOrder = currContextOrder + 1;
            long offset = localMap.getOffset(currContextOffset, currContextOrder, word);
            if (offset >= 0L) {
                float prob;
                if (longestOffset == -2L) {
                    longestOffset = offset;
                    longestOrder = ngramOrder;
                }
                if (!Float.isNaN(prob = this.values.getProb(ngramOrder, offset))) {
                    this.setOutputContext(outputContext, longestOffset, longestOrder);
                    return backoffSum + prob;
                }
            }
            backoffSum += Float.isNaN(backOff = this.values.getBackoff(currContextOrder, currContextOffset)) ? 0.0f : backOff;
            if (currContextOrder <= 0) continue;
            currContextOffset = this.values.getSuffixOffset(currContextOffset, currContextOrder);
        }
        long offset = word;
        boolean ngramOrder = false;
        float prob = this.values.getProb(0, offset);
        if (Float.isNaN(prob)) {
            return this.oovReturn(outputContext);
        }
        this.setOutputContext(outputContext, longestOffset == -2L ? offset : longestOffset, longestOffset == -2L ? 0 : longestOrder);
        return backoffSum + prob;
    }

    private float oovReturn(ContextEncodedNgramLanguageModel.LmContextInfo outputContext) {
        if (outputContext != null) {
            outputContext.offset = 0L;
            outputContext.order = -1;
        }
        return this.oovWordLogProb;
    }

    @Override
    public ContextEncodedNgramLanguageModel.LmContextInfo getOffsetForNgram(int[] ngram, int startPos, int endPos) {
        return this.map.getOffsetForNgram(ngram, startPos, endPos);
    }

    @Override
    public int[] getNgramForOffset(long contextOffset, int contextOrder, int word) {
        return this.map.getNgramFromContextEncoding(contextOffset, contextOrder, word);
    }

    public NgramMap<ProbBackoffPair> getNgramMap() {
        return this.map;
    }

    private void setOutputContext(ContextEncodedNgramLanguageModel.LmContextInfo outputContext, long offset, int ngramOrder) {
        if (outputContext != null) {
            if (ngramOrder == this.lmOrder - 1) {
                long suffixOffset;
                outputContext.offset = suffixOffset = this.values.getSuffixOffset(offset, ngramOrder);
                outputContext.order = ngramOrder - 1;
            } else {
                outputContext.offset = offset;
                outputContext.order = ngramOrder;
            }
        }
    }
}

