/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.NilVector;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SeekableStringWriter;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.StreamError;
import org.armedbear.lisp.Symbol;

public final class StringOutputStream
extends Stream {
    private final SeekableStringWriter stringWriter;
    private static final Primitive MAKE_STRING_OUTPUT_STREAM = new Primitive("%make-string-output-stream", Lisp.PACKAGE_SYS, false, "element-type"){

        @Override
        public LispObject execute(LispObject arg) {
            return new StringOutputStream(arg);
        }
    };
    private static final Primitive GET_OUTPUT_STREAM_STRING = new Primitive("get-output-stream-string", "string-output-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof StringOutputStream) {
                return ((StringOutputStream)arg).getSimpleStringAndClear();
            }
            return Lisp.type_error(this, Symbol.STRING_OUTPUT_STREAM);
        }
    };

    public StringOutputStream() {
        this((LispObject)Symbol.CHARACTER);
    }

    StringOutputStream(LispObject elementType) {
        super(Symbol.STRING_OUTPUT_STREAM);
        this.elementType = elementType;
        this.eolStyle = Stream.EolStyle.RAW;
        this.stringWriter = new SeekableStringWriter();
        this.initAsCharacterOutputStream(this.stringWriter);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.STRING_OUTPUT_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.STRING_OUTPUT_STREAM;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.STRING_OUTPUT_STREAM) {
            return Lisp.T;
        }
        if (type == Symbol.STRING_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.STRING_OUTPUT_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.STRING_STREAM) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    protected long _getFilePosition() {
        if (this.elementType == Lisp.NIL) {
            return 0L;
        }
        return this.stringWriter.getOffset();
    }

    @Override
    protected boolean _setFilePosition(LispObject arg) {
        if (this.elementType == Lisp.NIL) {
            return false;
        }
        try {
            int offset;
            if (arg == Keyword.START) {
                offset = 0;
            } else if (arg == Keyword.END) {
                offset = this.stringWriter.getBuffer().length();
            } else {
                long n = Fixnum.getValue(arg);
                offset = (int)n;
            }
            this.stringWriter.seek(offset);
            this.offset = offset;
        }
        catch (IllegalArgumentException e) {
            Lisp.error(new StreamError((Stream)this, e));
        }
        return true;
    }

    public LispObject getString() {
        if (this.elementType == Lisp.NIL) {
            return new NilVector(0);
        }
        StringBuffer sb = this.stringWriter.getBuffer();
        SimpleString s = new SimpleString(sb);
        sb.setLength(0);
        return s;
    }

    public LispObject getSimpleStringAndClear() {
        if (this.elementType == Lisp.NIL) {
            return new NilVector(0);
        }
        String contents = this.stringWriter.toStringAndClear();
        return new SimpleString(contents);
    }
}

